/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.impl.classic.CloseableDelegate;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.util.Args;

public final class CloseableHttpResponse
implements ClassicHttpResponse,
ModalCloseable {
    private final ClassicHttpResponse response;
    private final CloseableDelegate closeableDelegate;

    @Internal
    public static CloseableHttpResponse adapt(ClassicHttpResponse response2) {
        if (response2 == null) {
            return null;
        }
        return response2 instanceof CloseableHttpResponse ? (CloseableHttpResponse)response2 : new CloseableHttpResponse(response2);
    }

    @Internal
    public static CloseableHttpResponse create(ClassicHttpResponse response2, CloseableDelegate closeableDelegate) {
        if (response2 == null) {
            return null;
        }
        return new CloseableHttpResponse(response2, closeableDelegate);
    }

    CloseableHttpResponse(ClassicHttpResponse response2) {
        this.response = Args.notNull(response2, "Response");
        this.closeableDelegate = null;
    }

    CloseableHttpResponse(ClassicHttpResponse response2, CloseableDelegate closeableDelegate) {
        this.response = Args.notNull(response2, "Response");
        this.closeableDelegate = closeableDelegate;
    }

    CloseableHttpResponse(ClassicHttpResponse response2, ExecRuntime execRuntime) {
        this.response = Args.notNull(response2, "Response");
        this.closeableDelegate = (closeable, closeMode) -> {
            try {
                if (closeMode == CloseMode.GRACEFUL) {
                    response2.close();
                }
                execRuntime.disconnectEndpoint();
            }
            finally {
                execRuntime.discardEndpoint();
            }
        };
    }

    @Override
    public int getCode() {
        return this.response.getCode();
    }

    @Override
    public HttpEntity getEntity() {
        return this.response.getEntity();
    }

    @Override
    public boolean containsHeader(String name2) {
        return this.response.containsHeader(name2);
    }

    @Override
    public void setVersion(ProtocolVersion version) {
        this.response.setVersion(version);
    }

    @Override
    public void setCode(int code) {
        this.response.setCode(code);
    }

    @Override
    public String getReasonPhrase() {
        return this.response.getReasonPhrase();
    }

    @Override
    public int countHeaders(String name2) {
        return this.response.countHeaders(name2);
    }

    @Override
    public void setEntity(HttpEntity entity) {
        this.response.setEntity(entity);
    }

    @Override
    public ProtocolVersion getVersion() {
        return this.response.getVersion();
    }

    @Override
    public void setReasonPhrase(String reason) {
        this.response.setReasonPhrase(reason);
    }

    @Override
    public Header[] getHeaders(String name2) {
        return this.response.getHeaders(name2);
    }

    @Override
    public void addHeader(Header header) {
        this.response.addHeader(header);
    }

    @Override
    public Locale getLocale() {
        return this.response.getLocale();
    }

    @Override
    public void addHeader(String name2, Object value) {
        this.response.addHeader(name2, value);
    }

    @Override
    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    @Override
    public Header getHeader(String name2) throws ProtocolException {
        return this.response.getHeader(name2);
    }

    @Override
    public void setHeader(Header header) {
        this.response.setHeader(header);
    }

    @Override
    public Header getFirstHeader(String name2) {
        return this.response.getFirstHeader(name2);
    }

    @Override
    public void setHeader(String name2, Object value) {
        this.response.setHeader(name2, value);
    }

    @Override
    public void setHeaders(Header ... headers) {
        this.response.setHeaders(headers);
    }

    @Override
    public boolean removeHeader(Header header) {
        return this.response.removeHeader(header);
    }

    @Override
    public boolean removeHeaders(String name2) {
        return this.response.removeHeaders(name2);
    }

    @Override
    public Header getLastHeader(String name2) {
        return this.response.getLastHeader(name2);
    }

    @Override
    public Header[] getHeaders() {
        return this.response.getHeaders();
    }

    @Override
    public Iterator<Header> headerIterator() {
        return this.response.headerIterator();
    }

    @Override
    public Iterator<Header> headerIterator(String name2) {
        return this.response.headerIterator(name2);
    }

    private void doClose(CloseMode closeMode) throws IOException {
        if (this.closeableDelegate != null) {
            this.closeableDelegate.close(this.response, closeMode);
        } else {
            this.response.close();
        }
    }

    @Override
    public void close(CloseMode closeMode) {
        try {
            this.doClose(closeMode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        this.doClose(CloseMode.GRACEFUL);
    }

    public String toString() {
        return this.response.toString();
    }
}

