/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicListHeaderIterator;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TextUtils;

public class HeaderGroup
implements MessageHeaders,
Serializable {
    private static final long serialVersionUID = 2608834160639271617L;
    private static final Header[] EMPTY = new Header[0];
    private final List<Header> headers = new ArrayList<Header>(16);

    public void clear() {
        this.headers.clear();
    }

    public void addHeader(Header header) {
        if (header == null) {
            return;
        }
        this.headers.add(header);
    }

    public boolean removeHeader(Header header) {
        if (header == null) {
            return false;
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            Header current = this.headers.get(i);
            if (!this.headerEquals(header, current)) continue;
            this.headers.remove(current);
            return true;
        }
        return false;
    }

    private boolean headerEquals(Header header1, Header header2) {
        return header2 == header1 || header2.getName().equalsIgnoreCase(header1.getName()) && Objects.equals(header1.getValue(), header2.getValue());
    }

    public boolean removeHeaders(Header header) {
        if (header == null) {
            return false;
        }
        boolean removed = false;
        Iterator<Header> iterator = this.headerIterator();
        while (iterator.hasNext()) {
            Header current = iterator.next();
            if (!this.headerEquals(header, current)) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    public void setHeader(Header header) {
        if (header == null) {
            return;
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            Header current = this.headers.get(i);
            if (!current.getName().equalsIgnoreCase(header.getName())) continue;
            this.headers.set(i, header);
            return;
        }
        this.headers.add(header);
    }

    public void setHeaders(Header ... headers) {
        this.clear();
        if (headers == null) {
            return;
        }
        Collections.addAll(this.headers, headers);
    }

    public Header getCondensedHeader(String name2) {
        Header[] hdrs = this.getHeaders(name2);
        if (hdrs.length == 0) {
            return null;
        }
        if (hdrs.length == 1) {
            return hdrs[0];
        }
        CharArrayBuffer valueBuffer = new CharArrayBuffer(128);
        valueBuffer.append(hdrs[0].getValue());
        for (int i = 1; i < hdrs.length; ++i) {
            valueBuffer.append(", ");
            valueBuffer.append(hdrs[i].getValue());
        }
        return new BasicHeader(TextUtils.toLowerCase(name2), valueBuffer.toString());
    }

    @Override
    public Header[] getHeaders(String name2) {
        ArrayList<Header> headersFound = null;
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name2)) continue;
            if (headersFound == null) {
                headersFound = new ArrayList<Header>();
            }
            headersFound.add(header);
        }
        return headersFound != null ? headersFound.toArray(EMPTY) : EMPTY;
    }

    @Override
    public Header getFirstHeader(String name2) {
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name2)) continue;
            return header;
        }
        return null;
    }

    @Override
    public Header getHeader(String name2) throws ProtocolException {
        int count2 = 0;
        Header singleHeader = null;
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name2)) continue;
            singleHeader = header;
            ++count2;
        }
        if (count2 > 1) {
            throw new ProtocolException("multiple '%s' headers found", name2);
        }
        return singleHeader;
    }

    @Override
    public Header getLastHeader(String name2) {
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name2)) continue;
            return header;
        }
        return null;
    }

    @Override
    public Header[] getHeaders() {
        return this.headers.toArray(EMPTY);
    }

    @Override
    public boolean containsHeader(String name2) {
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int countHeaders(String name2) {
        int count2 = 0;
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name2)) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public Iterator<Header> headerIterator() {
        return new BasicListHeaderIterator(this.headers, null);
    }

    @Override
    public Iterator<Header> headerIterator(String name2) {
        return new BasicListHeaderIterator(this.headers, name2);
    }

    public boolean removeHeaders(String name2) {
        if (name2 == null) {
            return false;
        }
        boolean removed = false;
        Iterator<Header> iterator = this.headerIterator();
        while (iterator.hasNext()) {
            Header header = iterator.next();
            if (!header.getName().equalsIgnoreCase(name2)) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    public String toString() {
        return this.headers.toString();
    }
}

