/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ViaRequest
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new ViaRequest();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context2) throws ProtocolException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(context2, "HTTP context");
        ProtocolVersion ver = context2.getProtocolVersion() != null ? context2.getProtocolVersion() : HttpVersion.HTTP_1_1;
        URIAuthority authority = request.getAuthority();
        if (authority == null) {
            throw new ProtocolException("Request authority not specified");
        }
        if (!ver.greaterEquals(HttpVersion.HTTP_1_1)) {
            throw new ProtocolException("Invalid protocol version: %s", ver);
        }
        if (!request.containsHeader("Via")) {
            String viaHeaderValue = ver.getProtocol() + " " + ver.getMajor() + "." + ver.getMinor() + " " + authority.getHostName();
            int port = authority.getPort();
            if (port != -1) {
                viaHeaderValue = viaHeaderValue + ":" + port;
            }
            request.addHeader("Via", viaHeaderValue);
        }
    }
}

