/*
 * Decompiled with CFR 0.152.
 */
package com.agentclientprotocol.rpc;

import com.agentclientprotocol.rpc.IntRequestId;
import com.agentclientprotocol.rpc.RequestId;
import com.agentclientprotocol.rpc.StringRequestId;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/agentclientprotocol/rpc/RequestIdSerializer;", "Lkotlinx/serialization/KSerializer;", "Lcom/agentclientprotocol/rpc/RequestId;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "acp-model"})
public final class RequestIdSerializer
implements KSerializer<RequestId> {
    @NotNull
    public static final RequestIdSerializer INSTANCE = new RequestIdSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"RequestId", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

    private RequestIdSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull RequestId value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        RequestId requestId = value;
        if (requestId instanceof IntRequestId) {
            encoder.encodeInt(((IntRequestId)value).getValue().intValue());
        } else if (requestId instanceof StringRequestId) {
            encoder.encodeString(((StringRequestId)value).getValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public RequestId deserialize(@NotNull Decoder decoder) {
        RequestId requestId;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonDecoder jsonDecoder = decoder instanceof JsonDecoder ? (JsonDecoder)decoder : null;
        if (jsonDecoder == null) {
            throw new SerializationException("RequestId can only be deserialized from JSON");
        }
        JsonDecoder jsonDecoder2 = jsonDecoder;
        JsonElement element = jsonDecoder2.decodeJsonElement();
        if (element instanceof JsonPrimitive) {
            if (((JsonPrimitive)element).isString()) {
                requestId = new StringRequestId(((JsonPrimitive)element).getContent());
            } else {
                IntRequestId intRequestId;
                try {
                    intRequestId = new IntRequestId(Integer.parseInt(((JsonPrimitive)element).getContent()));
                }
                catch (NumberFormatException e) {
                    throw new SerializationException("RequestId must be an int or string", (Throwable)e);
                }
                requestId = intRequestId;
            }
        } else {
            throw new SerializationException("RequestId must be a primitive (int or string)");
        }
        return requestId;
    }
}

