/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.ProjectFileStructure;
import com.intellij.ml.llm.matterhorn.ProjectFileStructureChange;
import com.intellij.ml.llm.matterhorn.ProjectFileStructureUpdateFileChange$;
import com.intellij.ml.llm.matterhorn.ProjectStructureFile;
import com.intellij.ml.llm.matterhorn.ProjectStructureItem;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SerialName(value="Update")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 *2\u00020\u0001:\u0002)*B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bBC\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\nH\u00d6\u0001J%\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006+"}, d2={"Lcom/intellij/ml/llm/matterhorn/ProjectFileStructureUpdateFileChange;", "Lcom/intellij/ml/llm/matterhorn/ProjectFileStructureChange;", "oldFilePath", "", "newFilePath", "patchText", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getOldFilePath", "()Ljava/lang/String;", "getNewFilePath", "getPatchText", "getDescription", "applyChange", "", "structure", "Lcom/intellij/ml/llm/matterhorn/ProjectFileStructure;", "toString", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "$serializer", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nProjectFileStructureChange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectFileStructureChange.kt\ncom/intellij/ml/llm/matterhorn/ProjectFileStructureUpdateFileChange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class ProjectFileStructureUpdateFileChange
implements ProjectFileStructureChange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String oldFilePath;
    @NotNull
    private final String newFilePath;
    @NotNull
    private final String patchText;
    @NotNull
    private final String description;

    public ProjectFileStructureUpdateFileChange(@NotNull String oldFilePath, @NotNull String newFilePath, @NotNull String patchText, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)oldFilePath, (String)"oldFilePath");
        Intrinsics.checkNotNullParameter((Object)newFilePath, (String)"newFilePath");
        Intrinsics.checkNotNullParameter((Object)patchText, (String)"patchText");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.oldFilePath = oldFilePath;
        this.newFilePath = newFilePath;
        this.patchText = patchText;
        this.description = description;
    }

    @NotNull
    public final String getOldFilePath() {
        return this.oldFilePath;
    }

    @NotNull
    public final String getNewFilePath() {
        return this.newFilePath;
    }

    @NotNull
    public final String getPatchText() {
        return this.patchText;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Override
    public void applyChange(@NotNull ProjectFileStructure structure) {
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        ProjectStructureItem projectStructureItem = structure.getRoot().findChild(this.oldFilePath);
        if (projectStructureItem == null) {
            boolean $i$a$-requireNotNull-ProjectFileStructureUpdateFileChange$applyChange$oldFile$22 = false;
            String $i$a$-requireNotNull-ProjectFileStructureUpdateFileChange$applyChange$oldFile$22 = this.oldFilePath + " does not exist.";
            throw new IllegalArgumentException($i$a$-requireNotNull-ProjectFileStructureUpdateFileChange$applyChange$oldFile$22.toString());
        }
        Intrinsics.checkNotNull((Object)projectStructureItem, (String)"null cannot be cast to non-null type com.intellij.ml.llm.matterhorn.ProjectStructureFile");
        ProjectStructureFile oldFile = (ProjectStructureFile)projectStructureItem;
        PatchReader reader = new PatchReader((CharSequence)this.patchText);
        List list = reader.readTextPatches();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readTextPatches(...)");
        List patches = list;
        String newFileContent = null;
        if (patches.isEmpty()) {
            newFileContent = oldFile.getContent();
        } else {
            TextFilePatch parsedPatch = (TextFilePatch)CollectionsKt.single((List)patches);
            GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply((CharSequence)oldFile.getContent(), (List)parsedPatch.getHunks());
            if (appliedPatch == null) {
                throw new IllegalStateException("Failed to apply patch");
            }
            newFileContent = appliedPatch.patchedText;
        }
        structure.getRoot().removeChild(this.oldFilePath);
        structure.getRoot().updateOrCreateFile(this.newFilePath, newFileContent);
    }

    @NotNull
    public String toString() {
        String filePath = Intrinsics.areEqual((Object)this.oldFilePath, (Object)this.newFilePath) ? this.newFilePath : this.oldFilePath + " -> " + this.newFilePath;
        return "## Update " + filePath + "\n\n" + this.description + "\n\n```\n" + this.patchText + "\n```\n";
    }

    @NotNull
    public final String component1() {
        return this.oldFilePath;
    }

    @NotNull
    public final String component2() {
        return this.newFilePath;
    }

    @NotNull
    public final String component3() {
        return this.patchText;
    }

    @NotNull
    public final String component4() {
        return this.description;
    }

    @NotNull
    public final ProjectFileStructureUpdateFileChange copy(@NotNull String oldFilePath, @NotNull String newFilePath, @NotNull String patchText, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)oldFilePath, (String)"oldFilePath");
        Intrinsics.checkNotNullParameter((Object)newFilePath, (String)"newFilePath");
        Intrinsics.checkNotNullParameter((Object)patchText, (String)"patchText");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return new ProjectFileStructureUpdateFileChange(oldFilePath, newFilePath, patchText, description);
    }

    public static /* synthetic */ ProjectFileStructureUpdateFileChange copy$default(ProjectFileStructureUpdateFileChange projectFileStructureUpdateFileChange, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = projectFileStructureUpdateFileChange.oldFilePath;
        }
        if ((n & 2) != 0) {
            string2 = projectFileStructureUpdateFileChange.newFilePath;
        }
        if ((n & 4) != 0) {
            string3 = projectFileStructureUpdateFileChange.patchText;
        }
        if ((n & 8) != 0) {
            string4 = projectFileStructureUpdateFileChange.description;
        }
        return projectFileStructureUpdateFileChange.copy(string, string2, string3, string4);
    }

    public int hashCode() {
        int result = this.oldFilePath.hashCode();
        result = result * 31 + this.newFilePath.hashCode();
        result = result * 31 + this.patchText.hashCode();
        result = result * 31 + this.description.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProjectFileStructureUpdateFileChange)) {
            return false;
        }
        ProjectFileStructureUpdateFileChange projectFileStructureUpdateFileChange = (ProjectFileStructureUpdateFileChange)other;
        if (!Intrinsics.areEqual((Object)this.oldFilePath, (Object)projectFileStructureUpdateFileChange.oldFilePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.newFilePath, (Object)projectFileStructureUpdateFileChange.newFilePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.patchText, (Object)projectFileStructureUpdateFileChange.patchText)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.description, (Object)projectFileStructureUpdateFileChange.description);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(ProjectFileStructureUpdateFileChange self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        output2.encodeStringElement(serialDesc, 0, self.oldFilePath);
        output2.encodeStringElement(serialDesc, 1, self.newFilePath);
        output2.encodeStringElement(serialDesc, 2, self.patchText);
        output2.encodeStringElement(serialDesc, 3, self.description);
    }

    public /* synthetic */ ProjectFileStructureUpdateFileChange(int seen0, String oldFilePath, String newFilePath, String patchText, String description, SerializationConstructorMarker serializationConstructorMarker) {
        if (15 != (0xF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)15, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.oldFilePath = oldFilePath;
        this.newFilePath = newFilePath;
        this.patchText = patchText;
        this.description = description;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/matterhorn/ProjectFileStructureUpdateFileChange$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/matterhorn/ProjectFileStructureUpdateFileChange;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ProjectFileStructureUpdateFileChange> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

