/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.Result;
import com.intellij.ml.llm.matterhorn.actions.AgentResult;
import com.intellij.ml.llm.matterhorn.actions.AgentUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.LocateTarget;
import com.intellij.ml.llm.matterhorn.actions.OpenFileErrorType;
import com.intellij.ml.llm.matterhorn.run.ExecutionPath;
import com.intellij.ml.llm.matterhorn.run.LocalPath;
import com.intellij.ml.llm.matterhorn.run.PathConverter;
import com.intellij.ml.llm.matterhorn.services.ProjectSearchEverywhereService;
import com.intellij.ml.llm.matterhorn.services.search.SearchQuery;
import com.intellij.ml.llm.matterhorn.services.search.SearchResultItem;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u00a6\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0006\u001am\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0015*\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00152;\u0010\u0016\u001a7\u0012\u001d\u0012\u001b\u0012\u0004\u0012\u00020\u000f0\u0013j\u0002`\u001b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00150\u0017H\u0086\b\u00f8\u0001\u0000\u001am\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0015*\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00152;\u0010\u0016\u001a7\u0012\u001d\u0012\u001b\u0012\u0004\u0012\u00020\u000f0\u0013j\u0002`\u001b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00150\u0017H\u0086\b\u00f8\u0001\u0000\u001a0\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!\u001a.\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00152\u0006\u0010#\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!\u001a0\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00152\u0006\u0010%\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002\u001a8\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00152\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+H\u0086@\u00a2\u0006\u0002\u0010,\u001a@\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00152\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020)2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010*\u001a\u00020+H\u0086@\u00a2\u0006\u0002\u00100\u001aD\u00101\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00102\u001a\u00020\u00062\n\u00103\u001a\u000604j\u0002`52\u0006\u00106\u001a\u0002042\u0006\u0010 \u001a\u00020!2\b\b\u0002\u00107\u001a\u00020\u0001H\u0086@\u00a2\u0006\u0002\u00108\u001a<\u00101\u001a\u00020\u00012\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\n\u00103\u001a\u000604j\u0002`52\u0006\u00106\u001a\u0002042\u0006\u0010 \u001a\u00020!2\b\b\u0002\u00107\u001a\u00020\u0001\u001a4\u00101\u001a\u00020\u00012\n\u00103\u001a\u000604j\u0002`52\u0006\u00106\u001a\u0002042\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\b\b\u0002\u00107\u001a\u00020\u0001\u001a\"\u0010?\u001a\u0002042\n\u0010@\u001a\u000604j\u0002`52\u0006\u0010A\u001a\u0002042\u0006\u0010B\u001a\u000204\u001a.\u0010C\u001a\u00020\u00012\n\u00103\u001a\u000604j\u0002`52\u0006\u00107\u001a\u00020\u00012\n\u0010D\u001a\u000604j\u0002`52\u0006\u0010;\u001a\u00020<\u001a\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00010F2\u0006\u0010G\u001a\u00020\u0001\u001a\u0010\u0010H\u001a\u00020\u0001*\u00060Ij\u0002`JH\u0000\"\u001b\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004*\"\u0010\r\"\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000e*\u0016\u0010\u0010\"\b\u0012\u0004\u0012\u00020\u00060\u00112\b\u0012\u0004\u0012\u00020\u00060\u0011*\u0016\u0010\u0012\"\b\u0012\u0004\u0012\u00020\u000f0\u00132\b\u0012\u0004\u0012\u00020\u000f0\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006K"}, d2={"text", "", "Lcom/intellij/ml/llm/matterhorn/actions/AgentResult;", "getText", "(Lcom/intellij/ml/llm/matterhorn/actions/AgentResult;)Ljava/lang/String;", "relativeName", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "relativePath", "Lcom/intellij/psi/PsiFile;", "toNioPathOrNull", "Ljava/nio/file/Path;", "OpenFileResult", "Lcom/intellij/ml/llm/matterhorn/Result;", "Lcom/intellij/ml/llm/matterhorn/actions/OpenFileErrorType;", "OpenFileSuccess", "Lcom/intellij/ml/llm/matterhorn/Result$Ok;", "OpenFileError", "Lcom/intellij/ml/llm/matterhorn/Result$Err;", "ifDoesNotExist", "Lcom/intellij/ml/llm/matterhorn/actions/OpenFileResult;", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "e", "Lcom/intellij/ml/llm/matterhorn/actions/OpenFileError;", "ifUnexpectedType", "locateDirectory", "directoryExecutionPath", "currentDir", "pathConverter", "Lcom/intellij/ml/llm/matterhorn/run/PathConverter;", "locateFile", "fileExecutionPath", "locateDirectoryOrFile", "path", "smartLocateFile", "executionPath", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "allowOnlyProjectFile", "", "(Ljava/lang/String;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "smartLocate", "target", "Lcom/intellij/ml/llm/matterhorn/actions/LocateTarget;", "(Ljava/lang/String;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lcom/intellij/ml/llm/matterhorn/actions/LocateTarget;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "printScreen", "file", "startLine", "", "Lcom/intellij/ml/llm/matterhorn/OneBasedIndex;", "window", "separator", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;IILcom/intellij/ml/llm/matterhorn/run/PathConverter;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "localPath", "Lcom/intellij/ml/llm/matterhorn/run/LocalPath;", "document", "Lcom/intellij/openapi/editor/Document;", "executionFilePath", "Lcom/intellij/ml/llm/matterhorn/run/ExecutionPath;", "constraintStartLineNum", "lineNum", "windowSize", "totalLines", "printScreenPart", "endLineExcl", "parseArgs", "", "args", "parseArgument", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ej-core"})
@SourceDebugExtension(value={"SMAP\nAgentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentUtils.kt\ncom/intellij/ml/llm/matterhorn/actions/AgentUtilsKt\n+ 2 Result.kt\ncom/intellij/ml/llm/matterhorn/ResultKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n77#1:347\n78#1,3:350\n69#1:354\n70#1,2:357\n69#1:359\n70#1,2:362\n69#1:364\n70#1,2:367\n72#1:384\n72#1:386\n72#1:388\n76#2,4:339\n76#2,4:343\n76#2,2:348\n79#2:353\n76#2,2:355\n76#2,2:360\n76#2,2:365\n79#2:385\n79#2:387\n79#2:389\n83#2,4:390\n31#3,2:369\n1611#4,9:371\n1863#4:380\n1864#4:382\n1620#4:383\n1#5:381\n*S KotlinDebug\n*F\n+ 1 AgentUtils.kt\ncom/intellij/ml/llm/matterhorn/actions/AgentUtilsKt\n*L\n139#1:347\n139#1:350,3\n163#1:354\n163#1:357,2\n165#1:359\n165#1:362,2\n167#1:364\n167#1:367,2\n167#1:384\n165#1:386\n163#1:388\n69#1:339,4\n77#1:343,4\n139#1:348,2\n139#1:353\n163#1:355,2\n165#1:360,2\n167#1:365,2\n167#1:385\n165#1:387\n163#1:389\n203#1:390,4\n168#1:369,2\n188#1:371,9\n188#1:380\n188#1:382\n188#1:383\n188#1:381\n*E\n"})
public final class AgentUtilsKt {
    @NotNull
    public static final String getText(@NotNull AgentResult<String> $this$text) {
        String string;
        Intrinsics.checkNotNullParameter($this$text, (String)"<this>");
        AgentResult<String> agentResult = $this$text;
        if (agentResult instanceof AgentResult.Failure) {
            string = ((AgentResult.Failure)$this$text).getText();
        } else if (agentResult instanceof AgentResult.Success) {
            string = (String)((AgentResult.Success)$this$text).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String relativeName(@NotNull VirtualFile $this$relativeName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$relativeName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = VirtualFileUtil.toNioPathOrNull((VirtualFile)$this$relativeName);
        Path path2 = path;
        if (path == null) return null;
        String string = project.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        Path path3 = Path.of(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
        Path path4 = PathsKt.relativeToOrNull((Path)path2, (Path)path3);
        path2 = path4;
        if (path4 == null) return null;
        String string2 = ((Object)path2).toString();
        return string2;
    }

    @Nullable
    public static final String relativePath(@NotNull PsiFile $this$relativePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$relativePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = $this$relativePath.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return AgentUtilsKt.relativeName(virtualFile, project);
    }

    @Nullable
    public static final Path toNioPathOrNull(@NotNull VirtualFile $this$toNioPathOrNull) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$toNioPathOrNull, (String)"<this>");
        try {
            path = $this$toNioPathOrNull.toNioPath();
        }
        catch (UnsupportedOperationException e) {
            path = null;
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result<VirtualFile, OpenFileErrorType> ifDoesNotExist(@NotNull Result<? extends VirtualFile, ? extends OpenFileErrorType> $this$ifDoesNotExist, @NotNull Function1<? super Result.Err<OpenFileErrorType>, ? extends Result<? extends VirtualFile, ? extends OpenFileErrorType>> action2) {
        void var3_3;
        Intrinsics.checkNotNullParameter($this$ifDoesNotExist, (String)"<this>");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$ifDoesNotExist = false;
        Result<? extends VirtualFile, ? extends OpenFileErrorType> $this$ifError$iv = $this$ifDoesNotExist;
        boolean $i$f$ifError = false;
        if ($this$ifError$iv instanceof Result.Err) {
            Result.Err it = (Result.Err)$this$ifError$iv;
            boolean bl = false;
            if (it.getError() == OpenFileErrorType.doesNotExist) {
                return (Result)action2.invoke((Object)it);
            }
            return it;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result<VirtualFile, OpenFileErrorType> ifUnexpectedType(@NotNull Result<? extends VirtualFile, ? extends OpenFileErrorType> $this$ifUnexpectedType, @NotNull Function1<? super Result.Err<OpenFileErrorType>, ? extends Result<? extends VirtualFile, ? extends OpenFileErrorType>> action2) {
        void var3_3;
        Intrinsics.checkNotNullParameter($this$ifUnexpectedType, (String)"<this>");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$ifUnexpectedType = false;
        Result<? extends VirtualFile, ? extends OpenFileErrorType> $this$ifError$iv = $this$ifUnexpectedType;
        boolean $i$f$ifError = false;
        if ($this$ifError$iv instanceof Result.Err) {
            Result.Err it = (Result.Err)$this$ifError$iv;
            boolean bl = false;
            if (it.getError() == OpenFileErrorType.unexpectedType) {
                return (Result)action2.invoke((Object)it);
            }
            return it;
        }
        return var3_3;
    }

    @NotNull
    public static final Result<VirtualFile, OpenFileErrorType> locateDirectory(@Nullable String directoryExecutionPath, @NotNull VirtualFile currentDir, @NotNull PathConverter pathConverter) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)currentDir, (String)"currentDir");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        if (directoryExecutionPath != null) {
            Path path = currentDir.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            ExecutionPath currentDirExecutionPath = pathConverter.convertLocalPathToExecutionPath(new LocalPath(path));
            ExecutionPath absoluteDirectoryExecutionPath = !StringsKt.startsWith$default((String)directoryExecutionPath, (String)"/", (boolean)false, (int)2, null) ? new ExecutionPath(currentDirExecutionPath.getPath() + "/" + directoryExecutionPath) : new ExecutionPath(directoryExecutionPath);
            LocalPath localPath = pathConverter.convertExecutionPathToLocalPath(absoluteDirectoryExecutionPath);
            if (!Files.exists(localPath.getPath(), new LinkOption[0])) {
                return new Result.Err<OpenFileErrorType>(OpenFileErrorType.doesNotExist, "ERROR: Path does not exist: \"" + absoluteDirectoryExecutionPath + "\"");
            }
            VirtualFile file = VfsUtil.findFile((Path)localPath.getPath(), (boolean)true);
            if (file == null || !file.isDirectory()) {
                return file == null ? (Result)new Result.Err<OpenFileErrorType>(OpenFileErrorType.doesNotExist, "ERROR: Path does not exist: \"" + absoluteDirectoryExecutionPath + "\"") : (Result)new Result.Err<OpenFileErrorType>(OpenFileErrorType.unexpectedType, "ERROR: File is not a directory");
            }
            result = new Result.Ok<VirtualFile>(file);
        } else {
            result = new Result.Ok<VirtualFile>(currentDir);
        }
        return result;
    }

    @NotNull
    public static final Result<VirtualFile, OpenFileErrorType> locateFile(@NotNull String fileExecutionPath, @NotNull VirtualFile currentDir, @NotNull PathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)fileExecutionPath, (String)"fileExecutionPath");
        Intrinsics.checkNotNullParameter((Object)currentDir, (String)"currentDir");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        Path path = currentDir.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        ExecutionPath currentDirExecutionPath = pathConverter.convertLocalPathToExecutionPath(new LocalPath(path));
        ExecutionPath absoluteFileExecutionPath = !StringsKt.startsWith$default((String)fileExecutionPath, (String)"/", (boolean)false, (int)2, null) ? new ExecutionPath(currentDirExecutionPath.getPath() + "/" + fileExecutionPath) : new ExecutionPath(fileExecutionPath);
        LocalPath localPath = pathConverter.convertExecutionPathToLocalPath(absoluteFileExecutionPath);
        if (!Files.exists(localPath.getPath(), new LinkOption[0])) {
            return new Result.Err<OpenFileErrorType>(OpenFileErrorType.doesNotExist, "ERROR: File does not exist: \"" + absoluteFileExecutionPath + "\"");
        }
        VirtualFile file = (VirtualFile)ActionsKt.runReadAction(() -> AgentUtilsKt.locateFile$lambda$2(localPath));
        if (file == null || file.isDirectory()) {
            return file == null ? (Result)new Result.Err<OpenFileErrorType>(OpenFileErrorType.doesNotExist, "ERROR: File does not exist: \"" + absoluteFileExecutionPath + "\"") : (Result)new Result.Err<OpenFileErrorType>(OpenFileErrorType.unexpectedType, "ERROR: Path is a directory, not a file");
        }
        return new Result.Ok<VirtualFile>(file);
    }

    private static final Result<VirtualFile, OpenFileErrorType> locateDirectoryOrFile(String path, VirtualFile currentDir, PathConverter pathConverter) {
        Result<VirtualFile, OpenFileErrorType> result;
        Result<VirtualFile, OpenFileErrorType> $this$ifUnexpectedType$iv = AgentUtilsKt.locateDirectory(path, currentDir, pathConverter);
        boolean $i$f$ifUnexpectedType = false;
        Result<VirtualFile, OpenFileErrorType> $this$ifError$iv$iv = $this$ifUnexpectedType$iv;
        boolean $i$f$ifError = false;
        if ($this$ifError$iv$iv instanceof Result.Err) {
            Result.Err it$iv = (Result.Err)$this$ifError$iv$iv;
            boolean bl = false;
            if (it$iv.getError() == OpenFileErrorType.unexpectedType) {
                Result.Err it = it$iv;
                boolean bl2 = false;
                result = AgentUtilsKt.locateFile(path, currentDir, pathConverter);
            } else {
                result = it$iv;
            }
        } else {
            result = $this$ifError$iv$iv;
        }
        return result;
    }

    @Nullable
    public static final Object smartLocateFile(@NotNull String executionPath, @NotNull ExecutionAgentContext context2, boolean allowOnlyProjectFile, @NotNull Continuation<? super Result<? extends VirtualFile, ? extends OpenFileErrorType>> $completion) {
        return AgentUtilsKt.smartLocate(executionPath, context2, LocateTarget.File, allowOnlyProjectFile, $completion);
    }

    public static /* synthetic */ Object smartLocateFile$default(String string, ExecutionAgentContext executionAgentContext, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return AgentUtilsKt.smartLocateFile(string, executionAgentContext, bl, (Continuation<? super Result<? extends VirtualFile, ? extends OpenFileErrorType>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object smartLocate(@NotNull String var0, @NotNull ExecutionAgentContext var1_1, @NotNull LocateTarget var2_2, boolean var3_3, @NotNull Continuation<? super Result<? extends VirtualFile, ? extends OpenFileErrorType>> $completion) {
        block22: {
            block21: {
                block20: {
                    block15: {
                        block16: {
                            block17: {
                                block18: {
                                    block19: {
                                        if (!($completion instanceof smartLocate.1)) ** GOTO lbl-1000
                                        var52_5 = $completion;
                                        if ((var52_5.label & -2147483648) != 0) {
                                            var52_5.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            $continuation = new ContinuationImpl($completion){
                                                Object L$0;
                                                Object L$1;
                                                Object L$2;
                                                Object L$3;
                                                Object L$4;
                                                Object L$5;
                                                Object L$6;
                                                boolean Z$0;
                                                /* synthetic */ Object result;
                                                int label;

                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return AgentUtilsKt.smartLocate(null, null, null, false, (Continuation<? super Result<? extends VirtualFile, ? extends OpenFileErrorType>>)((Continuation)this));
                                                }
                                            };
                                        }
                                        $result = $continuation.result;
                                        var53_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch ($continuation.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                pathConverter = context.getExecutionEnvironment().getPathConverter();
                                                locator = (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, smartLocate$lambda$4(com.intellij.ml.llm.matterhorn.actions.LocateTarget com.intellij.ml.llm.matterhorn.run.PathConverter java.lang.String com.intellij.openapi.vfs.VirtualFile ), (Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/ml/llm/matterhorn/Result;)((LocateTarget)target, (PathConverter)pathConverter);
                                                $this$ifDoesNotExist$iv = (Result)locator.invoke((Object)executionPath, (Object)context.getCurrentDir());
                                                $i$f$ifDoesNotExist = false;
                                                $this$ifError$iv$iv = $this$ifDoesNotExist$iv;
                                                $i$f$ifError = false;
                                                if (!($this$ifError$iv$iv instanceof Result.Err)) break block15;
                                                it$iv = (Result.Err)$this$ifError$iv$iv;
                                                $i$a$-ifError-AgentUtilsKt$ifDoesNotExist$1$iv = false;
                                                if (it$iv.getError() != OpenFileErrorType.doesNotExist) break block16;
                                                $i$a$-ifDoesNotExist-AgentUtilsKt$smartLocate$2 = false;
                                                $this$ifDoesNotExist$iv = (Result)locator.invoke((Object)executionPath, (Object)context.getProjectDir());
                                                $i$f$ifDoesNotExist = false;
                                                $this$ifError$iv$iv = $this$ifDoesNotExist$iv;
                                                $i$f$ifError = false;
                                                if (!($this$ifError$iv$iv instanceof Result.Err)) break block17;
                                                it$iv = (Result.Err)$this$ifError$iv$iv;
                                                $i$a$-ifError-AgentUtilsKt$ifDoesNotExist$1$iv = false;
                                                if (it$iv.getError() != OpenFileErrorType.doesNotExist) break block18;
                                                $i$a$-ifDoesNotExist-AgentUtilsKt$smartLocate$2$1 = false;
                                                $this$ifDoesNotExist$iv = (Result)locator.invoke((Object)("/" + executionPath), (Object)context.getProjectDir());
                                                $i$f$ifDoesNotExist = false;
                                                $this$ifError$iv$iv = $this$ifDoesNotExist$iv;
                                                $i$f$ifError = false;
                                                if (!($this$ifError$iv$iv instanceof Result.Err)) break block19;
                                                it$iv = (Result.Err)$this$ifError$iv$iv;
                                                $i$a$-ifError-AgentUtilsKt$ifDoesNotExist$1$iv = false;
                                                if (it$iv.getError() != OpenFileErrorType.doesNotExist) break;
                                                $i$a$-ifDoesNotExist-AgentUtilsKt$smartLocate$2$1$1 = false;
                                                $this$service$iv = (ComponentManager)context.getProject();
                                                $i$f$service = false;
                                                serviceClass$iv = ProjectSearchEverywhereService.class;
                                                v0 = $this$service$iv.getService(serviceClass$iv);
                                                if (v0 == null) {
                                                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                                }
                                                searchEverywhere = (ProjectSearchEverywhereService)v0;
                                                v1 = executionPath.substring(StringsKt.lastIndexOf$default((CharSequence)executionPath, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                                                fileName = v1;
                                                searchType = target == LocateTarget.File ? ProjectSearchEverywhereService.SearchType.FILES : ProjectSearchEverywhereService.SearchType.FILES_OR_DIRECTORIES;
                                                $continuation.L$0 = executionPath;
                                                $continuation.L$1 = context;
                                                $continuation.L$2 = target;
                                                $continuation.L$3 = pathConverter;
                                                $continuation.L$4 = fileName;
                                                $continuation.L$5 = searchType;
                                                $continuation.L$6 = searchEverywhere;
                                                $continuation.Z$0 = allowOnlyProjectFile;
                                                $continuation.label = 1;
                                                v2 = searchEverywhere.search(new SearchQuery(executionPath, 10, null, 4, null), searchType, (Continuation<? super List<SearchResultItem>>)$continuation);
                                                if (v2 == var53_7) {
                                                    return var53_7;
                                                }
                                                ** GOTO lbl91
                                            }
                                            case 1: {
                                                $i$f$ifDoesNotExist = false;
                                                $i$f$ifError = false;
                                                $i$a$-ifError-AgentUtilsKt$ifDoesNotExist$1$iv = false;
                                                $i$a$-ifDoesNotExist-AgentUtilsKt$smartLocate$2 = false;
                                                $i$f$ifDoesNotExist = false;
                                                $i$f$ifError = false;
                                                $i$a$-ifError-AgentUtilsKt$ifDoesNotExist$1$iv = false;
                                                $i$a$-ifDoesNotExist-AgentUtilsKt$smartLocate$2$1 = false;
                                                $i$f$ifDoesNotExist = false;
                                                $i$f$ifError = false;
                                                $i$a$-ifError-AgentUtilsKt$ifDoesNotExist$1$iv = false;
                                                $i$a$-ifDoesNotExist-AgentUtilsKt$smartLocate$2$1$1 = false;
                                                allowOnlyProjectFile = $continuation.Z$0;
                                                searchEverywhere = (ProjectSearchEverywhereService)$continuation.L$6;
                                                searchType = (ProjectSearchEverywhereService.SearchType)$continuation.L$5;
                                                fileName = (String)$continuation.L$4;
                                                pathConverter = (PathConverter)$continuation.L$3;
                                                target = (LocateTarget)$continuation.L$2;
                                                context = (ExecutionAgentContext)$continuation.L$1;
                                                executionPath = (String)$continuation.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v2 = $result;
lbl91:
                                                // 2 sources

                                                if (!(candidates = (List)v2).isEmpty() || Intrinsics.areEqual((Object)fileName, (Object)executionPath)) ** GOTO lbl127
                                                $continuation.L$0 = executionPath;
                                                $continuation.L$1 = context;
                                                $continuation.L$2 = target;
                                                $continuation.L$3 = pathConverter;
                                                $continuation.L$4 = fileName;
                                                $continuation.L$5 = null;
                                                $continuation.L$6 = null;
                                                $continuation.Z$0 = allowOnlyProjectFile;
                                                $continuation.label = 2;
                                                v3 = searchEverywhere.search(new SearchQuery(fileName, 10, null, 4, null), searchType, (Continuation<? super List<SearchResultItem>>)$continuation);
                                                if (v3 == var53_7) {
                                                    return var53_7;
                                                }
                                                ** GOTO lbl126
                                            }
                                            case 2: {
                                                $i$f$ifDoesNotExist = false;
                                                $i$f$ifError = false;
                                                $i$a$-ifError-AgentUtilsKt$ifDoesNotExist$1$iv = false;
                                                $i$a$-ifDoesNotExist-AgentUtilsKt$smartLocate$2 = false;
                                                $i$f$ifDoesNotExist = false;
                                                $i$f$ifError = false;
                                                $i$a$-ifError-AgentUtilsKt$ifDoesNotExist$1$iv = false;
                                                $i$a$-ifDoesNotExist-AgentUtilsKt$smartLocate$2$1 = false;
                                                $i$f$ifDoesNotExist = false;
                                                $i$f$ifError = false;
                                                $i$a$-ifError-AgentUtilsKt$ifDoesNotExist$1$iv = false;
                                                $i$a$-ifDoesNotExist-AgentUtilsKt$smartLocate$2$1$1 = false;
                                                allowOnlyProjectFile = $continuation.Z$0;
                                                fileName = (String)$continuation.L$4;
                                                pathConverter = (PathConverter)$continuation.L$3;
                                                target = (LocateTarget)$continuation.L$2;
                                                context = (ExecutionAgentContext)$continuation.L$1;
                                                executionPath = (String)$continuation.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v3 = $result;
lbl126:
                                                // 2 sources

                                                candidates = (List)v3;
lbl127:
                                                // 2 sources

                                                v4 = context.getCurrentDir().toNioPath();
                                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toNioPath(...)");
                                                currentDirLocalPath = new LocalPath(v4);
                                                currentDirectoryExecutionPath = pathConverter.convertLocalPathToExecutionPath(currentDirLocalPath);
                                                result = new StringBuilder();
                                                v5 = result.append("ERROR: " + StringsKt.capitalize((String)target.getText()) + " \"" + executionPath + "\" does not exist in the current directory \"" + currentDirectoryExecutionPath.getPath() + "\".");
                                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"append(...)");
                                                Intrinsics.checkNotNullExpressionValue((Object)v5.append('\n'), (String)"append(...)");
                                                if (((Collection)candidates).isEmpty() == false) {
                                                    v6 = result.append("Possible candidates:");
                                                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"append(...)");
                                                    Intrinsics.checkNotNullExpressionValue((Object)v6.append('\n'), (String)"append(...)");
                                                    $this$mapNotNull$iv = candidates;
                                                    $i$f$mapNotNull = false;
                                                    var37_41 = $this$mapNotNull$iv;
                                                    destination$iv$iv = new ArrayList<E>();
                                                    $i$f$mapNotNullTo = false;
                                                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                                    $i$f$forEach = false;
                                                    var42_46 = $this$forEach$iv$iv$iv.iterator();
                                                    while (var42_46.hasNext()) {
                                                        element$iv$iv = element$iv$iv$iv = var42_46.next();
                                                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                                        it = (SearchResultItem)element$iv$iv;
                                                        $i$a$-mapNotNull-AgentUtilsKt$smartLocate$2$1$1$candidatesText$1 = false;
                                                        if (VirtualFileUtil.toNioPathOrNull((VirtualFile)it.getFile()) == null) continue;
                                                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                                                        destination$iv$iv.add(it$iv$iv);
                                                    }
                                                    candidatesText = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, smartLocate$lambda$9$lambda$8$lambda$7$lambda$6(com.intellij.ml.llm.matterhorn.run.PathConverter com.intellij.ml.llm.matterhorn.ExecutionAgentContext java.nio.file.Path ), (Ljava/nio/file/Path;)Ljava/lang/CharSequence;)((PathConverter)pathConverter, (ExecutionAgentContext)context), (int)30, null);
                                                    v7 = result.append(candidatesText);
                                                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"append(...)");
                                                    v8 = v7.append('\n');
                                                    v9 = v8;
                                                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"append(...)");
                                                } else {
                                                    v10 = result.append("There is no such " + target.getText() + " as \"" + fileName + "\" in the project at all!");
                                                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"append(...)");
                                                    v11 = v10.append('\n');
                                                    v9 = v11;
                                                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"append(...)");
                                                }
                                                v12 = result.toString();
                                                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"toString(...)");
                                                v13 = new Result.Err<OpenFileErrorType>(OpenFileErrorType.doesNotExist, v12);
                                                break block20;
                                            }
                                        }
                                        v13 = it$iv;
                                        break block20;
                                    }
                                    v13 = $this$ifError$iv$iv;
                                    break block20;
                                }
                                v13 = it$iv;
                                break block20;
                            }
                            v13 = $this$ifError$iv$iv;
                            break block20;
                        }
                        v13 = it$iv;
                        break block20;
                    }
                    v13 = $this$ifError$iv$iv;
                }
                $this$ifSuccess$iv = v13;
                $i$f$ifSuccess = false;
                if (!($this$ifSuccess$iv instanceof Result.Ok)) break block21;
                it = (Result.Ok)$this$ifSuccess$iv;
                $i$a$-ifSuccess-AgentUtilsKt$smartLocate$3 = false;
                if (!allowOnlyProjectFile) ** GOTO lbl-1000
                v14 = VirtualFileUtil.toNioPathOrNull((VirtualFile)((VirtualFile)it.getValue()));
                if (!(v14 != null ? v14.startsWith(context.getProjectDir().toNioPath()) : false)) {
                    result = new StringBuilder();
                    v15 = result.append("ERROR: you provided absolute path \\\"" + VirtualFileUtil.toNioPathOrNull((VirtualFile)((VirtualFile)it.getValue())) + "\\\" which is outside of the project path.");
                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)v15.append('\n'), (String)"append(...)");
                    v16 = result.append("Correct your path to be inside the current project or provide a relative path.");
                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)v16.append('\n'), (String)"append(...)");
                    v17 = result.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"toString(...)");
                    v18 = new Result.Err<OpenFileErrorType>(OpenFileErrorType.outsideOfProject, v17);
                } else lbl-1000:
                // 2 sources

                {
                    v18 = it;
                }
                break block22;
            }
            v18 = $this$ifSuccess$iv;
        }
        return v18;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object smartLocate$default(String string, ExecutionAgentContext executionAgentContext, LocateTarget locateTarget, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return AgentUtilsKt.smartLocate(string, executionAgentContext, locateTarget, bl, (Continuation<? super Result<? extends VirtualFile, ? extends OpenFileErrorType>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object printScreen(@NotNull Project var0, @NotNull VirtualFile var1_1, int var2_2, int var3_3, @NotNull PathConverter var4_4, @NotNull String var5_5, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof printScreen.1)) ** GOTO lbl-1000
        var9_7 = $completion;
        if ((var9_7.label & -2147483648) != 0) {
            var9_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AgentUtilsKt.printScreen(null, null, 0, 0, null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = file;
                $continuation.L$1 = pathConverter;
                $continuation.L$2 = separator;
                $continuation.I$0 = startLine;
                $continuation.I$1 = window;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, printScreen$lambda$11(com.intellij.openapi.vfs.VirtualFile ), ()Lcom/intellij/openapi/editor/Document;)((VirtualFile)file), (Continuation)$continuation);
                if (v0 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl30
            }
            case 1: {
                window = $continuation.I$1;
                startLine = $continuation.I$0;
                separator = (String)$continuation.L$2;
                pathConverter = (PathConverter)$continuation.L$1;
                file = (VirtualFile)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                if ((document = (Document)v0) == null) {
                    return "ERROR: Failed to load document for file";
                }
                v1 = file.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toNioPath(...)");
                return AgentUtilsKt.printScreen(new LocalPath(v1), document, startLine, window, pathConverter, separator);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object printScreen$default(Project project, VirtualFile virtualFile, int n, int n2, PathConverter pathConverter, String string, Continuation continuation, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            string = ":";
        }
        return AgentUtilsKt.printScreen(project, virtualFile, n, n2, pathConverter, string, (Continuation<? super String>)continuation);
    }

    @NotNull
    public static final String printScreen(@NotNull LocalPath localPath, @NotNull Document document, int startLine, int window, @NotNull PathConverter pathConverter, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (startLine == 1 && document.getTextLength() == 0) {
            return "<File is empty>\n";
        }
        ExecutionPath executionPath = pathConverter.convertLocalPathToExecutionPath(localPath);
        int constrainedStartLine = AgentUtilsKt.constraintStartLineNum(startLine, window, document.getLineCount());
        return AgentUtilsKt.printScreen(constrainedStartLine, window, document, executionPath, separator);
    }

    public static /* synthetic */ String printScreen$default(LocalPath localPath, Document document, int n, int n2, PathConverter pathConverter, String string, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            string = ":";
        }
        return AgentUtilsKt.printScreen(localPath, document, n, n2, pathConverter, string);
    }

    @NotNull
    public static final String printScreen(int startLine, int window, @NotNull Document document, @NotNull ExecutionPath executionFilePath, @NotNull String separator) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)executionFilePath, (String)"executionFilePath");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        int documentLineCount = document.getLineCount();
        int endLineIncl = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(startLine + window), (int)documentLineCount), (int)startLine);
        StringBuilder $this$printScreen_u24lambda_u2412 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$printScreen_u24lambda_u2412.append("[File: " + executionFilePath + " (" + documentLineCount + " lines total)]");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        if (startLine != 1) {
            StringBuilder stringBuilder3 = $this$printScreen_u24lambda_u2412.append("(" + (startLine - 1) + " more lines above)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        $this$printScreen_u24lambda_u2412.append(AgentUtilsKt.printScreenPart(startLine, separator, endLineIncl + 1, document));
        if (endLineIncl < documentLineCount) {
            int linesBelow = documentLineCount - endLineIncl;
            StringBuilder stringBuilder4 = $this$printScreen_u24lambda_u2412.append("(" + linesBelow + " more lines below)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String printScreen$default(int n, int n2, Document document, ExecutionPath executionPath, String string, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            string = ":";
        }
        return AgentUtilsKt.printScreen(n, n2, document, executionPath, string);
    }

    public static final int constraintStartLineNum(int lineNum, int windowSize, int totalLines) {
        return Math.min(lineNum, Math.max(1, totalLines - windowSize));
    }

    @NotNull
    public static final String printScreenPart(int startLine, @NotNull String separator, int endLineExcl, @NotNull Document document) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        StringBuilder $this$printScreenPart_u24lambda_u2413 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int lineIndex = startLine; lineIndex < endLineExcl; ++lineIndex) {
            String lineText;
            int zeroBasedLineIndex = lineIndex - 1;
            Intrinsics.checkNotNullExpressionValue((Object)document.getText(new TextRange(document.getLineStartOffset(zeroBasedLineIndex), document.getLineEndOffset(zeroBasedLineIndex))), (String)"getText(...)");
            StringBuilder stringBuilder2 = $this$printScreenPart_u24lambda_u2413.append(lineIndex).append(separator);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            StringBuilder stringBuilder3 = stringBuilder2.append(lineText);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final List<String> parseArgs(@NotNull String args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        parts = new ArrayList<E>();
        current = new StringBuilder();
        inDoubleQuotes = false;
        inSingleQuotes = false;
        prevChar = null;
        var7_7 = args.length();
        for (var6_6 = 0; var6_6 < var7_7; ++var6_6) {
            block16: {
                block15: {
                    char = args.charAt(var6_6);
                    if (char != '\"') break block15;
                    v0 = prevChar;
                    var9_9 = '\\';
                    if (v0 != null && v0.charValue() == var9_9) break block15;
                    if (!inSingleQuotes) {
                        v1 = inDoubleQuotes = inDoubleQuotes == false;
                        if (!inDoubleQuotes) {
                            parts.add(AgentUtilsKt.parseArgument(current));
                            current = new StringBuilder();
                        }
                        v2 = Unit.INSTANCE;
                    } else {
                        v2 = current.append(char);
                    }
                    break block16;
                }
                if (char != '\'') ** GOTO lbl-1000
                v3 = prevChar;
                var9_9 = '\\';
                if (v3 == null || v3.charValue() != var9_9) {
                    if (!inDoubleQuotes) {
                        v4 = inSingleQuotes = inSingleQuotes == false;
                        if (!inSingleQuotes) {
                            parts.add(AgentUtilsKt.parseArgument(current));
                            current = new StringBuilder();
                        }
                        v2 = Unit.INSTANCE;
                    } else {
                        v2 = current.append(char);
                    }
                } else if (char == ' ') {
                    if (inDoubleQuotes || inSingleQuotes) {
                        v2 = current.append(char);
                    } else {
                        if (((CharSequence)current).length() > 0) {
                            parts.add(AgentUtilsKt.parseArgument(current));
                            current = new StringBuilder();
                        }
                        v2 = Unit.INSTANCE;
                    }
                } else {
                    v2 = current.append(char);
                }
            }
            prevChar = Character.valueOf(char);
        }
        if (((CharSequence)current).length() > 0) {
            parts.add(AgentUtilsKt.parseArgument(current));
        }
        return parts;
    }

    @NotNull
    public static final String parseArgument(@NotNull StringBuilder $this$parseArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$parseArgument, (String)"<this>");
        String string = $this$parseArgument.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\\\"", (String)"\"", (boolean)false, (int)4, null), (String)"\\'", (String)"'", (boolean)false, (int)4, null).toString();
    }

    private static final VirtualFile locateFile$lambda$2(LocalPath $localPath) {
        return VfsUtil.findFile((Path)$localPath.getPath(), (boolean)true);
    }

    private static final Result smartLocate$lambda$4(LocateTarget $target, PathConverter $pathConverter, String p, VirtualFile scope) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return switch (WhenMappings.$EnumSwitchMapping$0[$target.ordinal()]) {
            case 1 -> AgentUtilsKt.locateFile(p, scope, $pathConverter);
            case 2 -> AgentUtilsKt.locateDirectory(p, scope, $pathConverter);
            case 3 -> AgentUtilsKt.locateDirectoryOrFile(p, scope, $pathConverter);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final CharSequence smartLocate$lambda$9$lambda$8$lambda$7$lambda$6(PathConverter $pathConverter, ExecutionAgentContext $context, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ExecutionPath absoluteExecutionPath = $pathConverter.convertLocalPathToExecutionPath(new LocalPath(it));
        Path path = $context.getCurrentDir().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path relativePath = PathsKt.relativeToOrNull((Path)it, (Path)path);
        return "  - absolute path: \"" + absoluteExecutionPath.getPath() + "\", relative path from the current directory: \"" + relativePath + "\"";
    }

    private static final Document printScreen$lambda$11(VirtualFile $file) {
        return FileDocumentManager.getInstance().getDocument($file);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LocateTarget.values().length];
            try {
                nArray[LocateTarget.File.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocateTarget.Directory.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocateTarget.FileOrDirectory.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

