/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.ml.llm.matterhorn.AgentAction;
import com.intellij.ml.llm.matterhorn.Argument;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.FileWithLine;
import com.intellij.ml.llm.matterhorn.StepMetadataKt;
import com.intellij.ml.llm.matterhorn.StepType;
import com.intellij.ml.llm.matterhorn.actions.ActionRequest;
import com.intellij.ml.llm.matterhorn.actions.ActionUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.CreateFileAgentAction;
import com.intellij.ml.llm.matterhorn.actions.FileUtil;
import com.intellij.ml.llm.matterhorn.actions.SimpleActionRequest;
import com.intellij.ml.llm.matterhorn.actions.edit.AbstractEditActionKt;
import com.intellij.ml.llm.matterhorn.actions.edit.Edit;
import com.intellij.ml.llm.matterhorn.actions.edit.EditSearchReplace;
import com.intellij.ml.llm.matterhorn.actions.edit.EditType;
import com.intellij.ml.llm.matterhorn.actions.edit.FileChange;
import com.intellij.ml.llm.matterhorn.actions.edit.checks.ErrorChecker;
import com.intellij.ml.llm.matterhorn.llm.ArgumentType;
import com.intellij.ml.llm.matterhorn.llm.ParameterValue;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001f0\u001eJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/CreateFileAgentAction;", "Lcom/intellij/ml/llm/matterhorn/AgentAction;", "errorCheckers", "", "Lcom/intellij/ml/llm/matterhorn/actions/edit/checks/ErrorChecker;", "<init>", "(Ljava/util/List;)V", "getErrorCheckers", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "arguments", "Lcom/intellij/ml/llm/matterhorn/Argument;", "getArguments", "docstring", "getDocstring", "customSignature", "getCustomSignature", "execute", "request", "Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "(Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trimQuotes", "parseCreateFileArguments", "Lcom/intellij/ml/llm/matterhorn/actions/edit/Edit;", "params", "", "Lcom/intellij/ml/llm/matterhorn/llm/ParameterValue;", "input", "Companion", "FileForUpdate", "ej-core"})
@SourceDebugExtension(value={"SMAP\nCreateFileAgentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateFileAgentAction.kt\ncom/intellij/ml/llm/matterhorn/actions/CreateFileAgentAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n756#2,10:143\n*S KotlinDebug\n*F\n+ 1 CreateFileAgentAction.kt\ncom/intellij/ml/llm/matterhorn/actions/CreateFileAgentAction\n*L\n131#1:143,10\n*E\n"})
public class CreateFileAgentAction
implements AgentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ErrorChecker> errorCheckers;
    @NotNull
    private final String name;
    @NotNull
    private final List<Argument> arguments;
    @NotNull
    private final String docstring;
    @NotNull
    private final String customSignature;
    @NotNull
    public static final String CREATE_FILE_ACTION_NAME = "create";
    @NotNull
    public static final String FILE_ARGUMENT = "filename";
    @NotNull
    public static final String CONTENT_ARGUMENT = "content";

    public CreateFileAgentAction(@NotNull List<? extends ErrorChecker> errorCheckers) {
        Intrinsics.checkNotNullParameter(errorCheckers, (String)"errorCheckers");
        this.errorCheckers = errorCheckers;
        this.name = CREATE_FILE_ACTION_NAME;
        Object[] objectArray = new Argument[]{new Argument(FILE_ARGUMENT, ArgumentType.STRING, "the full path to the file to create", false, false, 24, null), new Argument(CONTENT_ARGUMENT, ArgumentType.STRING, "content of the new created file", true, false, 16, null)};
        this.arguments = CollectionsKt.listOf((Object[])objectArray);
        this.docstring = "Create a new file with the given name and given content. \nYou can run the `create` command again to completely rewrite the file you created during the **current session**.\nDo not use line numbers in *content* parameter.";
        this.customSignature = "create <filename>\n<content>";
    }

    @NotNull
    public final List<ErrorChecker> getErrorCheckers() {
        return this.errorCheckers;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public String getDocstring() {
        return this.docstring;
    }

    @Override
    @NotNull
    public String getCustomSignature() {
        return this.customSignature;
    }

    @Override
    @Nullable
    public Object execute(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        return CreateFileAgentAction.execute$suspendImpl(this, request2, context2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object execute$suspendImpl(CreateFileAgentAction var0, ActionRequest var1_1, ExecutionAgentContext var2_2, Continuation<? super String> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var17_4 = $completion;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ CreateFileAgentAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CreateFileAgentAction.execute$suspendImpl(this.this$0, null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                StepMetadataKt.emitMetadata("Create file", StepType.Edit, context);
                fileForUpdate = new Ref.ObjectRef();
                edit = null;
                if (!(request instanceof SimpleActionRequest)) ** GOTO lbl20
                v0 = $this.parseCreateFileArguments(((SimpleActionRequest)request).getArguments());
                ** GOTO lbl41
lbl20:
                // 1 sources

                var15_9 = $this;
                $continuation.L$0 = $this;
                $continuation.L$1 = context;
                $continuation.L$2 = fileForUpdate;
                $continuation.L$3 = var15_9;
                $continuation.label = 1;
                v1 = $this.getInputParams((ActionRequest)request, (Continuation<? super Map<String, ParameterValue>>)$continuation);
                ** if (v1 != var18_6) goto lbl29
lbl28:
                // 1 sources

                return var18_6;
lbl29:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                var15_9 = (CreateFileAgentAction)$continuation.L$3;
                edit = null;
                fileForUpdate = (Ref.ObjectRef)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                $this = (CreateFileAgentAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                v0 = var15_9.parseCreateFileArguments((Map)v1);
lbl41:
                // 2 sources

                edit = v0;
                fileName = edit.getFileName();
                path = context.getCurrentDir().toNioPath().resolve(fileName);
                $continuation.L$0 = $this;
                $continuation.L$1 = context;
                $continuation.L$2 = fileForUpdate;
                $continuation.L$3 = edit;
                $continuation.L$4 = fileName;
                $continuation.L$5 = path;
                $continuation.label = 2;
                v2 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$0(com.intellij.ml.llm.matterhorn.ExecutionAgentContext java.lang.String java.nio.file.Path ), ()Lcom/intellij/openapi/vfs/VirtualFile;)((ExecutionAgentContext)context, (String)fileName, (Path)path), (Continuation)$continuation);
                ** if (v2 != var18_6) goto lbl54
lbl53:
                // 1 sources

                return var18_6;
lbl54:
                // 1 sources

                ** GOTO lbl66
            }
            case 2: {
                path = (Path)$continuation.L$5;
                fileName = (String)$continuation.L$4;
                edit = (Edit)$continuation.L$3;
                fileForUpdate = (Ref.ObjectRef)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                $this = (CreateFileAgentAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl66:
                // 2 sources

                existingFile = (VirtualFile)v2;
                if (VfsUtilCore.isAncestor((File)context.getProjectDir().toNioPath().toFile(), (File)path.toFile(), (boolean)false)) break;
                var9_16 = "ERROR: Target directory is outside of the project directory";
                if (fileForUpdate.element == null || !((FileForUpdate)fileForUpdate.element).getCreated()) ** GOTO lbl88
                v3 = edit;
                var10_18 = v3 != null ? v3.getReplacementText() : null;
                if (!(var10_18 == null || var10_18.length() == 0)) {
                    $continuation.L$0 = var9_16;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.L$5 = null;
                    $continuation.label = 3;
                    v4 = CoroutinesKt.writeAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$3(kotlin.jvm.internal.Ref$ObjectRef com.intellij.ml.llm.matterhorn.actions.CreateFileAgentAction ), ()Lkotlin/Unit;)((Ref.ObjectRef)fileForUpdate, (CreateFileAgentAction)$this), (Continuation)$continuation);
                    if (v4 == var18_6) {
                        return var18_6;
                    }
                }
                ** GOTO lbl88
            }
            case 3: {
                var9_16 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl88:
                // 3 sources

                return var9_16;
            }
        }
        var15_9 = fileForUpdate;
        $continuation.L$0 = $this;
        $continuation.L$1 = context;
        $continuation.L$2 = fileForUpdate;
        $continuation.L$3 = edit;
        $continuation.L$4 = fileName;
        $continuation.L$5 = path;
        $continuation.L$6 = var15_9;
        $continuation.label = 4;
        v5 = CoroutinesKt.writeAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$1(com.intellij.openapi.vfs.VirtualFile com.intellij.ml.llm.matterhorn.ExecutionAgentContext java.nio.file.Path java.lang.String ), ()Lcom/intellij/ml/llm/matterhorn/actions/CreateFileAgentAction$FileForUpdate;)((VirtualFile)existingFile, (ExecutionAgentContext)context, (Path)path, (String)fileName), (Continuation)$continuation);
        ** if (v5 != var18_6) goto lbl102
lbl101:
        // 1 sources

        return var18_6;
lbl102:
        // 1 sources

        ** GOTO lbl115
        {
            case 4: {
                var15_9 = (Ref.ObjectRef)$continuation.L$6;
                path = (Path)$continuation.L$5;
                fileName = (String)$continuation.L$4;
                edit = (Edit)$continuation.L$3;
                fileForUpdate = (Ref.ObjectRef)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                $this = (CreateFileAgentAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl115:
                // 2 sources

                var15_9.element = v5;
                AbstractEditActionKt.createEditPathMarker(context, CollectionsKt.listOf((Object)FileChange.Companion.from(context.getProject(), ((FileForUpdate)fileForUpdate.element).getFile(), null, "")));
                $continuation.L$0 = $this;
                $continuation.L$1 = context;
                $continuation.L$2 = fileForUpdate;
                $continuation.L$3 = edit;
                $continuation.L$4 = fileName;
                $continuation.L$5 = path;
                $continuation.L$6 = null;
                $continuation.label = 5;
                v6 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$2(kotlin.jvm.internal.Ref$ObjectRef ), ()Lcom/intellij/openapi/editor/Document;)((Ref.ObjectRef)fileForUpdate), (Continuation)$continuation);
                ** if (v6 != var18_6) goto lbl128
lbl127:
                // 1 sources

                return var18_6;
lbl128:
                // 1 sources

                ** GOTO lbl140
            }
            case 5: {
                path = (Path)$continuation.L$5;
                fileName = (String)$continuation.L$4;
                edit = (Edit)$continuation.L$3;
                fileForUpdate = (Ref.ObjectRef)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                $this = (CreateFileAgentAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl140:
                // 2 sources

                if ((Document)v6 != null) break;
                var11_20 = "ERROR: Could not open " + fileName;
                if (fileForUpdate.element == null || !((FileForUpdate)fileForUpdate.element).getCreated()) ** GOTO lbl161
                v7 = edit;
                var12_22 = v7 != null ? v7.getReplacementText() : null;
                if (!(var12_22 == null || var12_22.length() == 0)) {
                    $continuation.L$0 = var11_20;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.L$5 = null;
                    $continuation.label = 6;
                    v8 = CoroutinesKt.writeAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$3(kotlin.jvm.internal.Ref$ObjectRef com.intellij.ml.llm.matterhorn.actions.CreateFileAgentAction ), ()Lkotlin/Unit;)((Ref.ObjectRef)fileForUpdate, (CreateFileAgentAction)$this), (Continuation)$continuation);
                    if (v8 == var18_6) {
                        return var18_6;
                    }
                }
                ** GOTO lbl161
            }
            case 6: {
                var11_20 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl161:
                // 3 sources

                return var11_20;
            }
        }
        document = v9;
        $continuation.L$0 = $this;
        $continuation.L$1 = context;
        $continuation.L$2 = fileForUpdate;
        $continuation.L$3 = edit;
        $continuation.L$4 = fileName;
        $continuation.L$5 = path;
        $continuation.L$6 = document;
        $continuation.label = 7;
        v10 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FileDocumentManager.getInstance().saveAllDocuments();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Continuation)$continuation);
        ** if (v10 != var18_6) goto lbl175
lbl174:
        // 1 sources

        return var18_6;
lbl175:
        // 1 sources

        ** GOTO lbl188
        {
            case 7: {
                document = (Document)$continuation.L$6;
                path = (Path)$continuation.L$5;
                fileName = (String)$continuation.L$4;
                edit = (Edit)$continuation.L$3;
                fileForUpdate = (Ref.ObjectRef)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                $this = (CreateFileAgentAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl188:
                // 2 sources

                fileNameToDocument = MapsKt.mapOf((Pair)TuplesKt.to((Object)fileName, (Object)document));
                replacer = new EditSearchReplace($this.errorCheckers, true);
                $continuation.L$0 = $this;
                $continuation.L$1 = context;
                $continuation.L$2 = fileForUpdate;
                $continuation.L$3 = edit;
                $continuation.L$4 = path;
                $continuation.L$5 = null;
                $continuation.L$6 = null;
                $continuation.label = 8;
                v11 = EditSearchReplace.doSearchReplace$default(replacer, CollectionsKt.listOf((Object)edit), EditType.CREATE, fileNameToDocument, context, false, null, (Continuation)$continuation, 32, null);
                ** if (v11 != var18_6) goto lbl201
lbl200:
                // 1 sources

                return var18_6;
lbl201:
                // 1 sources

                ** GOTO lbl212
            }
            case 8: {
                path = (Path)$continuation.L$4;
                edit = (Edit)$continuation.L$3;
                fileForUpdate = (Ref.ObjectRef)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                $this = (CreateFileAgentAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v11 = $result;
lbl212:
                // 2 sources

                if (StringsKt.contains$default((CharSequence)(result = (String)v11), (CharSequence)"File created.", (boolean)false, (int)2, null)) break;
                var13_24 = result;
                if (fileForUpdate.element == null || !((FileForUpdate)fileForUpdate.element).getCreated()) ** GOTO lbl232
                v12 = edit;
                var14_26 = v12 != null ? v12.getReplacementText() : null;
                if (!(var14_26 == null || var14_26.length() == 0)) {
                    $continuation.L$0 = var13_24;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.label = 9;
                    v13 = CoroutinesKt.writeAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$3(kotlin.jvm.internal.Ref$ObjectRef com.intellij.ml.llm.matterhorn.actions.CreateFileAgentAction ), ()Lkotlin/Unit;)((Ref.ObjectRef)fileForUpdate, (CreateFileAgentAction)$this), (Continuation)$continuation);
                    if (v13 == var18_6) {
                        return var18_6;
                    }
                }
                ** GOTO lbl232
            }
            case 9: {
                var13_24 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl232:
                // 3 sources

                return var13_24;
            }
        }
        try {
            context.getSessionHistory().getCreatedFiles().add(path.toAbsolutePath().toString());
            context.setCurrentScreenPosition(new FileWithLine(((FileForUpdate)fileForUpdate.element).getFile(), 1));
            var13_25 = result;
            if (fileForUpdate.element == null || !((FileForUpdate)fileForUpdate.element).getCreated()) ** GOTO lbl256
            v14 = edit;
        }
        catch (Exception e) {
            var8_15 = String.valueOf(e.getMessage());
            if (fileForUpdate.element == null || !((FileForUpdate)fileForUpdate.element).getCreated()) ** GOTO lbl280
            v16 = edit;
            var9_17 = v16 != null ? v16.getReplacementText() : null;
            if (!(var9_17 == null || var9_17.length() == 0)) {
                $continuation.L$0 = var8_15;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.L$6 = null;
                $continuation.label = 11;
                v17 = CoroutinesKt.writeAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$3(kotlin.jvm.internal.Ref$ObjectRef com.intellij.ml.llm.matterhorn.actions.CreateFileAgentAction ), ()Lkotlin/Unit;)((Ref.ObjectRef)fileForUpdate, (CreateFileAgentAction)$this), (Continuation)$continuation);
                if (v17 == var18_6) {
                    return var18_6;
                }
            }
            ** GOTO lbl280
        }
        var14_27 = v14 != null ? v14.getReplacementText() : null;
        if (!(var14_27 == null || var14_27.length() == 0)) {
            $continuation.L$0 = var13_25;
            $continuation.L$1 = null;
            $continuation.L$2 = null;
            $continuation.L$3 = null;
            $continuation.L$4 = null;
            $continuation.label = 10;
            v15 = CoroutinesKt.writeAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$3(kotlin.jvm.internal.Ref$ObjectRef com.intellij.ml.llm.matterhorn.actions.CreateFileAgentAction ), ()Lkotlin/Unit;)((Ref.ObjectRef)fileForUpdate, (CreateFileAgentAction)$this), (Continuation)$continuation);
            if (v15 == var18_6) {
                return var18_6;
            }
        }
        ** GOTO lbl256
        {
            case 10: {
                var13_25 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v15 = $result;
lbl256:
                // 3 sources

                return var13_25;
            }
        }
        {
            case 11: {
                var8_15 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v17 = $result;
lbl280:
                // 3 sources

                return var8_15;
            }
        }
        {
            catch (Throwable var7_13) {
                if (fileForUpdate.element != null && ((FileForUpdate)fileForUpdate.element).getCreated()) {
                    v18 = edit;
                    var8_15 = v18 != null ? v18.getReplacementText() : null;
                    if (!(var8_15 == null || var8_15.length() == 0)) {
                        $continuation.L$0 = var7_13;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.L$3 = null;
                        $continuation.L$4 = null;
                        $continuation.L$5 = null;
                        $continuation.L$6 = null;
                        $continuation.label = 12;
                        v19 = CoroutinesKt.writeAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$3(kotlin.jvm.internal.Ref$ObjectRef com.intellij.ml.llm.matterhorn.actions.CreateFileAgentAction ), ()Lkotlin/Unit;)((Ref.ObjectRef)fileForUpdate, (CreateFileAgentAction)$this), (Continuation)$continuation);
                        if (v19 == var18_6) {
                            return var18_6;
                        }
                    }
                }
                ** GOTO lbl302
            }
        }
        {
            case 12: {
                var7_14 = (Throwable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v19 = $result;
lbl302:
                // 2 sources

                throw var7_14;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String trimQuotes(String name) {
        String string;
        if (StringsKt.startsWith$default((String)name, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)"\"", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)"'", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)"`", (boolean)false, (int)2, null)) {
            String string2 = name.substring(1, name.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = name;
        }
        return string;
    }

    @NotNull
    public final Edit parseCreateFileArguments(@NotNull Map<String, ParameterValue> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        String string = ActionUtilsKt.tryGetNonEmptyStringValue(params.get(FILE_ARGUMENT));
        if (string == null) {
            throw new IllegalStateException("ERROR: No file name provided");
        }
        String fileName = string;
        String string2 = ActionUtilsKt.tryGetStringValue(params.get(CONTENT_ARGUMENT));
        if (string2 == null) {
            string2 = "";
        }
        String content = string2;
        return new Edit(this.trimQuotes(fileName), "", content);
    }

    @NotNull
    public final Edit parseCreateFileArguments(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Iterable $this$dropWhile$iv = StringsKt.lines((CharSequence)input);
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            String it = (String)item$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)it)).toString(), (Object)"")) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        List lines = list$iv;
        if (lines.isEmpty()) {
            throw new IllegalArgumentException("ERROR: Failed to parse file name");
        }
        String fileName = this.trimQuotes(((Object)StringsKt.trim((CharSequence)((String)lines.get(0)))).toString());
        if (lines.size() < 2) {
            return new Edit(fileName, "", "");
        }
        String content = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)lines, (int)(lines.size() - 1)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return new Edit(fileName, "", content);
    }

    @Override
    @Nullable
    public Object getInputParams(@NotNull ActionRequest $this$getInputParams, @NotNull Continuation<? super Map<String, ParameterValue>> $completion) {
        return AgentAction.DefaultImpls.getInputParams(this, $this$getInputParams, $completion);
    }

    @Override
    @Nullable
    public Object reviewActionRequest(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        return AgentAction.DefaultImpls.reviewActionRequest(this, request2, context2, $completion);
    }

    private static final VirtualFile execute$lambda$0(ExecutionAgentContext $context, String $fileName, Path $path) {
        VirtualFile existingFile = $context.getCurrentDir().findFileByRelativePath($fileName);
        if (existingFile != null && !$context.getSessionHistory().getCreatedFiles().contains(((Object)$path.toAbsolutePath()).toString())) {
            throw new IllegalArgumentException("ERROR: File " + $fileName + " already exists");
        }
        return existingFile;
    }

    private static final FileForUpdate execute$lambda$1(VirtualFile $existingFile, ExecutionAgentContext $context, Path $path, String $fileName) {
        FileForUpdate fileForUpdate;
        if ($existingFile == null) {
            VirtualFile virtualFile = $context.getCurrentDir();
            Intrinsics.checkNotNull((Object)$path);
            VirtualFile createdFile = FileUtil.INSTANCE.createFileCreatingDirsIfMissing(virtualFile, $path);
            if (createdFile == null) {
                throw new IllegalArgumentException("ERROR: Could not create " + $fileName);
            }
            fileForUpdate = new FileForUpdate(createdFile, true);
        } else {
            fileForUpdate = new FileForUpdate($existingFile, false);
        }
        return fileForUpdate;
    }

    private static final Document execute$lambda$2(Ref.ObjectRef $fileForUpdate) {
        return FileDocumentManager.getInstance().getDocument(((FileForUpdate)$fileForUpdate.element).getFile());
    }

    private static final Unit execute$lambda$3(Ref.ObjectRef $fileForUpdate, CreateFileAgentAction this$0) {
        if (FileUtil.INSTANCE.isEmpty(((FileForUpdate)$fileForUpdate.element).getFile())) {
            ((FileForUpdate)$fileForUpdate.element).getFile().delete((Object)this$0);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/CreateFileAgentAction$Companion;", "", "<init>", "()V", "CREATE_FILE_ACTION_NAME", "", "FILE_ARGUMENT", "CONTENT_ARGUMENT", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/CreateFileAgentAction$FileForUpdate;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "created", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getCreated", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "ej-core"})
    public static final class FileForUpdate {
        @NotNull
        private final VirtualFile file;
        private final boolean created;

        public FileForUpdate(@NotNull VirtualFile file, boolean created) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.created = created;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public final boolean getCreated() {
            return this.created;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        public final boolean component2() {
            return this.created;
        }

        @NotNull
        public final FileForUpdate copy(@NotNull VirtualFile file, boolean created) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new FileForUpdate(file, created);
        }

        public static /* synthetic */ FileForUpdate copy$default(FileForUpdate fileForUpdate, VirtualFile virtualFile, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = fileForUpdate.file;
            }
            if ((n & 2) != 0) {
                bl = fileForUpdate.created;
            }
            return fileForUpdate.copy(virtualFile, bl);
        }

        @NotNull
        public String toString() {
            return "FileForUpdate(file=" + this.file + ", created=" + this.created + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + Boolean.hashCode(this.created);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileForUpdate)) {
                return false;
            }
            FileForUpdate fileForUpdate = (FileForUpdate)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)fileForUpdate.file)) {
                return false;
            }
            return this.created == fileForUpdate.created;
        }
    }
}

