/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"searchInDocument", "", "document", "Lcom/intellij/openapi/editor/Document;", "searchTerm", "fileName", "printAround", "", "ej-core"})
@SourceDebugExtension(value={"SMAP\nSearchInFileAgentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchInFileAgentAction.kt\ncom/intellij/ml/llm/matterhorn/actions/SearchInFileAgentActionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1557#2:127\n1628#2,3:128\n1863#2,2:131\n*S KotlinDebug\n*F\n+ 1 SearchInFileAgentAction.kt\ncom/intellij/ml/llm/matterhorn/actions/SearchInFileAgentActionKt\n*L\n93#1:127\n93#1:128,3\n101#1:131,2\n*E\n"})
public final class SearchInFileAgentActionKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String searchInDocument(@NotNull Document document, @NotNull String searchTerm, @NotNull String fileName, boolean printAround) {
        void $this$mapTo$iv$iv;
        Iterable lineText;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)searchTerm, (String)"searchTerm");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (StringsKt.isBlank((CharSequence)searchTerm)) {
            return "ERROR: search_term is missing or invalid";
        }
        StringBuilder result = new StringBuilder();
        List matches = new ArrayList();
        int n = document.getLineCount();
        for (int lineNumber = 0; lineNumber < n; ++lineNumber) {
            int lineStartOffset = document.getLineStartOffset(lineNumber);
            int lineEndOffset = document.getLineEndOffset(lineNumber);
            Intrinsics.checkNotNullExpressionValue((Object)document.getText(new TextRange(lineStartOffset, lineEndOffset)), (String)"getText(...)");
            if (!StringsKt.contains$default((CharSequence)((CharSequence)((Object)lineText)), (CharSequence)searchTerm, (boolean)false, (int)2, null)) continue;
            matches.add(TuplesKt.to((Object)lineNumber, (Object)lineText));
        }
        if (matches.isEmpty()) {
            return "No matches found for \"" + searchTerm + "\" in " + fileName;
        }
        int numMatches = matches.size();
        Iterable $this$map$iv = matches;
        boolean $i$f$map = false;
        lineText = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getFirst()).intValue());
        }
        int numLines = ((Collection)CollectionsKt.distinct((Iterable)((List)destination$iv$iv))).size();
        if (numLines > 100) {
            return "More than " + numLines + " lines matched for \"" + searchTerm + "\" in " + fileName + ". Please narrow your search.";
        }
        StringBuilder stringBuilder = result.append("Found " + numMatches + " matches for \"" + searchTerm + "\" in " + fileName + ":");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        Iterable $this$forEach$iv = matches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int lineNumber = ((Number)pair.component1()).intValue();
            String lineText2 = (String)pair.component2();
            if (printAround && lineNumber - 1 >= 0) {
                String prevLineText;
                int prevLineStartOffset = document.getLineStartOffset(lineNumber - 1);
                int prevLineEndOffset = document.getLineEndOffset(lineNumber - 1);
                Intrinsics.checkNotNullExpressionValue((Object)document.getText(new TextRange(prevLineStartOffset, prevLineEndOffset)), (String)"getText(...)");
                result.append("Line " + lineNumber + ": " + prevLineText + "\n");
            }
            result.append("Line " + (lineNumber + 1) + ": " + lineText2 + "\n");
            if (printAround && lineNumber + 1 < document.getLineCount()) {
                String nextLineText;
                int nextLineStartOffset = document.getLineStartOffset(lineNumber + 1);
                int nextLineEndOffset = document.getLineEndOffset(lineNumber + 1);
                Intrinsics.checkNotNullExpressionValue((Object)document.getText(new TextRange(nextLineStartOffset, nextLineEndOffset)), (String)"getText(...)");
                result.append("Line " + (lineNumber + 2) + ": " + nextLineText + "\n");
            }
            if (!printAround) continue;
            result.append("\n");
        }
        StringBuilder stringBuilder2 = result.append("End of matches for \"" + searchTerm + "\" in " + fileName);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String searchInDocument$default(Document document, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return SearchInFileAgentActionKt.searchInDocument(document, string, string2, bl);
    }
}

