/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.helpers;

import com.intellij.ml.llm.matterhorn.ArtifactRequestExecutorService;
import com.intellij.ml.llm.matterhorn.CacheType;
import com.intellij.ml.llm.matterhorn.MatterhornCaches;
import com.intellij.ml.llm.matterhorn.ProjectFileStructure;
import com.intellij.ml.llm.matterhorn.ProjectStructureFile;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0006H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/matterhorn/helpers/ProjectStateHelper;", "", "<init>", "()V", "matterhornProjectFolders", "", "", "getMatterhornProjectFolders", "()Ljava/util/List;", "saveInitialProjectState", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptionFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "restoreInitialProjectState", "", "getCurrentProjectState", "Lcom/intellij/ml/llm/matterhorn/ProjectFileStructure;", "projectDir", "storeFileContent", "projectStructure", "file", "projectDirPath", "core"})
@SourceDebugExtension(value={"SMAP\nProjectStateHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStateHelper.kt\ncom/intellij/ml/llm/matterhorn/helpers/ProjectStateHelper\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Json.kt\nkotlinx/serialization/json/Json\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n31#2,2:81\n31#2,2:84\n113#3:83\n1#4:86\n96#5:87\n3829#6:88\n4344#6,2:89\n4154#6:91\n4254#6,2:92\n1863#7,2:94\n14#8:96\n*S KotlinDebug\n*F\n+ 1 ProjectStateHelper.kt\ncom/intellij/ml/llm/matterhorn/helpers/ProjectStateHelper\n*L\n19#1:81,2\n35#1:84,2\n26#1:83\n43#1:87\n56#1:88\n56#1:89,2\n59#1:91\n59#1:92,2\n59#1:94,2\n77#1:96\n*E\n"})
public final class ProjectStateHelper {
    @NotNull
    public static final ProjectStateHelper INSTANCE = new ProjectStateHelper();
    @NotNull
    private static final List<String> matterhornProjectFolders;

    private ProjectStateHelper() {
    }

    @NotNull
    public final List<String> getMatterhornProjectFolders() {
        return matterhornProjectFolders;
    }

    public final void saveInitialProjectState(@NotNull Project project, @NotNull VirtualFile descriptionFile) {
        String initialStateFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptionFile, (String)"descriptionFile");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ArtifactRequestExecutorService> serviceClass$iv = ArtifactRequestExecutorService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ArtifactRequestExecutorService service = (ArtifactRequestExecutorService)object;
        MatterhornCaches cache = service.getCaches();
        if (!cache.contains(CacheType.Sources, initialStateFile = project.getName() + ".initial_state")) {
            ProjectFileStructure currentState = this.getCurrentProjectState(service.getProjectPath(), descriptionFile);
            StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
            boolean $i$f$encodeToString = false;
            $this$encodeToString$iv.getSerializersModule();
            String content = $this$encodeToString$iv.encodeToString((SerializationStrategy)ProjectFileStructure.Companion.serializer(), (Object)currentState);
            cache.save(CacheType.Sources, initialStateFile, content);
        }
    }

    public final boolean restoreInitialProjectState(@NotNull Project project) {
        String string;
        MatterhornCaches cache;
        ArtifactRequestExecutorService service;
        block4: {
            Iterable<String> sourcePaths;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ArtifactRequestExecutorService> serviceClass$iv = ArtifactRequestExecutorService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            service = (ArtifactRequestExecutorService)object;
            cache = service.getCaches();
            Iterable<String> iterable = sourcePaths = cache.loadAllPaths(CacheType.Sources);
            Iterator<String> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                String string2;
                String it = string2 = iterator.next();
                boolean bl = false;
                if (!StringsKt.endsWith$default((String)it, (String)".initial_state", (boolean)false, (int)2, null)) continue;
                string = string2;
                break block4;
            }
            string = null;
        }
        String initialStatePath = string;
        if (initialStatePath == null) {
            return false;
        }
        String string3 = cache.load(CacheType.Sources, initialStatePath);
        if (string3 == null) {
            return false;
        }
        String initialStateText = string3;
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        ProjectFileStructure projectStructure = (ProjectFileStructure)this_$iv.decodeFromString((DeserializationStrategy)ProjectFileStructure.Companion.serializer(), initialStateText);
        WriteAction.run(() -> ProjectStateHelper.restoreInitialProjectState$lambda$1(projectStructure, project, service));
        cache.clear();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectFileStructure getCurrentProjectState(VirtualFile projectDir, VirtualFile descriptionFile) {
        ProjectFileStructure projectStructure;
        block5: {
            void $this$filterTo$iv$iv;
            projectStructure = new ProjectFileStructure();
            String string = projectDir.getCanonicalPath();
            if (string == null) break block5;
            String projectDirPath = string;
            boolean bl = false;
            INSTANCE.storeFileContent(projectStructure, descriptionFile, projectDirPath);
            VirtualFile[] virtualFileArray = projectDir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Object[] destination$iv$iv = (Object[])new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv = $this$filterTo$iv$iv[i];
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (!matterhornProjectFolders.contains(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List matterhornDirs = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            while (!((Collection)matterhornDirs).isEmpty()) {
                void $this$forEach$iv;
                void $this$filterNotTo$iv$iv;
                VirtualFile directory = (VirtualFile)CollectionsKt.removeFirst((List)matterhornDirs);
                VirtualFile[] virtualFileArray2 = directory.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getChildren(...)");
                Object $this$filterNot$iv = virtualFileArray2;
                boolean $i$f$filterNot = false;
                destination$iv$iv = $this$filterNot$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (void element$iv$iv : $this$filterNotTo$iv$iv) {
                    VirtualFile p0 = (VirtualFile)element$iv$iv;
                    boolean bl3 = false;
                    if (projectStructure.isIgnored(p0)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VirtualFile child = (VirtualFile)element$iv;
                    boolean bl4 = false;
                    if (child.isDirectory()) {
                        matterhornDirs.add(child);
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)child);
                    if (!VirtualFileUtil.isFile((VirtualFile)child)) continue;
                    INSTANCE.storeFileContent(projectStructure, child, projectDirPath);
                }
            }
        }
        return projectStructure;
    }

    private final void storeFileContent(ProjectFileStructure projectStructure, VirtualFile file, String projectDirPath) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        String relativePath = StringsKt.substringAfter$default((String)filePath, (String)projectDirPath, null, (int)2, null);
        try {
            ProjectStructureFile projectStructureFile = projectStructure.getRoot().findOrCreateFile(relativePath);
            InputStream inputStream = file.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            projectStructureFile.setContent(TextStreamsKt.readText((Reader)new InputStreamReader(inputStream2, charset)));
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ProjectStateHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Couldn't read file " + filePath, (Throwable)e);
        }
    }

    private static final void restoreInitialProjectState$lambda$1(ProjectFileStructure $projectStructure, Project $project, ArtifactRequestExecutorService $service) {
        $projectStructure.apply($project, $service.getProjectPath(), false);
    }

    static {
        Object[] objectArray = new String[]{"api", "backend", "frontend"};
        matterhornProjectFolders = CollectionsKt.listOf((Object[])objectArray);
    }
}

