/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.relevance.extractors;

import com.intellij.ml.llm.matterhorn.relevance.extractors.ElementProvider;
import com.intellij.ml.llm.matterhorn.relevance.extractors.ExtractorUtilsKt;
import com.intellij.ml.llm.matterhorn.relevance.extractors.FormatHierarchyParams;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120\u0016J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120\u0016H\u0002J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/matterhorn/relevance/extractors/PsiTrie;", "", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "document$delegate", "Lkotlin/Lazy;", "children", "", "Lcom/intellij/psi/PsiElement;", "build", "", "format", "Lcom/intellij/ml/llm/matterhorn/relevance/extractors/FormatHierarchyParams;", "consumer", "Lkotlin/Function2;", "", "prefix", "add", "element", "ej-core"})
@SourceDebugExtension(value={"SMAP\nExtractorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractorUtils.kt\ncom/intellij/ml/llm/matterhorn/relevance/extractors/PsiTrie\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,183:1\n216#2,2:184\n381#3,7:186\n*S KotlinDebug\n*F\n+ 1 ExtractorUtils.kt\ncom/intellij/ml/llm/matterhorn/relevance/extractors/PsiTrie\n*L\n33#1:184,2\n62#1:186,7\n*E\n"})
public final class PsiTrie {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Lazy document$delegate;
    @NotNull
    private final Map<PsiElement, PsiTrie> children;

    public PsiTrie(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.document$delegate = LazyKt.lazy(() -> PsiTrie.document_delegate$lambda$0(this));
        this.children = new LinkedHashMap();
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    private final Document getDocument() {
        Lazy lazy = this.document$delegate;
        return (Document)lazy.getValue();
    }

    public final void build(@NotNull FormatHierarchyParams format2, @NotNull Function2<? super PsiElement, ? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.build("", format2, consumer);
    }

    private final void build(String prefix, FormatHierarchyParams format2, Function2<? super PsiElement, ? super String, Unit> consumer) {
        Map<PsiElement, PsiTrie> $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<PsiElement, PsiTrie>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PsiElement, PsiTrie> element$iv;
            Map.Entry<PsiElement, PsiTrie> entry = element$iv = iterator.next();
            boolean bl = false;
            PsiElement node = entry.getKey();
            PsiTrie childTrie = entry.getValue();
            String nodeText = ElementProvider.Companion.getDeclarationString(this.file, node, format2.getDeclarationParams());
            boolean bl2 = ((CharSequence)nodeText).length() == 0;
            if (bl2) {
                childTrie.build(prefix, format2, consumer);
                continue;
            }
            String elementRange = ExtractorUtilsKt.getElementRange(this.getDocument(), node);
            if (format2.getShowRanges()) {
                consumer.invoke((Object)node, (Object)((Object)StringsKt.trim((CharSequence)(prefix + " " + nodeText + " " + elementRange))).toString());
            } else {
                consumer.invoke((Object)node, (Object)((Object)StringsKt.trim((CharSequence)(prefix + " " + nodeText))).toString());
            }
            childTrie.build(((Object)StringsKt.trim((CharSequence)(prefix + " " + nodeText))).toString(), format2, consumer);
        }
    }

    public final void add(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List path = new ArrayList();
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            path.add(current);
        }
        CollectionsKt.reverse((List)path);
        PsiTrie node = this;
        for (PsiElement e : path) {
            PsiTrie psiTrie;
            Map<PsiElement, PsiTrie> $this$getOrPut$iv = node.children;
            boolean $i$f$getOrPut = false;
            PsiTrie value$iv = $this$getOrPut$iv.get(e);
            if (value$iv == null) {
                boolean bl = false;
                PsiTrie answer$iv = new PsiTrie(this.file);
                $this$getOrPut$iv.put(e, answer$iv);
                psiTrie = answer$iv;
            } else {
                psiTrie = value$iv;
            }
            node = psiTrie;
        }
    }

    private static final Document document_delegate$lambda$0(PsiTrie this$0) {
        Document document = this$0.file.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        return document;
    }
}

