/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.frontend.compose.util;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/agents/frontend/compose/util/SafeCommandChecker;", "", "<init>", "()V", "MODIFYING_OPERATORS", "", "", "SAFE_COMMANDS_UNIX", "SAFE_COMMANDS_POWERSHELL", "SAFE_COMMANDS", "SAFE_SUBCOMMANDS", "", "DANGEROUS_FLAGS", "isReadOnly", "", "command", "intellij.ml.llm.agents.frontend"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSafeCommandChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SafeCommandChecker.kt\ncom/intellij/ml/llm/agents/frontend/compose/util/SafeCommandChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1761#2,3:136\n1761#2,3:139\n*S KotlinDebug\n*F\n+ 1 SafeCommandChecker.kt\ncom/intellij/ml/llm/agents/frontend/compose/util/SafeCommandChecker\n*L\n111#1:136,3\n121#1:139,3\n*E\n"})
public final class SafeCommandChecker {
    @NotNull
    public static final SafeCommandChecker INSTANCE = new SafeCommandChecker();
    @NotNull
    private static final Set<String> MODIFYING_OPERATORS;
    @NotNull
    private static final Set<String> SAFE_COMMANDS_UNIX;
    @NotNull
    private static final Set<String> SAFE_COMMANDS_POWERSHELL;
    @NotNull
    private static final Set<String> SAFE_COMMANDS;
    @NotNull
    private static final Map<String, Set<String>> SAFE_SUBCOMMANDS;
    @NotNull
    private static final Map<String, Set<String>> DANGEROUS_FLAGS;
    public static final int $stable;

    private SafeCommandChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isReadOnly(@NotNull String command) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String trimmed = ((Object)StringsKt.trim((CharSequence)command)).toString();
        if (((CharSequence)trimmed).length() == 0) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) {
            return true;
        }
        Iterable $this$any$iv = MODIFYING_OPERATORS;
        boolean $i$f$any22 = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                String string = (String)element$iv;
                boolean bl3 = false;
                if (!StringsKt.contains$default((CharSequence)trimmed, (CharSequence)string, (boolean)false, (int)2, null)) continue;
                return false;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        CharSequence $i$f$any22 = trimmed;
        Regex regex = new Regex("\\s+");
        int element$iv = 2;
        List parts = regex.split($i$f$any22, element$iv);
        String string = StringsKt.removeSuffix((String)StringsKt.substringAfterLast$default((String)StringsKt.substringAfterLast$default((String)((String)parts.get(0)), (char)'/', null, (int)2, null), (char)'\\', null, (int)2, null), (CharSequence)".exe").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String baseCommand = string;
        Set<String> set = DANGEROUS_FLAGS.get(baseCommand);
        if (set != null) {
            String it;
            Set<String> set2 = set;
            boolean bl4 = false;
            if (parts.size() <= 1) return true;
            Iterable $this$any$iv2 = set2;
            boolean $i$f$any = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$any$iv2.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv2 = iterator.next();
                it = (String)element$iv2;
                boolean bl5 = false;
            } while (!StringsKt.contains$default((CharSequence)((CharSequence)parts.get(1)), (CharSequence)it, (boolean)false, (int)2, null));
            return false;
        }
        if (SAFE_COMMANDS.contains(baseCommand)) {
            return true;
        }
        Set<String> set3 = SAFE_SUBCOMMANDS.get(baseCommand);
        if (set3 == null) return false;
        if (parts.size() <= 1) return false;
        CharSequence charSequence = (CharSequence)parts.get(1);
        Regex regex2 = new Regex("\\s+");
        int n = 0;
        String string2 = (String)CollectionsKt.firstOrNull((List)regex2.split(charSequence, n));
        String string3 = string2;
        if (string2 == null) return false;
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        string3 = string4;
        if (string4 == null) {
            return false;
        }
        String secondPart = string3;
        return set3.contains(secondPart);
    }

    static {
        Object[] objectArray = new String[]{">", ">>", ">|", "2>", "&>"};
        MODIFYING_OPERATORS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"cat", "head", "tail", "less", "more", "bat", "find", "ls", "tree", "grep", "rg", "ag", "fd", "fzf", "locate", "wc", "sort", "uniq", "diff", "cmp", "tr", "cut", "awk", "pwd", "whoami", "hostname", "uname", "date", "uptime", "which", "type", "printenv", "env", "file", "stat", "du", "df", "ps", "echo", "printf", "test", "true", "false", "man", "help", "jq", "yq", "base64", "md5sum", "sha256sum"};
        SAFE_COMMANDS_UNIX = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"echo", "write-output", "write-host", "write-verbose", "write-debug", "write-information", "out-host", "out-string", "format-table", "ft", "format-list", "fl", "format-wide", "fw", "dir", "ls", "get-childitem", "gci", "cat", "type", "gc", "get-content", "get-location", "gl", "pwd", "resolve-path", "rvpa", "split-path", "join-path", "test-path", "tp", "get-item", "gi", "get-itemproperty", "gp", "select-string", "sls", "findstr", "select-object", "select", "where-object", "where", "?", "sort-object", "sort", "group-object", "group", "measure-object", "measure", "foreach-object", "foreach", "%", "compare-object", "diff", "whoami", "hostname", "get-host", "get-process", "gps", "ps", "get-service", "gsv", "get-date", "get-culture", "get-uiculture", "get-computerinfo", "get-hotfix", "get-variable", "gv", "get-psdrive", "get-history", "ghy", "h", "history", "get-help", "help", "man", "get-command", "gcm", "get-alias", "gal", "get-module", "gmo", "get-member", "gm", "get-eventlog", "get-winevent", "get-wmiobject", "gwmi", "get-ciminstance", "gcim", "get-clipboard"};
        SAFE_COMMANDS_POWERSHELL = SetsKt.setOf((Object[])objectArray);
        SAFE_COMMANDS = SetsKt.plus(SAFE_COMMANDS_UNIX, (Iterable)SAFE_COMMANDS_POWERSHELL);
        objectArray = new Pair[8];
        Object[] objectArray2 = new String[]{"status", "log", "diff", "show", "branch", "tag", "remote", "config", "ls-files", "ls-tree", "cat-file", "rev-parse", "describe", "shortlog", "blame", "reflog"};
        objectArray[0] = TuplesKt.to((Object)"git", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"ps", "images", "inspect", "logs", "stats", "info", "version"};
        objectArray[1] = TuplesKt.to((Object)"docker", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"get", "describe", "logs", "config", "version", "cluster-info"};
        objectArray[2] = TuplesKt.to((Object)"kubectl", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"list", "ls", "view", "info", "outdated", "search"};
        objectArray[3] = TuplesKt.to((Object)"npm", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"list", "info", "outdated", "why"};
        objectArray[4] = TuplesKt.to((Object)"yarn", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"list", "show", "freeze", "check"};
        objectArray[5] = TuplesKt.to((Object)"pip", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"check", "tree", "metadata", "version"};
        objectArray[6] = TuplesKt.to((Object)"cargo", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"tasks", "dependencies", "properties"};
        objectArray[7] = TuplesKt.to((Object)"gradle", (Object)SetsKt.setOf((Object[])objectArray2));
        SAFE_SUBCOMMANDS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"-i", "--in-place"};
        DANGEROUS_FLAGS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"sed", (Object)SetsKt.setOf((Object[])objectArray)));
        $stable = 8;
    }
}

