/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.frontend.notifications;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.agents.frontend.messages.AIAAgentsFrontendBundle;
import com.intellij.ml.llm.chat.shared.ChatSessionAgent;
import com.intellij.ml.llm.chat.shared.ChatSessionAgentId;
import com.intellij.ml.llm.chat.shared.ChatSessionNotificationType;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.ApplicationKt;
import com.intellij.util.system.OS;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ'\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u000b\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications;", "", "<init>", "()V", "isIdeFocused", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications$FocusState;", "showNotification", "", "agent", "Lcom/intellij/ml/llm/chat/shared/ChatSessionAgent;", "notificationType", "Lcom/intellij/ml/llm/chat/shared/ChatSessionNotificationType;", "notifyWhenIdeInBackground", "agentId", "Lcom/intellij/ml/llm/chat/shared/ChatSessionAgentId;", "message", "", "Lorg/jetbrains/annotations/Nls;", "ideFrame", "Lcom/intellij/openapi/wm/IdeFrame;", "Companion", "ActivationListener", "FocusState", "intellij.ml.llm.agents.frontend"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFrontendNotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendNotifications.kt\ncom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,77:1\n13#2:78\n13#2:79\n*S KotlinDebug\n*F\n+ 1 FrontendNotifications.kt\ncom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications\n*L\n53#1:78\n55#1:79\n*E\n"})
public final class FrontendNotifications {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableStateFlow<FocusState> isIdeFocused = StateFlowKt.MutableStateFlow((Object)FocusState.Companion.getDefault());
    public static final int $stable = 8;

    public final void showNotification(@NotNull ChatSessionAgent agent, @NotNull ChatSessionNotificationType notificationType) {
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)notificationType, (String)"notificationType");
        FocusState focusState = (FocusState)this.isIdeFocused.getValue();
        if (focusState.isIdeFocused()) {
            return;
        }
        String message = switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
            case 1 -> {
                Object[] var5_4 = new Object[]{agent.getName()};
                yield AIAAgentsFrontendBundle.message("aia.agents.notification.completed", var5_4);
            }
            case 2 -> {
                Object[] var5_4 = new Object[]{agent.getName()};
                yield AIAAgentsFrontendBundle.message("aia.agents.notification.user.requested", var5_4);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        this.notifyWhenIdeInBackground(agent.getId(), message, focusState.getIdeFrame());
    }

    private final void notifyWhenIdeInBackground(ChatSessionAgentId agentId, String message, IdeFrame ideFrame) {
        Object $this$notifyWhenIdeInBackground_u24lambda_u240;
        Object object = this;
        try {
            Unit unit;
            $this$notifyWhenIdeInBackground_u24lambda_u240 = object;
            boolean bl = false;
            IdeFrame ideFrame2 = ideFrame;
            if (ideFrame2 != null) {
                IdeFrame frame = ideFrame2;
                boolean bl2 = false;
                ApplicationManager.getApplication().invokeLater(() -> FrontendNotifications.notifyWhenIdeInBackground$lambda$0$0$0(frame, agentId, message));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            $this$notifyWhenIdeInBackground_u24lambda_u240 = Result.constructor-impl(unit);
        }
        catch (Throwable bl) {
            $this$notifyWhenIdeInBackground_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$notifyWhenIdeInBackground_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$notifyWhenIdeInBackground_u24lambda_u240 = throwable;
            boolean bl = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FrontendNotifications.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)it);
        }
        if (Result.isSuccess-impl((Object)object)) {
            Unit it = (Unit)object;
            boolean bl = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FrontendNotifications.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Notification sent successfully: " + message);
        }
    }

    private static final void notifyWhenIdeInBackground$lambda$0$0$0(IdeFrame $frame, ChatSessionAgentId $agentId, String $message) {
        block1: {
            if (OS.CURRENT == OS.macOS) {
                WindowManagerEx.getInstanceEx().requestUserAttention($frame, true);
            }
            SystemNotifications systemNotifications = SystemNotifications.getInstance();
            if (systemNotifications == null) break block1;
            systemNotifications.notify($agentId.getId(), "", $message);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications$ActivationListener;", "Lcom/intellij/openapi/application/ApplicationActivationListener;", "<init>", "()V", "applicationActivated", "", "ideFrame", "Lcom/intellij/openapi/wm/IdeFrame;", "applicationDeactivated", "intellij.ml.llm.agents.frontend"})
    @StabilityInferred(parameters=1)
    public static final class ActivationListener
    implements ApplicationActivationListener {
        public static final int $stable;

        public void applicationActivated(@NotNull IdeFrame ideFrame) {
            Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
            Companion.getInstance().isIdeFocused.tryEmit((Object)new FocusState(true, ideFrame));
        }

        public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
            Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
            Companion.getInstance().isIdeFocused.tryEmit((Object)new FocusState(false, ideFrame));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications;", "intellij.ml.llm.agents.frontend"})
    @SourceDebugExtension(value={"SMAP\nFrontendNotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendNotifications.kt\ncom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,77:1\n30#2,2:78\n*S KotlinDebug\n*F\n+ 1 FrontendNotifications.kt\ncom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications$Companion\n*L\n24#1:78,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendNotifications getInstance() {
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<FrontendNotifications> serviceClass$iv = FrontendNotifications.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendNotifications)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications$FocusState;", "", "isIdeFocused", "", "ideFrame", "Lcom/intellij/openapi/wm/IdeFrame;", "<init>", "(ZLcom/intellij/openapi/wm/IdeFrame;)V", "()Z", "getIdeFrame", "()Lcom/intellij/openapi/wm/IdeFrame;", "Companion", "intellij.ml.llm.agents.frontend"})
    private static final class FocusState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean isIdeFocused;
        @Nullable
        private final IdeFrame ideFrame;
        @NotNull
        private static final FocusState Default = new FocusState(false, null);

        public FocusState(boolean isIdeFocused, @Nullable IdeFrame ideFrame) {
            this.isIdeFocused = isIdeFocused;
            this.ideFrame = ideFrame;
        }

        public /* synthetic */ FocusState(boolean bl, IdeFrame ideFrame, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                ideFrame = null;
            }
            this(bl, ideFrame);
        }

        public final boolean isIdeFocused() {
            return this.isIdeFocused;
        }

        @Nullable
        public final IdeFrame getIdeFrame() {
            return this.ideFrame;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications$FocusState$Companion;", "", "<init>", "()V", "Default", "Lcom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications$FocusState;", "getDefault", "()Lcom/intellij/ml/llm/agents/frontend/notifications/FrontendNotifications$FocusState;", "intellij.ml.llm.agents.frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FocusState getDefault() {
                return Default;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChatSessionNotificationType.values().length];
            try {
                nArray[ChatSessionNotificationType.TaskFinished.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatSessionNotificationType.RequireHumanAttention.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

