/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.terminal.TerminalAiPromotionManager;
import com.intellij.ml.llm.terminal.TerminalAiPromotionPlaceholderManager;
import com.intellij.ml.llm.terminal.TerminalAiSettingsStorage;
import com.intellij.ml.llm.terminal.TerminalTextToCommandModeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptCustomEnterHandler;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiPromotionManager;", "", "<init>", "()V", "installPromotion", "", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "textToCommandModeManager", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager;", "CommandExecutionListener", "intellij.ml.llm.terminal"})
public final class TerminalAiPromotionManager {
    @NotNull
    public static final TerminalAiPromotionManager INSTANCE = new TerminalAiPromotionManager();

    private TerminalAiPromotionManager() {
    }

    public final void installPromotion(@NotNull TerminalPromptModel promptModel, @NotNull TerminalTextToCommandModeManager textToCommandModeManager) {
        Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
        Intrinsics.checkNotNullParameter((Object)textToCommandModeManager, (String)"textToCommandModeManager");
        TerminalAiSettingsStorage aiSettingsStorage = TerminalAiSettingsStorage.Companion.getInstance();
        if (aiSettingsStorage.getDetectNaturalLanguage() && AIAssistantUIUtil.INSTANCE.isAssistantActive(promptModel.getEditor().getProject())) {
            TerminalAiPromotionPlaceholderManager.Companion.install(promptModel, textToCommandModeManager);
        }
        aiSettingsStorage.addListener((Disposable)promptModel, new TerminalAiSettingsStorage.ChangesListener(promptModel, textToCommandModeManager){
            final /* synthetic */ TerminalPromptModel $promptModel;
            final /* synthetic */ TerminalTextToCommandModeManager $textToCommandModeManager;
            {
                this.$promptModel = $promptModel;
                this.$textToCommandModeManager = $textToCommandModeManager;
            }

            public void detectNaturalLanguageChanged(boolean newValue) {
                ActionsKt.runInEdt$default(null, () -> installPromotion.1.detectNaturalLanguageChanged$lambda$0(this.$promptModel, newValue, this.$textToCommandModeManager), (int)1, null);
            }

            private static final Unit detectNaturalLanguageChanged$lambda$0(TerminalPromptModel $promptModel, boolean $newValue, TerminalTextToCommandModeManager $textToCommandModeManager) {
                boolean isPlaceholderInstalled = TerminalAiPromotionPlaceholderManager.Companion.isInstalled($promptModel);
                if ($newValue && !isPlaceholderInstalled && AIAssistantUIUtil.INSTANCE.isAssistantActive($promptModel.getEditor().getProject())) {
                    TerminalAiPromotionPlaceholderManager.Companion.install($promptModel, $textToCommandModeManager);
                } else if (!$newValue && isPlaceholderInstalled) {
                    TerminalAiPromotionPlaceholderManager.Companion.deinstall($promptModel);
                }
                return Unit.INSTANCE;
            }
        });
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiPromotionManager$CommandExecutionListener;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptCustomEnterHandler;", "<init>", "()V", "handleEnter", "", "model", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "intellij.ml.llm.terminal"})
    private static final class CommandExecutionListener
    implements TerminalPromptCustomEnterHandler {
        public boolean handleEnter(@NotNull TerminalPromptModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            TerminalAiPromotionPlaceholderManager.Companion.deinstall(model);
            return false;
        }
    }
}

