/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.ml.llm.terminal.TerminalAiFalseLanguageDetectionsReporter;
import com.intellij.ml.llm.terminal.TerminalAiPromptEventsReporterKt;
import com.intellij.ml.llm.terminal.TerminalAiPromptStateChangeEvent;
import com.intellij.ml.llm.terminal.TerminalAiSettingsStorage;
import com.intellij.ml.llm.terminal.TerminalAiUsageCollector;
import com.intellij.ml.llm.terminal.TerminalTextToCommandModeState;
import com.intellij.util.TimeoutUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJM\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiPromptEventsReporter;", "", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;)V", "curSession", "Lcom/intellij/ml/llm/terminal/TerminalAiPromptEventsReporter$ReportingSession;", "reportEventHappened", "", "event", "Lcom/intellij/ml/llm/terminal/TerminalAiPromptStateChangeEvent;", "newState", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeState;", "reportLanguageDetected", "userInput", "", "textLength", "", "tokensCount", "isTooShort", "", "startsWithExecutableName", "mlModelIsShell", "resultingIsShell", "inferenceTime", "", "reportLanguageDetected$intellij_ml_llm_terminal", "getOrCreateCurrentSession", "startSession", "startReportingActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "ReportingSession", "intellij.ml.llm.terminal"})
public final class TerminalAiPromptEventsReporter {
    @NotNull
    private final TerminalPromptModel promptModel;
    @Nullable
    private ReportingSession curSession;

    public TerminalAiPromptEventsReporter(@NotNull TerminalPromptModel promptModel) {
        Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
        this.promptModel = promptModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reportEventHappened(@NotNull TerminalAiPromptStateChangeEvent event, @NotNull TerminalTextToCommandModeState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        TerminalAiPromptEventsReporter terminalAiPromptEventsReporter = this;
        synchronized (terminalAiPromptEventsReporter) {
            boolean bl = false;
            if (event != TerminalAiPromptStateChangeEvent.ALL_TEXT_REMOVED || this.curSession != null) {
                ReportingSession session = this.getOrCreateCurrentSession();
                session.getActivity().stageStarted(TerminalAiUsageCollector.INSTANCE.getAiPromptEventHappened(), () -> TerminalAiPromptEventsReporter.reportEventHappened$lambda$0$0(event, newState, session));
                TerminalAiFalseLanguageDetectionsReporter terminalAiFalseLanguageDetectionsReporter = session.getFalseLanguageDetectionsReporter();
                if (terminalAiFalseLanguageDetectionsReporter != null) {
                    terminalAiFalseLanguageDetectionsReporter.eventHappened(event, newState);
                }
                if (event == TerminalAiPromptStateChangeEvent.ALL_TEXT_REMOVED || event == TerminalAiPromptStateChangeEvent.COMMAND_EXECUTED) {
                    StructuredIdeActivity.finished$default((StructuredIdeActivity)session.getActivity(), null, (int)1, null);
                    this.curSession = null;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reportLanguageDetected$intellij_ml_llm_terminal(@NotNull String userInput, int textLength, int tokensCount, boolean isTooShort, boolean startsWithExecutableName, boolean mlModelIsShell, boolean resultingIsShell, long inferenceTime) {
        Intrinsics.checkNotNullParameter((Object)userInput, (String)"userInput");
        TerminalAiPromptEventsReporter terminalAiPromptEventsReporter = this;
        synchronized (terminalAiPromptEventsReporter) {
            Unit unit;
            boolean bl = false;
            ReportingSession session = this.getOrCreateCurrentSession();
            session.getActivity().stageStarted(TerminalAiUsageCollector.INSTANCE.getLangDetectionPerformedEvent(), () -> TerminalAiPromptEventsReporter.reportLanguageDetected$lambda$0$0(textLength, tokensCount, isTooShort, startsWithExecutableName, mlModelIsShell, resultingIsShell, inferenceTime));
            TerminalAiFalseLanguageDetectionsReporter terminalAiFalseLanguageDetectionsReporter = session.getFalseLanguageDetectionsReporter();
            if (terminalAiFalseLanguageDetectionsReporter != null) {
                terminalAiFalseLanguageDetectionsReporter.languageDetected(userInput);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    private final ReportingSession getOrCreateCurrentSession() {
        ReportingSession session;
        ReportingSession reportingSession = this.curSession;
        if (reportingSession == null) {
            reportingSession = this.startSession();
        }
        this.curSession = session = reportingSession;
        return session;
    }

    private final ReportingSession startSession() {
        StructuredIdeActivity activity = this.startReportingActivity();
        TerminalAiFalseLanguageDetectionsReporter falseLanguageDetectionsReporter = TerminalAiSettingsStorage.Companion.getInstance().getDetectNaturalLanguage() ? new TerminalAiFalseLanguageDetectionsReporter(this.promptModel) : null;
        return new ReportingSession(activity, falseLanguageDetectionsReporter);
    }

    private final StructuredIdeActivity startReportingActivity() {
        return TerminalAiUsageCollector.INSTANCE.getAiPromptSessionActivity().started(this.promptModel.getEditor().getProject(), () -> TerminalAiPromptEventsReporter.startReportingActivity$lambda$0(this));
    }

    private static final List reportEventHappened$lambda$0$0(TerminalAiPromptStateChangeEvent $event, TerminalTextToCommandModeState $newState, ReportingSession $session) {
        Object[] objectArray = new EventPair[]{TerminalAiUsageCollector.INSTANCE.getPROMPT_STATE_CHANGE_EVENT_FIELD().with((Object)$event), TerminalAiUsageCollector.INSTANCE.getPROMPT_STATE_FIELD().with((Object)$newState), TerminalAiUsageCollector.INSTANCE.getSESSION_TIME_FIELD().with((Object)TimeoutUtil.getDurationMillis((long)$session.getActivity().getStartedTimestamp()))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List reportLanguageDetected$lambda$0$0(int $textLength, int $tokensCount, boolean $isTooShort, boolean $startsWithExecutableName, boolean $mlModelIsShell, boolean $resultingIsShell, long $inferenceTime) {
        Object[] objectArray = new EventPair[]{TerminalAiUsageCollector.INSTANCE.getTEXT_LENGTH_FIELD().with((Object)$textLength), TerminalAiUsageCollector.INSTANCE.getTOKENS_COUNT_FIELD().with((Object)$tokensCount), TerminalAiUsageCollector.INSTANCE.getIS_TOO_SHORT_FIELD().with((Object)$isTooShort), TerminalAiUsageCollector.INSTANCE.getSTARTS_WITH_EXECUTABLE_NAME_FIELD().with((Object)$startsWithExecutableName), TerminalAiUsageCollector.INSTANCE.getML_MODEL_IS_SHELL().with((Object)$mlModelIsShell), TerminalAiUsageCollector.INSTANCE.getRESULTING_IS_SHELL_FIELD().with((Object)$resultingIsShell), TerminalAiUsageCollector.INSTANCE.getINFERENCE_TIME_FIELD().with((Object)$inferenceTime)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List startReportingActivity$lambda$0(TerminalAiPromptEventsReporter this$0) {
        ShellType shellType = TerminalAiPromptEventsReporterKt.getShellType(this$0.promptModel);
        return shellType != null ? CollectionsKt.listOf((Object)TerminalAiUsageCollector.INSTANCE.getSHELL_TYPE_FIELD().with((Object)shellType)) : CollectionsKt.emptyList();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiPromptEventsReporter$ReportingSession;", "", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "falseLanguageDetectionsReporter", "Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter;", "<init>", "(Lcom/intellij/internal/statistic/StructuredIdeActivity;Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter;)V", "getActivity", "()Lcom/intellij/internal/statistic/StructuredIdeActivity;", "getFalseLanguageDetectionsReporter", "()Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter;", "intellij.ml.llm.terminal"})
    private static final class ReportingSession {
        @NotNull
        private final StructuredIdeActivity activity;
        @Nullable
        private final TerminalAiFalseLanguageDetectionsReporter falseLanguageDetectionsReporter;

        public ReportingSession(@NotNull StructuredIdeActivity activity, @Nullable TerminalAiFalseLanguageDetectionsReporter falseLanguageDetectionsReporter) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.activity = activity;
            this.falseLanguageDetectionsReporter = falseLanguageDetectionsReporter;
        }

        @NotNull
        public final StructuredIdeActivity getActivity() {
            return this.activity;
        }

        @Nullable
        public final TerminalAiFalseLanguageDetectionsReporter getFalseLanguageDetectionsReporter() {
            return this.falseLanguageDetectionsReporter;
        }
    }
}

