/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import com.intellij.ml.llm.terminal.TerminalAiPromptEventsReporter;
import com.intellij.ml.llm.terminal.TerminalAiPromptStateChangeEvent;
import com.intellij.ml.llm.terminal.TerminalLLMScopeProvider;
import com.intellij.ml.llm.terminal.TerminalTextToCommandModeState;
import com.intellij.ml.llm.terminal.TerminalTextToCommandSession;
import com.intellij.ml.llm.terminal.TerminalTextToCommandSessionListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptCustomEnterHandler;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 )2\u00020\u0001:\u0004&'()B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0010J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J \u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\f\u0010%\u001a\u00020\u0010*\u00020\u001bH\u0002J\f\u0010%\u001a\u00020\u0010*\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "reporter", "Lcom/intellij/ml/llm/terminal/TerminalAiPromptEventsReporter;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;Lcom/intellij/ml/llm/terminal/TerminalAiPromptEventsReporter;Lkotlinx/coroutines/CoroutineScope;)V", "stateChangeEventsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/ml/llm/terminal/TerminalAiPromptStateChangeEvent;", "mutableStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeState;", "stateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "activateTextToCommandMode", "", "reason", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager$AiModeEnablingReason;", "deactivateTextToCommandMode", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager$AiModeDisablingReason;", "updateState", "event", "calculateNewState", "curState", "reportEventHappened", "prevState", "newState", "toPromptStateChangeEvent", "CommandExecutionListener", "AiModeEnablingReason", "AiModeDisablingReason", "Companion", "intellij.ml.llm.terminal"})
public final class TerminalTextToCommandModeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalPromptModel promptModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalAiPromptEventsReporter reporter;
    @NotNull
    private final MutableSharedFlow<TerminalAiPromptStateChangeEvent> stateChangeEventsFlow;
    @NotNull
    private final MutableStateFlow<TerminalTextToCommandModeState> mutableStateFlow;
    @NotNull
    private final StateFlow<TerminalTextToCommandModeState> stateFlow;
    @NotNull
    private static final Key<TerminalTextToCommandModeManager> KEY;

    private TerminalTextToCommandModeManager(Project project, TerminalPromptModel promptModel, TerminalOutputModel outputModel, TerminalAiPromptEventsReporter reporter, CoroutineScope coroutineScope) {
        this.project = project;
        this.promptModel = promptModel;
        this.outputModel = outputModel;
        this.reporter = reporter;
        this.stateChangeEventsFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)10, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.mutableStateFlow = StateFlowKt.MutableStateFlow((Object)((Object)TerminalTextToCommandModeState.SHELL_INPUT));
        this.stateFlow = FlowKt.asStateFlow(this.mutableStateFlow);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalTextToCommandModeManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.stateChangeEventsFlow.collect(new FlowCollector(){

                            public final Object emit(TerminalAiPromptStateChangeEvent event, Continuation<? super Unit> $completion) {
                                TerminalTextToCommandModeState prevState = (TerminalTextToCommandModeState)((Object)this$0.mutableStateFlow.getValue());
                                TerminalTextToCommandModeState newState = this$0.calculateNewState(prevState, event);
                                this$0.mutableStateFlow.setValue((Object)newState);
                                this$0.reportEventHappened(prevState, newState, event);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.promptModel.getEditor().getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String curCommandName = CommandProcessor.getInstance().getCurrentCommandName();
                if (curCommandName != null && ((CharSequence)promptModel.getCommandText()).length() == 0) {
                    stateChangeEventsFlow.tryEmit((Object)TerminalAiPromptStateChangeEvent.ALL_TEXT_REMOVED);
                }
            }
        });
    }

    @NotNull
    public final StateFlow<TerminalTextToCommandModeState> getStateFlow() {
        return this.stateFlow;
    }

    public final void activateTextToCommandMode(@NotNull AiModeEnablingReason reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        TerminalTextToCommandSession session = TerminalTextToCommandSession.Companion.install(this.project, this.promptModel, this.outputModel);
        TerminalTextToCommandSession.addListener$default(session, new TerminalTextToCommandSessionListener(this){
            final /* synthetic */ TerminalTextToCommandModeManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void generationStarted() {
                TerminalTextToCommandModeManager.access$getStateChangeEventsFlow$p(this.this$0).tryEmit((Object)((Object)TerminalAiPromptStateChangeEvent.AI_GENERATION_STARTED));
            }

            public void generationFinished() {
                TerminalTextToCommandModeManager.access$getStateChangeEventsFlow$p(this.this$0).tryEmit((Object)((Object)TerminalAiPromptStateChangeEvent.AI_GENERATION_COMPLETED));
            }

            public void generationInterrupted() {
                TerminalTextToCommandModeManager.access$getStateChangeEventsFlow$p(this.this$0).tryEmit((Object)((Object)TerminalAiPromptStateChangeEvent.AI_GENERATION_INTERRUPTED));
            }
        }, null, 2, null);
        this.stateChangeEventsFlow.tryEmit((Object)this.toPromptStateChangeEvent(reason));
    }

    public final void deactivateTextToCommandMode(@NotNull AiModeDisablingReason reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        TerminalTextToCommandSession.Companion.deinstallAndResetToInitialState(this.promptModel);
        this.stateChangeEventsFlow.tryEmit((Object)this.toPromptStateChangeEvent(reason));
    }

    public final void updateState(@NotNull TerminalAiPromptStateChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        this.stateChangeEventsFlow.tryEmit((Object)event);
    }

    private final TerminalTextToCommandModeState calculateNewState(TerminalTextToCommandModeState curState, TerminalAiPromptStateChangeEvent event) {
        return switch (WhenMappings.$EnumSwitchMapping$1[curState.ordinal()]) {
            case 1 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
                    case 1: {
                        yield TerminalTextToCommandModeState.IMPLICIT_AI;
                    }
                    case 2: {
                        yield TerminalTextToCommandModeState.EXPLICIT_AI;
                    }
                    case 3: {
                        yield TerminalTextToCommandModeState.EXPLICIT_AI;
                    }
                    case 4: {
                        yield TerminalTextToCommandModeState.EXPLICIT_AI;
                    }
                    case 5: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT_WITHOUT_NL_DETECTION;
                    }
                    case 6: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT_WITHOUT_NL_DETECTION;
                    }
                }
                yield curState;
            }
            case 2 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
                    case 2: {
                        yield TerminalTextToCommandModeState.EXPLICIT_AI;
                    }
                    case 3: {
                        yield TerminalTextToCommandModeState.EXPLICIT_AI;
                    }
                    case 4: {
                        yield TerminalTextToCommandModeState.EXPLICIT_AI;
                    }
                    case 7: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT;
                    }
                    case 8: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT;
                    }
                    case 9: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT;
                    }
                    case 10: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT;
                    }
                }
                yield curState;
            }
            case 3 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
                    case 2: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT;
                    }
                    case 3: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT;
                    }
                    case 4: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT;
                    }
                    case 11: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT;
                    }
                    case 12: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT_WITHOUT_NL_DETECTION;
                    }
                }
                yield curState;
            }
            case 4 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
                    case 2: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT_WITHOUT_NL_DETECTION;
                    }
                    case 3: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT_WITHOUT_NL_DETECTION;
                    }
                    case 4: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT_WITHOUT_NL_DETECTION;
                    }
                    case 11: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT_WITHOUT_NL_DETECTION;
                    }
                    case 12: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT_WITHOUT_NL_DETECTION;
                    }
                    case 13: {
                        yield TerminalTextToCommandModeState.SHELL_INPUT_WITHOUT_NL_DETECTION;
                    }
                }
                yield curState;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void reportEventHappened(TerminalTextToCommandModeState prevState, TerminalTextToCommandModeState newState, TerminalAiPromptStateChangeEvent event) {
        boolean shouldReport = switch (WhenMappings.$EnumSwitchMapping$1[prevState.ordinal()]) {
            case 1 -> {
                if (event == TerminalAiPromptStateChangeEvent.NL_DETECTED || event == TerminalAiPromptStateChangeEvent.AI_ICON_CLICKED || event == TerminalAiPromptStateChangeEvent.AI_CONTEXT_MENU_OPTION_CLICKED || event == TerminalAiPromptStateChangeEvent.AI_SHORTCUT_PRESSED || event == TerminalAiPromptStateChangeEvent.COMMAND_EXECUTED || event == TerminalAiPromptStateChangeEvent.ALL_TEXT_REMOVED || event == TerminalAiPromptStateChangeEvent.COMMAND_HISTORY_SHOWN || event == TerminalAiPromptStateChangeEvent.COMMAND_SEARCH_SHOWN) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (event == TerminalAiPromptStateChangeEvent.AI_ICON_CLICKED || event == TerminalAiPromptStateChangeEvent.AI_CONTEXT_MENU_OPTION_CLICKED || event == TerminalAiPromptStateChangeEvent.AI_SHORTCUT_PRESSED || event == TerminalAiPromptStateChangeEvent.COMMAND_EXECUTED || event == TerminalAiPromptStateChangeEvent.ALL_TEXT_REMOVED || event == TerminalAiPromptStateChangeEvent.COMMAND_HISTORY_ABORTED || event == TerminalAiPromptStateChangeEvent.COMMAND_SEARCH_ABORTED) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (event == TerminalAiPromptStateChangeEvent.AI_ICON_CLICKED || event == TerminalAiPromptStateChangeEvent.AI_CONTEXT_MENU_OPTION_CLICKED || event == TerminalAiPromptStateChangeEvent.AI_SHORTCUT_PRESSED || event == TerminalAiPromptStateChangeEvent.ESCAPE_PRESSED || event == TerminalAiPromptStateChangeEvent.AI_GENERATION_STARTED || event == TerminalAiPromptStateChangeEvent.AI_GENERATION_COMPLETED || event == TerminalAiPromptStateChangeEvent.AI_GENERATION_INTERRUPTED) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (event == TerminalAiPromptStateChangeEvent.AI_ICON_CLICKED || event == TerminalAiPromptStateChangeEvent.AI_CONTEXT_MENU_OPTION_CLICKED || event == TerminalAiPromptStateChangeEvent.AI_SHORTCUT_PRESSED || event == TerminalAiPromptStateChangeEvent.ESCAPE_PRESSED || event == TerminalAiPromptStateChangeEvent.TEXT_PART_REMOVED || event == TerminalAiPromptStateChangeEvent.AI_GENERATION_STARTED || event == TerminalAiPromptStateChangeEvent.AI_GENERATION_COMPLETED || event == TerminalAiPromptStateChangeEvent.AI_GENERATION_INTERRUPTED) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        if (shouldReport) {
            this.reporter.reportEventHappened(event, newState);
        }
    }

    private final TerminalAiPromptStateChangeEvent toPromptStateChangeEvent(AiModeEnablingReason $this$toPromptStateChangeEvent) {
        return switch (WhenMappings.$EnumSwitchMapping$2[$this$toPromptStateChangeEvent.ordinal()]) {
            case 1 -> TerminalAiPromptStateChangeEvent.AI_ICON_CLICKED;
            case 2 -> TerminalAiPromptStateChangeEvent.AI_CONTEXT_MENU_OPTION_CLICKED;
            case 3 -> TerminalAiPromptStateChangeEvent.AI_SHORTCUT_PRESSED;
            case 4 -> TerminalAiPromptStateChangeEvent.NL_DETECTED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final TerminalAiPromptStateChangeEvent toPromptStateChangeEvent(AiModeDisablingReason $this$toPromptStateChangeEvent) {
        return switch (WhenMappings.$EnumSwitchMapping$3[$this$toPromptStateChangeEvent.ordinal()]) {
            case 1 -> TerminalAiPromptStateChangeEvent.AI_ICON_CLICKED;
            case 2 -> TerminalAiPromptStateChangeEvent.AI_CONTEXT_MENU_OPTION_CLICKED;
            case 3 -> TerminalAiPromptStateChangeEvent.AI_SHORTCUT_PRESSED;
            case 4 -> TerminalAiPromptStateChangeEvent.ESCAPE_PRESSED;
            case 5 -> TerminalAiPromptStateChangeEvent.TEXT_PART_REMOVED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public /* synthetic */ TerminalTextToCommandModeManager(Project project, TerminalPromptModel promptModel, TerminalOutputModel outputModel, TerminalAiPromptEventsReporter reporter, CoroutineScope coroutineScope, DefaultConstructorMarker $constructor_marker) {
        this(project, promptModel, outputModel, reporter, coroutineScope);
    }

    static {
        Key key = Key.create((String)"TerminalTextToCommandModeManager");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager$AiModeDisablingReason;", "", "<init>", "(Ljava/lang/String;I)V", "AI_ICON_CLICKED", "AI_CONTEXT_MENU_OPTION_CLICKED", "AI_SHORTCUT_PRESSED", "ESCAPE_PRESSED", "TEXT_PART_REMOVED", "intellij.ml.llm.terminal"})
    public static final class AiModeDisablingReason
    extends Enum<AiModeDisablingReason> {
        public static final /* enum */ AiModeDisablingReason AI_ICON_CLICKED = new AiModeDisablingReason();
        public static final /* enum */ AiModeDisablingReason AI_CONTEXT_MENU_OPTION_CLICKED = new AiModeDisablingReason();
        public static final /* enum */ AiModeDisablingReason AI_SHORTCUT_PRESSED = new AiModeDisablingReason();
        public static final /* enum */ AiModeDisablingReason ESCAPE_PRESSED = new AiModeDisablingReason();
        public static final /* enum */ AiModeDisablingReason TEXT_PART_REMOVED = new AiModeDisablingReason();
        private static final /* synthetic */ AiModeDisablingReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AiModeDisablingReason[] values() {
            return (AiModeDisablingReason[])$VALUES.clone();
        }

        public static AiModeDisablingReason valueOf(String value) {
            return Enum.valueOf(AiModeDisablingReason.class, value);
        }

        @NotNull
        public static EnumEntries<AiModeDisablingReason> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = aiModeDisablingReasonArray = new AiModeDisablingReason[]{AiModeDisablingReason.AI_ICON_CLICKED, AiModeDisablingReason.AI_CONTEXT_MENU_OPTION_CLICKED, AiModeDisablingReason.AI_SHORTCUT_PRESSED, AiModeDisablingReason.ESCAPE_PRESSED, AiModeDisablingReason.TEXT_PART_REMOVED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager$AiModeEnablingReason;", "", "<init>", "(Ljava/lang/String;I)V", "AI_ICON_CLICKED", "AI_CONTEXT_MENU_OPTION_CLICKED", "AI_SHORTCUT_PRESSED", "NL_DETECTED", "intellij.ml.llm.terminal"})
    public static final class AiModeEnablingReason
    extends Enum<AiModeEnablingReason> {
        public static final /* enum */ AiModeEnablingReason AI_ICON_CLICKED = new AiModeEnablingReason();
        public static final /* enum */ AiModeEnablingReason AI_CONTEXT_MENU_OPTION_CLICKED = new AiModeEnablingReason();
        public static final /* enum */ AiModeEnablingReason AI_SHORTCUT_PRESSED = new AiModeEnablingReason();
        public static final /* enum */ AiModeEnablingReason NL_DETECTED = new AiModeEnablingReason();
        private static final /* synthetic */ AiModeEnablingReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AiModeEnablingReason[] values() {
            return (AiModeEnablingReason[])$VALUES.clone();
        }

        public static AiModeEnablingReason valueOf(String value) {
            return Enum.valueOf(AiModeEnablingReason.class, value);
        }

        @NotNull
        public static EnumEntries<AiModeEnablingReason> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = aiModeEnablingReasonArray = new AiModeEnablingReason[]{AiModeEnablingReason.AI_ICON_CLICKED, AiModeEnablingReason.AI_CONTEXT_MENU_OPTION_CLICKED, AiModeEnablingReason.AI_SHORTCUT_PRESSED, AiModeEnablingReason.NL_DETECTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager$CommandExecutionListener;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptCustomEnterHandler;", "<init>", "()V", "handleEnter", "", "model", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "intellij.ml.llm.terminal"})
    private static final class CommandExecutionListener
    implements TerminalPromptCustomEnterHandler {
        public boolean handleEnter(@NotNull TerminalPromptModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            TerminalTextToCommandModeManager terminalTextToCommandModeManager = Companion.getTextToCommandModeManager((Editor)model.getEditor());
            if (terminalTextToCommandModeManager == null) {
                throw new IllegalStateException("No TextToCommandModeManager in the terminal prompt editor".toString());
            }
            TerminalTextToCommandModeManager manager = terminalTextToCommandModeManager;
            manager.stateChangeEventsFlow.tryEmit((Object)TerminalAiPromptStateChangeEvent.COMMAND_EXECUTED);
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R,\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u00072\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager$Companion;", "", "<init>", "()V", "value", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager;", "textToCommandModeManager", "Lcom/intellij/openapi/editor/Editor;", "getTextToCommandModeManager", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager;", "setTextToCommandModeManager", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeManager;)V", "KEY", "Lcom/intellij/openapi/util/Key;", "install", "project", "Lcom/intellij/openapi/project/Project;", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "reporter", "Lcom/intellij/ml/llm/terminal/TerminalAiPromptEventsReporter;", "intellij.ml.llm.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final TerminalTextToCommandModeManager getTextToCommandModeManager(@NotNull Editor $this$textToCommandModeManager) {
            Intrinsics.checkNotNullParameter((Object)$this$textToCommandModeManager, (String)"<this>");
            return (TerminalTextToCommandModeManager)$this$textToCommandModeManager.getUserData(KEY);
        }

        public final void setTextToCommandModeManager(@NotNull Editor $this$textToCommandModeManager, @Nullable TerminalTextToCommandModeManager value) {
            Intrinsics.checkNotNullParameter((Object)$this$textToCommandModeManager, (String)"<this>");
            $this$textToCommandModeManager.putUserData(KEY, (Object)value);
        }

        @NotNull
        public final TerminalTextToCommandModeManager install(@NotNull Project project, @NotNull TerminalPromptModel promptModel, @NotNull TerminalOutputModel outputModel, @NotNull TerminalAiPromptEventsReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            CoroutineScope coroutineScope = TerminalLLMScopeProvider.Companion.getInstance(project).getScope();
            String string = TerminalTextToCommandModeManager.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            CoroutineScope scope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)string, null, (boolean)false, (int)6, null);
            Disposer.register((Disposable)((Disposable)promptModel), () -> Companion.install$lambda$0(scope));
            TerminalTextToCommandModeManager manager = new TerminalTextToCommandModeManager(project, promptModel, outputModel, reporter, scope, null);
            this.setTextToCommandModeManager((Editor)promptModel.getEditor(), manager);
            return manager;
        }

        private static final void install$lambda$0(CoroutineScope $scope) {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$scope, null, (int)1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[TerminalAiPromptStateChangeEvent.values().length];
            try {
                nArray[TerminalAiPromptStateChangeEvent.NL_DETECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.AI_ICON_CLICKED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.AI_CONTEXT_MENU_OPTION_CLICKED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.AI_SHORTCUT_PRESSED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.COMMAND_HISTORY_SHOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.COMMAND_SEARCH_SHOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.COMMAND_EXECUTED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.ALL_TEXT_REMOVED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.COMMAND_HISTORY_ABORTED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.COMMAND_SEARCH_ABORTED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.ESCAPE_PRESSED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.AI_GENERATION_COMPLETED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalAiPromptStateChangeEvent.TEXT_PART_REMOVED.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TerminalTextToCommandModeState.values().length];
            try {
                nArray[TerminalTextToCommandModeState.SHELL_INPUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalTextToCommandModeState.SHELL_INPUT_WITHOUT_NL_DETECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalTextToCommandModeState.EXPLICIT_AI.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalTextToCommandModeState.IMPLICIT_AI.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[AiModeEnablingReason.values().length];
            try {
                nArray[AiModeEnablingReason.AI_ICON_CLICKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiModeEnablingReason.AI_CONTEXT_MENU_OPTION_CLICKED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiModeEnablingReason.AI_SHORTCUT_PRESSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiModeEnablingReason.NL_DETECTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[AiModeDisablingReason.values().length];
            try {
                nArray[AiModeDisablingReason.AI_ICON_CLICKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiModeDisablingReason.AI_CONTEXT_MENU_OPTION_CLICKED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiModeDisablingReason.AI_SHORTCUT_PRESSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiModeDisablingReason.ESCAPE_PRESSED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiModeDisablingReason.TEXT_PART_REMOVED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

