/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.lang.Language;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptByTextDetector;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/BeggingPromptInitiatingWords;", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptByTextDetector;", "<init>", "()V", "isPromptStartsWithInitiatingWord", "", "text", "", "isInlinePrompt", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptByTextDetector$Decision;", "editorLanguage", "Lcom/intellij/lang/Language;", "promptInitiatingWords", "", "intellij.ml.llm.inlinePromptDetector"})
@ApiStatus.Internal
public final class BeggingPromptInitiatingWords
implements InlinePromptByTextDetector {
    @NotNull
    public static final BeggingPromptInitiatingWords INSTANCE = new BeggingPromptInitiatingWords();
    @NotNull
    private static final Set<String> promptInitiatingWords;

    private BeggingPromptInitiatingWords() {
    }

    public final boolean isPromptStartsWithInitiatingWord(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List list = StringUtil.getWordsIn((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWordsIn(...)");
        String string = (String)CollectionsKt.firstOrNull((List)list);
        if (string == null) {
            return false;
        }
        String word = string;
        return promptInitiatingWords.contains(StringUtil.toLowerCase((String)word));
    }

    @Override
    @NotNull
    public InlinePromptByTextDetector.Decision isInlinePrompt(@NotNull String text, @NotNull Language editorLanguage) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)editorLanguage, (String)"editorLanguage");
        return this.isPromptStartsWithInitiatingWord(text) ? InlinePromptByTextDetector.Decision.PROMPT : InlinePromptByTextDetector.Decision.UNSURE;
    }

    static {
        Object[] objectArray = new String[]{"please", "pls"};
        promptInitiatingWords = SetsKt.hashSetOf((Object[])objectArray);
    }
}

