/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.lang.Language;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptByTextDetector;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptEventsLogger;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptFusCollector;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptHiddenByUserReason;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bJ\u0018\u0010\u0015\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptStatefulReporter;", "", "<init>", "()V", "detectionExecuted", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "detector", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptByTextDetector;", "isPrompt", "", "promptDetectedInitially", "editor", "Lcom/intellij/openapi/editor/Editor;", "naturalLanguageDetected", "userInput", "", "codeGenerationCalled", "Lcom/intellij/psi/PsiFile;", "diffShown", "inlinePromptHiddenByUser", "reason", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptHiddenByUserReason;", "LAST_DETECTED_NATURAL_LANGUAGE", "Lcom/intellij/openapi/util/Key;", "IS_PROMPT_DETECTOR", "IS_NOT_PROMPT_DETECTOR", "intellij.ml.llm.inlinePromptDetector"})
public final class InlinePromptStatefulReporter {
    @NotNull
    public static final InlinePromptStatefulReporter INSTANCE = new InlinePromptStatefulReporter();
    @NotNull
    private static final Key<String> LAST_DETECTED_NATURAL_LANGUAGE;
    @NotNull
    private static final Key<InlinePromptByTextDetector> IS_PROMPT_DETECTOR;
    @NotNull
    private static final Key<InlinePromptByTextDetector> IS_NOT_PROMPT_DETECTOR;

    private InlinePromptStatefulReporter() {
    }

    public final void detectionExecuted(@NotNull VirtualFile file, @Nullable InlinePromptByTextDetector detector, boolean isPrompt) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (isPrompt) {
            file.putUserData(IS_PROMPT_DETECTOR, (Object)detector);
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)file), IS_NOT_PROMPT_DETECTOR);
        } else {
            file.putUserData(IS_NOT_PROMPT_DETECTOR, (Object)detector);
        }
    }

    public final void promptDetectedInitially(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VirtualFile virtualFile = editor.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile file = virtualFile;
        FileType fileType = file.getFileType();
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        Language lang = languageFileType != null ? languageFileType.getLanguage() : null;
        InlinePromptByTextDetector isPromptDetector = (InlinePromptByTextDetector)file.getUserData(IS_PROMPT_DETECTOR);
        InlinePromptFusCollector.INSTANCE.logInitialDetection(lang, isPromptDetector);
    }

    public final void naturalLanguageDetected(@NotNull VirtualFile file, @NotNull String userInput) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)userInput, (String)"userInput");
        file.putUserData(LAST_DETECTED_NATURAL_LANGUAGE, (Object)userInput);
    }

    public final void codeGenerationCalled(@NotNull PsiFile file, boolean diffShown) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        InlinePromptByTextDetector isPromptDetector = (InlinePromptByTextDetector)file.getViewProvider().getVirtualFile().getUserData(IS_PROMPT_DETECTOR);
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        InlinePromptFusCollector.INSTANCE.logGenerationFromInlinePromptInvoked(language, diffShown, isPromptDetector);
    }

    public final void inlinePromptHiddenByUser(@Nullable VirtualFile file, @NotNull InlinePromptHiddenByUserReason reason) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            VirtualFile virtualFile = file;
            InlinePromptByTextDetector isPromptDetector = virtualFile != null ? (InlinePromptByTextDetector)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)virtualFile), IS_PROMPT_DETECTOR) : null;
            VirtualFile virtualFile2 = file;
            InlinePromptByTextDetector isNotPromptDetector = virtualFile2 != null ? (InlinePromptByTextDetector)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)virtualFile2), IS_NOT_PROMPT_DETECTOR) : null;
            VirtualFile virtualFile3 = file;
            FileType fileType = virtualFile3 != null ? virtualFile3.getFileType() : null;
            LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
            Language language = languageFileType != null ? languageFileType.getLanguage() : null;
            InlinePromptFusCollector.INSTANCE.logInlinePromptHiddenByUser(language, reason, isPromptDetector, isNotPromptDetector);
            Object object = file;
            if (object == null || (object = (String)object.getUserData(LAST_DETECTED_NATURAL_LANGUAGE)) == null) break block0;
            Object userInput = object;
            boolean bl = false;
            InlinePromptEventsLogger.INSTANCE.logFalsePositiveDetected((String)userInput, language, reason);
            file.putUserData(LAST_DETECTED_NATURAL_LANGUAGE, null);
        }
    }

    static {
        Key key = Key.create((String)"com.intellij.inlineAiPromptDetector.lastDetectedNaturalLanguage");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LAST_DETECTED_NATURAL_LANGUAGE = key;
        Key key2 = Key.create((String)"com.intellij.inlineAiPromptDetector.isPromptDetector");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        IS_PROMPT_DETECTOR = key2;
        Key key3 = Key.create((String)"com.intellij.inlineAiPromptDetector.isNotPromptDetector");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        IS_NOT_PROMPT_DETECTOR = key3;
    }
}

