/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chat.history.migration;

import com.intellij.ml.llm.aui.events.converters.A2uxEventConvertersKt;
import com.intellij.ml.llm.chat.history.migration.LegacyAgentState;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionAgentId;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionAgentStateChanged;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionAgentStatusChanged;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionEvent;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionFailureEvent;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionMessageBlockEvent;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionPlanUpdatedEvent;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionResponseReceived;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionRollbackEvents;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionUserPromptAttachment;
import com.intellij.ml.llm.chat.history.migration.LegacyChatSessionUserPromptEvent;
import com.intellij.ml.llm.chat.shared.AgentState;
import com.intellij.ml.llm.chat.shared.ChatSessionAgentId;
import com.intellij.ml.llm.chat.shared.ChatSessionAgentStateChanged;
import com.intellij.ml.llm.chat.shared.ChatSessionAgentStatusChanged;
import com.intellij.ml.llm.chat.shared.ChatSessionEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionEventId;
import com.intellij.ml.llm.chat.shared.ChatSessionFailureEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionMessageBlockEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionPlanUpdatedEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionResponseReceived;
import com.intellij.ml.llm.chat.shared.ChatSessionRollbackEvents;
import com.intellij.ml.llm.chat.shared.ChatSessionUserPromptAttachment;
import com.intellij.ml.llm.chat.shared.ChatSessionUserPromptEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.a2ux.api.AgentPlanUpdatedEvent;
import org.jetbrains.a2ux.api.MessageBlockUpdatedEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/chat/history/migration/LegacyHistoryConverter;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "json", "Lkotlinx/serialization/json/Json;", "convert", "", "eventsFile", "Ljava/nio/file/Path;", "convertEvents", "", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEvent;", "file", "parseLegacyEvent", "Lcom/intellij/ml/llm/chat/history/migration/LegacyChatSessionEvent;", "base64Line", "", "convertEvent", "legacy", "convertAgentState", "Lcom/intellij/ml/llm/chat/shared/AgentState;", "Lcom/intellij/ml/llm/chat/history/migration/LegacyAgentState;", "convertAttachment", "Lcom/intellij/ml/llm/chat/shared/ChatSessionUserPromptAttachment;", "Lcom/intellij/ml/llm/chat/history/migration/LegacyChatSessionUserPromptAttachment;", "writeConvertedFile", "", "events", "intellij.ml.llm.chat.history.migration"})
@SourceDebugExtension(value={"SMAP\nLegacyHistoryConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyHistoryConverter.kt\ncom/intellij/ml/llm/chat/history/migration/LegacyHistoryConverter\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n222#2:187\n205#2:193\n1563#3:188\n1634#3,3:189\n1#4:192\n*S KotlinDebug\n*F\n+ 1 LegacyHistoryConverter.kt\ncom/intellij/ml/llm/chat/history/migration/LegacyHistoryConverter\n*L\n89#1:187\n165#1:193\n115#1:188\n115#1:189,3\n*E\n"})
public final class LegacyHistoryConverter {
    @NotNull
    public static final LegacyHistoryConverter INSTANCE = new LegacyHistoryConverter();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Json json;

    private LegacyHistoryConverter() {
    }

    public final boolean convert(@NotNull Path eventsFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)eventsFile, (String)"eventsFile");
        if (!Files.exists(eventsFile, new LinkOption[0])) {
            return false;
        }
        try {
            List<ChatSessionEvent> convertedEvents = this.convertEvents(eventsFile);
            if (convertedEvents.isEmpty()) {
                logger.warn("No events converted from legacy file: " + eventsFile);
                return false;
            }
            this.writeConvertedFile(eventsFile, convertedEvents);
            bl = true;
        }
        catch (Exception e) {
            logger.error("Failed to convert legacy history file: " + eventsFile, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<ChatSessionEvent> convertEvents(Path file) {
        List result = new ArrayList();
        Closeable closeable = Files.newBufferedReader(file, StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            while (reader.readLine() != null) {
                ChatSessionEvent converted;
                LegacyChatSessionEvent event;
                String line;
                if (((CharSequence)line).length() == 0 || (event = INSTANCE.parseLegacyEvent(line)) == null || (converted = INSTANCE.convertEvent(event)) == null) continue;
                result.add(converted);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final LegacyChatSessionEvent parseLegacyEvent(String base64Line) {
        Object object;
        if (((CharSequence)base64Line).length() == 0) {
            return null;
        }
        try {
            byte[] byArray = Base64.getDecoder().decode(base64Line);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            object = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            object = new String((byte[])object, charset2);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Failed to decode base64 line", (Throwable)e);
            return null;
        }
        Object jsonStr = object;
        try {
            void this_$iv;
            object = json;
            Object string$iv = jsonStr;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            object = (LegacyChatSessionEvent)this_$iv.decodeFromString((DeserializationStrategy)LegacyChatSessionEvent.Companion.serializer(), (String)string$iv);
        }
        catch (Exception e) {
            logger.warn("Failed to parse legacy event JSON: " + (String)jsonStr, (Throwable)e);
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final ChatSessionEvent convertEvent(LegacyChatSessionEvent legacy) {
        ChatSessionEvent chatSessionEvent;
        LegacyChatSessionEvent legacyChatSessionEvent = legacy;
        if (legacyChatSessionEvent instanceof LegacyChatSessionAgentStatusChanged) {
            chatSessionEvent = (ChatSessionEvent)new ChatSessionAgentStatusChanged(((LegacyChatSessionAgentStatusChanged)legacy).getStatus());
        } else if (legacyChatSessionEvent instanceof LegacyChatSessionAgentStateChanged) {
            chatSessionEvent = (ChatSessionEvent)new ChatSessionAgentStateChanged(this.convertAgentState(((LegacyChatSessionAgentStateChanged)legacy).getState()));
        } else if (legacyChatSessionEvent instanceof LegacyChatSessionResponseReceived) {
            chatSessionEvent = (ChatSessionEvent)new ChatSessionResponseReceived();
        } else if (legacyChatSessionEvent instanceof LegacyChatSessionRollbackEvents) {
            chatSessionEvent = (ChatSessionEvent)new ChatSessionRollbackEvents(new ChatSessionEventId(((LegacyChatSessionRollbackEvents)legacy).getFrom().getId()), new ChatSessionEventId(((LegacyChatSessionRollbackEvents)legacy).getTo().getId()));
        } else if (legacyChatSessionEvent instanceof LegacyChatSessionUserPromptEvent) {
            Collection<ChatSessionUserPromptAttachment> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((LegacyChatSessionUserPromptEvent)legacy).getAttachments();
            String string = ((LegacyChatSessionUserPromptEvent)legacy).getPrompt();
            ChatSessionEventId chatSessionEventId = new ChatSessionEventId(((LegacyChatSessionUserPromptEvent)legacy).getId().getId());
            boolean $i$f$map = false;
            void var5_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LegacyChatSessionUserPromptAttachment legacyChatSessionUserPromptAttachment = (LegacyChatSessionUserPromptAttachment)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(INSTANCE.convertAttachment((LegacyChatSessionUserPromptAttachment)it));
            }
            collection = (List)destination$iv$iv;
            ChatSessionAgentId chatSessionAgentId = new ChatSessionAgentId(((LegacyChatSessionUserPromptEvent)legacy).getAgentId().getId());
            List list = collection;
            String string2 = string;
            ChatSessionEventId chatSessionEventId2 = chatSessionEventId;
            chatSessionEvent = (ChatSessionEvent)new ChatSessionUserPromptEvent(chatSessionEventId2, string2, list, chatSessionAgentId);
        } else if (legacyChatSessionEvent instanceof LegacyChatSessionMessageBlockEvent) {
            chatSessionEvent = (ChatSessionEvent)new ChatSessionMessageBlockEvent(new ChatSessionEventId(((LegacyChatSessionMessageBlockEvent)legacy).getId().getId()), new ChatSessionAgentId(((LegacyChatSessionMessageBlockEvent)legacy).getAgentId().getId()), A2uxEventConvertersKt.toAui((MessageBlockUpdatedEvent)((LegacyChatSessionMessageBlockEvent)legacy).getEvent()));
        } else if (legacyChatSessionEvent instanceof LegacyChatSessionFailureEvent) {
            chatSessionEvent = (ChatSessionEvent)new ChatSessionFailureEvent(new ChatSessionEventId(((LegacyChatSessionFailureEvent)legacy).getId().getId()), ((LegacyChatSessionFailureEvent)legacy).getMessage());
        } else if (legacyChatSessionEvent instanceof LegacyChatSessionPlanUpdatedEvent) {
            ChatSessionAgentId chatSessionAgentId;
            com.intellij.ml.llm.aui.events.api.AgentPlanUpdatedEvent agentPlanUpdatedEvent = A2uxEventConvertersKt.toAui((AgentPlanUpdatedEvent)((LegacyChatSessionPlanUpdatedEvent)legacy).getEvent());
            LegacyChatSessionAgentId legacyChatSessionAgentId = ((LegacyChatSessionPlanUpdatedEvent)legacy).getAgentId();
            if (legacyChatSessionAgentId != null) {
                void it;
                LegacyChatSessionAgentId $this$mapTo$iv$iv = legacyChatSessionAgentId;
                com.intellij.ml.llm.aui.events.api.AgentPlanUpdatedEvent agentPlanUpdatedEvent2 = agentPlanUpdatedEvent;
                boolean bl = false;
                chatSessionAgentId = new ChatSessionAgentId(it.getId());
                agentPlanUpdatedEvent = agentPlanUpdatedEvent2;
            } else {
                chatSessionAgentId = null;
            }
            ChatSessionAgentId chatSessionAgentId2 = chatSessionAgentId;
            com.intellij.ml.llm.aui.events.api.AgentPlanUpdatedEvent agentPlanUpdatedEvent3 = agentPlanUpdatedEvent;
            chatSessionEvent = (ChatSessionEvent)new ChatSessionPlanUpdatedEvent(agentPlanUpdatedEvent3, chatSessionAgentId2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return chatSessionEvent;
    }

    private final AgentState convertAgentState(LegacyAgentState legacy) {
        return switch (WhenMappings.$EnumSwitchMapping$0[legacy.ordinal()]) {
            case 1 -> AgentState.Idle;
            case 2 -> AgentState.Thinking;
            case 3 -> AgentState.Initializing;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ChatSessionUserPromptAttachment convertAttachment(LegacyChatSessionUserPromptAttachment legacy) {
        return new ChatSessionUserPromptAttachment(legacy.getName(), legacy.getIcon(), legacy.getHint(), legacy.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeConvertedFile(Path file, List<? extends ChatSessionEvent> events) {
        Path tempFile = Files.createTempFile(file.getParent(), "migration", ".tmp", new FileAttribute[0]);
        try {
            Object object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            object = Files.newBufferedWriter(tempFile, StandardCharsets.UTF_8, object);
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl = false;
                writer.write("AUI_EVENTS_V1");
                writer.newLine();
                for (ChatSessionEvent chatSessionEvent : events) {
                    void this_$iv;
                    Json json = LegacyHistoryConverter.json;
                    ChatSessionEvent value$iv = chatSessionEvent;
                    boolean $i$f$encodeToString = false;
                    this_$iv.getSerializersModule();
                    String jsonStr = this_$iv.encodeToString((SerializationStrategy)ChatSessionEvent.Companion.serializer(), (Object)value$iv);
                    Base64.Encoder encoder = Base64.getEncoder();
                    String string = jsonStr;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    String base64 = encoder.encodeToString(byArray);
                    writer.write(base64);
                    writer.newLine();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
            Files.move(tempFile, file, (CopyOption[])object);
        }
        catch (Exception e) {
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(true);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(LegacyHistoryConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LegacyHistoryConverter.logger = logger;
        json = JsonKt.Json$default(null, LegacyHistoryConverter::json$lambda$0, (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LegacyAgentState.values().length];
            try {
                nArray[LegacyAgentState.Idle.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegacyAgentState.Thinking.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegacyAgentState.Initializing.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

