/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro.cloud;

import ai.grazie.api.gateway.client.SuspendableAPIGatewayClient;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.cloud.GrazieCloudConnector;
import com.intellij.ml.grazie.pro.cloud.GrazieProCloudConfig;
import com.intellij.ml.grazie.pro.license.LoginManager;
import com.intellij.ml.grazie.pro.license.LoginState;
import com.intellij.ml.llm.core.providers.LlmGrazieProLocalModeSetting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/grazie/pro/cloud/GrazieProCloudConnector;", "Lcom/intellij/grazie/cloud/GrazieCloudConnector;", "<init>", "()V", "isAuthorized", "", "connect", "project", "Lcom/intellij/openapi/project/Project;", "isCloudEnabledByDefault", "askUserConsentForCloud", "api", "Lai/grazie/api/gateway/client/SuspendableAPIGatewayClient;", "subscribeToAuthorizationStateEvents", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function0;", "processing", "Lcom/intellij/grazie/GrazieConfig$State$Processing;", "getProcessing", "()Lcom/intellij/grazie/GrazieConfig$State$Processing;", "intellij.ml.grazie.pro"})
public final class GrazieProCloudConnector
implements GrazieCloudConnector {
    public boolean isAuthorized() {
        return this.getProcessing() == GrazieConfig.State.Processing.Cloud && ((LoginState)LoginManager.Companion.state().getValue()).isCloudConnected();
    }

    public boolean connect(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    public boolean isCloudEnabledByDefault() {
        return this.getProcessing() == GrazieConfig.State.Processing.Cloud;
    }

    public boolean askUserConsentForCloud() {
        return true;
    }

    @Nullable
    public SuspendableAPIGatewayClient api() {
        return GrazieProCloudConfig.INSTANCE.api();
    }

    public void subscribeToAuthorizationStateEvents(@NotNull Disposable disposable, @NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        LoginManager.Companion.subscribe(disposable, listener);
    }

    private final GrazieConfig.State.Processing getProcessing() {
        return LlmGrazieProLocalModeSetting.INSTANCE.isLocalMode() ? GrazieConfig.State.Processing.Local : GrazieConfig.State.Processing.Cloud;
    }
}

