/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.gemini;

import com.intellij.openapi.util.registry.Registry;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u0003J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/agents/gemini/GeminiAgentConfiguration;", "", "projectPath", "", "<init>", "(Ljava/lang/String;)V", "getWorkingProjectPath", "Ljava/nio/file/Path;", "getDownloadableUrl", "getPathForDownload", "getLogsPath", "getGeminiApiKey", "startServerCommand", "getNodeVersionCommand", "getServerUrl", "getSaveReplayPath", "getLoadingReplayPath", "intellij.ml.llm.agents.gemini"})
@SourceDebugExtension(value={"SMAP\nGeminiAgentConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiAgentConfiguration.kt\ncom/intellij/ml/llm/agents/gemini/GeminiAgentConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,33:1\n1#2:34\n*E\n"})
public final class GeminiAgentConfiguration {
    @NotNull
    private final String projectPath;

    public GeminiAgentConfiguration(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.projectPath = projectPath;
    }

    @NotNull
    public final Path getWorkingProjectPath() {
        Path path = Path.of(this.projectPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    @NotNull
    public final String getDownloadableUrl() {
        return "https://drive.google.com/uc?export=download&id=1_Q5jLqUgfz0zV2aNiXwLvdF5GNCH7zHY";
    }

    @NotNull
    public final Path getPathForDownload() {
        String[] stringArray = new String[]{".gemini", "jetbrains", "v0", "downloads", "a2a-server.mjs"};
        Path path = Paths.get(System.getProperty("user.home"), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path getLogsPath() {
        String[] stringArray = new String[]{".gemini", "jetbrains", "v0", "logs"};
        Path path = Paths.get(System.getProperty("user.home"), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final String getGeminiApiKey() {
        return Registry.Companion.stringValue("llm.chat.agent.gemini.apiKey");
    }

    @NotNull
    public final String startServerCommand() {
        return Registry.Companion.stringValue("llm.chat.agent.gemini.startServerCommand");
    }

    @NotNull
    public final String getNodeVersionCommand() {
        return Registry.Companion.stringValue("llm.chat.agent.gemini.nodeVersionCommand");
    }

    @NotNull
    public final String getServerUrl() {
        return Registry.Companion.stringValue("llm.chat.agent.gemini.serverURL");
    }

    @Nullable
    public final String getSaveReplayPath() {
        String string;
        String it = string = Registry.Companion.stringValue("llm.chat.agent.gemini.a2a.saveReplayFile");
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? string : null;
    }

    @Nullable
    public final String getLoadingReplayPath() {
        String string;
        String it = string = Registry.Companion.stringValue("llm.chat.agent.gemini.a2a.loadReplayFile");
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? string : null;
    }
}

