/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.gemini.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.intellij.ml.llm.agents.gemini.a2aclient.A2AUtilsKt;
import com.intellij.ml.llm.agents.gemini.types.CoderAgentEvent;
import com.intellij.ml.llm.agents.gemini.types.CoderAgentEventKind;
import com.intellij.ml.llm.agents.gemini.types.GeminiEvent;
import com.intellij.ml.llm.agents.gemini.types.ParsingErrorStatus;
import io.a2a.spec.DataPart;
import io.a2a.spec.Part;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.spec.TextPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\t\u001a\u00020\nJ$\u0010\u000b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\u0006\b\u0000\u0010\u001c\u0018\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0082\b\u00a2\u0006\u0002\u0010\u001dR*\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014*\u0006\u0012\u0002\b\u00030\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0015*\u0006\u0012\u0002\b\u00030\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/agents/gemini/types/GeminiEventsSerializer;", "", "<init>", "()V", "parse", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/agents/gemini/types/ParsingErrorStatus;", "", "Lcom/intellij/ml/llm/agents/gemini/types/GeminiEvent;", "event", "Lio/a2a/spec/TaskStatusUpdateEvent;", "parseImpl", "parseCoderAgentEvent", "Lcom/intellij/ml/llm/agents/gemini/types/CoderAgentEvent;", "parseMessagePart", "part", "Lio/a2a/spec/Part;", "type", "Lcom/intellij/ml/llm/agents/gemini/types/CoderAgentEventKind;", "data", "", "", "getData", "(Lio/a2a/spec/Part;)Ljava/util/Map;", "text", "getText", "(Lio/a2a/spec/Part;)Ljava/lang/String;", "parseData", "T", "(Ljava/lang/Object;)Ljava/lang/Object;", "intellij.ml.llm.agents.gemini"})
@SourceDebugExtension(value={"SMAP\nGeminiEventsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiEventsSerializer.kt\ncom/intellij/ml/llm/agents/gemini/types/GeminiEventsSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n64#1,2:73\n64#1,2:75\n1563#2:69\n1634#2,3:70\n*S KotlinDebug\n*F\n+ 1 GeminiEventsSerializer.kt\ncom/intellij/ml/llm/agents/gemini/types/GeminiEventsSerializer\n*L\n49#1:73,2\n53#1:75,2\n29#1:69\n29#1:70,3\n*E\n"})
public final class GeminiEventsSerializer {
    @NotNull
    public static final GeminiEventsSerializer INSTANCE = new GeminiEventsSerializer();

    private GeminiEventsSerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<ParsingErrorStatus, List<GeminiEvent>> parse(@NotNull TaskStatusUpdateEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Pair<ParsingErrorStatus, List<GeminiEvent>> pair = this.parseImpl(event2);
            return pair;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ParsingErrorStatus, List<GeminiEvent>> parseImpl(TaskStatusUpdateEvent event2) {
        void $this$mapTo$iv$iv;
        List list;
        Object object = this.parseCoderAgentEvent(event2);
        if (object == null || (object = object.getKind()) == null) {
            throw new IllegalStateException("Unknown event type".toString());
        }
        Object eventKind = object;
        TaskStatus taskStatus = event2.getStatus();
        if ((taskStatus != null && (taskStatus = taskStatus.message()) != null ? taskStatus.getParts() : (list = null)) == null) {
            list = CollectionsKt.emptyList();
        }
        List messageParts = list;
        Iterable $this$map$iv = messageParts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GeminiEvent geminiEvent;
            void part;
            Part part2 = (Part)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)part);
                Intrinsics.checkNotNull((Object)INSTANCE.parseMessagePart((Part<?>)part, (CoderAgentEventKind)((Object)eventKind)));
            }
            catch (IllegalArgumentException e) {
                String sourceJson = A2AUtilsKt.getJacksonMapper().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)part);
                String details = ExceptionsKt.stackTraceToString((Throwable)e);
                Intrinsics.checkNotNull((Object)sourceJson);
                return new Pair((Object)new ParsingErrorStatus(sourceJson, details), (Object)CollectionsKt.emptyList());
            }
            collection.add(geminiEvent);
        }
        List events = (List)destination$iv$iv;
        return new Pair(null, (Object)events);
    }

    private final CoderAgentEvent parseCoderAgentEvent(TaskStatusUpdateEvent event2) {
        Object coderAgentEvent = event2.getMetadata().get("coderAgent");
        return (CoderAgentEvent)A2AUtilsKt.getJacksonMapper().convertValue(coderAgentEvent, CoderAgentEvent.class);
    }

    private final GeminiEvent parseMessagePart(Part<?> part, CoderAgentEventKind type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> throw new NotImplementedError(null, 1, null);
            case 2 -> {
                GeminiEventsSerializer var3_3 = this;
                Map<String, Object> data$iv = this.getData(part);
                boolean $i$f$parseData = false;
                yield (GeminiEvent)(data$iv == null ? null : A2AUtilsKt.getJacksonMapper().convertValue(data$iv, GeminiEvent.ToolCallUpdateEvent.class));
            }
            case 3 -> {
                String v1 = this.getText(part);
                if (v1 == null) {
                    v1 = "";
                }
                yield new GeminiEvent.TextContentEvent(v1);
            }
            case 4 -> {
                String v2 = this.getText(part);
                if (v2 == null) {
                    v2 = "";
                }
                yield new GeminiEvent.StateChangeEvent(v2);
            }
            case 5 -> throw new NotImplementedError(null, 1, null);
            case 6 -> {
                GeminiEventsSerializer this_$iv = this;
                Map<String, Object> data$iv = this.getData(part);
                boolean $i$f$parseData = false;
                yield (GeminiEvent)(data$iv == null ? null : A2AUtilsKt.getJacksonMapper().convertValue(data$iv, GeminiEvent.ThoughtEvent.class));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Map<String, Object> getData(Part<?> $this$data) {
        DataPart dataPart = $this$data instanceof DataPart ? (DataPart)$this$data : null;
        return dataPart != null ? dataPart.getData() : null;
    }

    private final String getText(Part<?> $this$text) {
        TextPart textPart = $this$text instanceof TextPart ? (TextPart)$this$text : null;
        return textPart != null ? textPart.getText() : null;
    }

    private final /* synthetic */ <T> T parseData(Object data) {
        boolean $i$f$parseData = false;
        if (data == null) {
            return null;
        }
        ObjectMapper objectMapper = A2AUtilsKt.getJacksonMapper();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)objectMapper.convertValue(data, Object.class);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CoderAgentEventKind.values().length];
            try {
                nArray[CoderAgentEventKind.ToolCallConfirmationEvent.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoderAgentEventKind.ToolCallUpdateEvent.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoderAgentEventKind.TextContentEvent.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoderAgentEventKind.StateChangeEvent.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoderAgentEventKind.StateAgentSettingsEvent.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoderAgentEventKind.ThoughtEvent.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

