/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.trustedStringBuilders;

import com.intellij.DynamicBundle;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.BooleanToStringBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.CodeExtractor;
import com.intellij.ml.llm.privacy.trustedStringBuilders.DoubleToStringBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.IndentBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.IntToStringBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.MessageFromDynamicBundleBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.RangeSubstringBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.RemoveHtmlTagsBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.WrapIntoMarkdownBuilder;
import com.intellij.openapi.util.TextRange;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0006\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001\u001a!\u0010\r\u001a\u00020\u0001\"\b\b\u0000\u0010\u000e*\u00020\u000f*\u0002H\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012\u001a5\u0010\r\u001a\u00020\u0001\"\b\b\u0000\u0010\u000e*\u00020\u000f*\u0002H\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0014\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0015\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\u0017"}, d2={"wrapCodeIntoMarkdownSnippet", "Lcom/intellij/ml/llm/privacy/PSString;", "langSafe", "codeSafe", "removeHtmlTags", "toPSString", "", "", "", "indent", "Lcom/intellij/openapi/util/TextRange;", "text", "substring", "getMessagePrivacySafe", "T", "Lcom/intellij/DynamicBundle;", "key", "", "(Lcom/intellij/DynamicBundle;Ljava/lang/String;)Lcom/intellij/ml/llm/privacy/PSString;", "params", "", "(Lcom/intellij/DynamicBundle;Ljava/lang/String;[Lcom/intellij/ml/llm/privacy/PSString;)Lcom/intellij/ml/llm/privacy/PSString;", "extractCode", "intellij.ml.llm.privacy.shared"})
public final class PSStringOperatorsKt {
    @NotNull
    public static final PSString wrapCodeIntoMarkdownSnippet(@NotNull PSString langSafe, @NotNull PSString codeSafe) {
        Intrinsics.checkNotNullParameter((Object)langSafe, (String)"langSafe");
        Intrinsics.checkNotNullParameter((Object)codeSafe, (String)"codeSafe");
        return new WrapIntoMarkdownBuilder(langSafe, codeSafe).toPSString();
    }

    @NotNull
    public static final PSString removeHtmlTags(@NotNull PSString $this$removeHtmlTags) {
        Intrinsics.checkNotNullParameter((Object)$this$removeHtmlTags, (String)"<this>");
        return new RemoveHtmlTagsBuilder($this$removeHtmlTags).toPSString();
    }

    @NotNull
    public static final PSString toPSString(boolean $this$toPSString) {
        return new BooleanToStringBuilder($this$toPSString).toPSString();
    }

    @NotNull
    public static final PSString toPSString(int $this$toPSString) {
        return new IntToStringBuilder($this$toPSString).toPSString();
    }

    @NotNull
    public static final PSString toPSString(double $this$toPSString) {
        return new DoubleToStringBuilder($this$toPSString).toPSString();
    }

    @NotNull
    public static final PSString indent(@NotNull TextRange $this$indent, @NotNull PSString text) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new IndentBuilder($this$indent, text).toPSString();
    }

    @NotNull
    public static final PSString substring(@NotNull TextRange $this$substring, @NotNull PSString text) {
        Intrinsics.checkNotNullParameter((Object)$this$substring, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new RangeSubstringBuilder($this$substring, text).toPSString();
    }

    @NotNull
    public static final <T extends DynamicBundle> PSString getMessagePrivacySafe(@NotNull T $this$getMessagePrivacySafe, @NotNull String key) {
        Intrinsics.checkNotNullParameter($this$getMessagePrivacySafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new MessageFromDynamicBundleBuilder<T>($this$getMessagePrivacySafe, key, new PSString[0]).toPSString();
    }

    @NotNull
    public static final <T extends DynamicBundle> PSString getMessagePrivacySafe(@NotNull T $this$getMessagePrivacySafe, @NotNull String key, PSString ... params) {
        Intrinsics.checkNotNullParameter($this$getMessagePrivacySafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return new MessageFromDynamicBundleBuilder<T>($this$getMessagePrivacySafe, key, Arrays.copyOf(params, params.length)).toPSString();
    }

    @NotNull
    public static final PSString extractCode(@NotNull PSString $this$extractCode) {
        Intrinsics.checkNotNullParameter((Object)$this$extractCode, (String)"<this>");
        return new CodeExtractor($this$extractCode).toPSString();
    }
}

