/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.a2ux.extensions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.a2a.spec.AgentCapabilities;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentExtension;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.Part;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskState;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.spec.TextPart;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.a2ux.api.AgentEvent;
import org.jetbrains.a2ux.api.AgentMetadata;
import org.jetbrains.a2ux.api.AskInputResponse;
import org.jetbrains.a2ux.api.InputResponse;
import org.jetbrains.a2ux.api.MarkdownBlockUpdatedEvent;
import org.jetbrains.a2ux.api.TaskRequest;
import org.jetbrains.a2ux.extensions.A2uxBridgeKt;
import org.jetbrains.a2ux.extensions.A2uxEvent;
import org.jetbrains.a2ux.extensions.A2uxTaskRequest;
import org.jetbrains.a2ux.extensions.A2uxTaskState;
import org.jetbrains.a2ux.extensions.JacksonMapperKt;
import org.jetbrains.a2ux.extensions.TaskRequestId;
import org.jetbrains.a2ux.impl.AgentEventToMarkdownKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ.\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$2\u0006\u0010\u001c\u001a\u00020\u001dJ6\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u0005J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020/0$2\u0006\u0010)\u001a\u00020&J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0017J\f\u00103\u001a\u000204*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/a2ux/extensions/A2uxBridge;", "", "<init>", "()V", "METADATA_TASK_NAME", "", "METADATA_RESPONSE_NAME", "METADATA_EVENT_NAME", "METADATA_AGENT_METADATA", "a2uxExtensionSchemaUri", "agentMetadataFromCard", "Lorg/jetbrains/a2ux/api/AgentMetadata;", "card", "Lio/a2a/spec/AgentCard;", "agentCardFromMetadata", "name", "description", "agentVersion", "agentUrl", "agentMetadata", "sendTaskRequest", "Lio/a2a/spec/SendStreamingMessageRequest;", "taskId", "Lorg/jetbrains/a2ux/extensions/TaskRequestId;", "task", "Lorg/jetbrains/a2ux/api/TaskRequest;", "receiveTaskRequest", "Lorg/jetbrains/a2ux/extensions/A2uxTaskRequest;", "message", "Lio/a2a/spec/MessageSendParams;", "sendInputResponse", "Lio/a2a/spec/SendMessageRequest;", "requestId", "userResponse", "Lorg/jetbrains/a2ux/api/InputResponse;", "receiveInputResponseEvent", "", "sendA2uxEvent", "Lio/a2a/spec/TaskStatusUpdateEvent;", "state", "Lorg/jetbrains/a2ux/extensions/A2uxTaskState;", "event", "Lorg/jetbrains/a2ux/api/AgentEvent;", "timestamp", "Ljava/time/OffsetDateTime;", "messageId", "receiveA2uxEvents", "Lorg/jetbrains/a2ux/extensions/A2uxEvent;", "cancelTaskRequest", "Lio/a2a/spec/CancelTaskRequest;", "taskRequestId", "toProgressEvent", "Lorg/jetbrains/a2ux/api/MarkdownBlockUpdatedEvent;", "a2ux-core"})
@SourceDebugExtension(value={"SMAP\nA2uxBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 A2uxBridge.kt\norg/jetbrains/a2ux/extensions/A2uxBridge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n1617#2,9:287\n1869#2:296\n1870#2:300\n1626#2:301\n808#2,11:302\n1617#2,9:315\n1869#2:324\n1870#2:328\n1626#2:329\n808#2,11:330\n1563#2:341\n1634#2,2:342\n1636#2:346\n56#3:297\n49#3:298\n56#3:313\n49#3:314\n56#3:325\n49#3:326\n56#3:344\n49#3:345\n1#4:299\n1#4:327\n*S KotlinDebug\n*F\n+ 1 A2uxBridge.kt\norg/jetbrains/a2ux/extensions/A2uxBridge\n*L\n27#1:287,9\n27#1:296\n27#1:300\n27#1:301\n119#1:302,11\n177#1:315,9\n177#1:324\n177#1:328\n177#1:329\n232#1:330,11\n232#1:341\n232#1:342,2\n232#1:346\n32#1:297\n32#1:298\n127#1:313\n127#1:314\n180#1:325\n180#1:326\n236#1:344\n236#1:345\n27#1:299\n177#1:327\n*E\n"})
public final class A2uxBridge {
    @NotNull
    public static final A2uxBridge INSTANCE = new A2uxBridge();
    @NotNull
    public static final String METADATA_TASK_NAME = "a2ux-task";
    @NotNull
    public static final String METADATA_RESPONSE_NAME = "a2ux-response";
    @NotNull
    public static final String METADATA_EVENT_NAME = "a2ux-event";
    @NotNull
    public static final String METADATA_AGENT_METADATA = "a2ux-metadata";
    @NotNull
    public static final String a2uxExtensionSchemaUri = "http://junie.jetbrains.com";

    private A2uxBridge() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AgentMetadata agentMetadataFromCard(@NotNull AgentCard card) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        List<AgentExtension> list = card.capabilities().extensions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"extensions(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ObjectMapper objectMapper;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            AgentExtension extension = (AgentExtension)element$iv$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)extension.uri(), (Object)a2uxExtensionSchemaUri)) {
                Object param = extension.params().get(METADATA_AGENT_METADATA);
                if (param != null) {
                    Object object;
                    try {
                        String content$iv;
                        void $this$readValue$iv;
                        object = JacksonMapperKt.getJacksonMapper();
                        Intrinsics.checkNotNullExpressionValue((Object)JacksonMapperKt.getJacksonMapper().writeValueAsString(param), (String)"writeValueAsString(...)");
                        boolean $i$f$readValue = false;
                        boolean $i$f$jacksonTypeRef = false;
                        object = (AgentMetadata)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<AgentMetadata>(){});
                    }
                    catch (Exception exception) {
                        object = null;
                    }
                    objectMapper = object;
                } else {
                    objectMapper = null;
                }
            } else {
                objectMapper = null;
            }
            if (objectMapper == null) continue;
            ObjectMapper it$iv$iv = objectMapper;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (AgentMetadata)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    @NotNull
    public final AgentCard agentCardFromMetadata(@NotNull String name, @NotNull String description, @NotNull String agentVersion, @NotNull String agentUrl, @NotNull AgentMetadata agentMetadata) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)agentVersion, (String)"agentVersion");
        Intrinsics.checkNotNullParameter((Object)agentUrl, (String)"agentUrl");
        Intrinsics.checkNotNullParameter((Object)agentMetadata, (String)"agentMetadata");
        Object[] objectArray = new String[]{"application/json", "text/event-stream"};
        AgentCard agentCard2 = new AgentCard.Builder().name(name).description(description).capabilities(new AgentCapabilities(true, false, false, CollectionsKt.listOf((Object)new AgentExtension.Builder().uri(a2uxExtensionSchemaUri).required(false).description("A2UX Specific capabilities").params(MapsKt.mapOf((Pair)TuplesKt.to((Object)METADATA_AGENT_METADATA, (Object)JacksonMapperKt.getJacksonMapper().readValue(JacksonMapperKt.getJacksonMapper().writeValueAsString((Object)agentMetadata), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){})))).build()))).defaultInputModes(CollectionsKt.listOf((Object)"application/json")).defaultOutputModes(CollectionsKt.listOf((Object[])objectArray)).skills(CollectionsKt.emptyList()).version(agentVersion).url(agentUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)agentCard2, (String)"build(...)");
        return agentCard2;
    }

    @NotNull
    public final SendStreamingMessageRequest sendTaskRequest(@NotNull TaskRequestId taskId, @NotNull TaskRequest task) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        SendStreamingMessageRequest sendStreamingMessageRequest = new SendStreamingMessageRequest.Builder().id(taskId.getId()).params(new MessageSendParams.Builder().message(new Message.Builder().role(Message.Role.USER).taskId(taskId.getId()).parts(CollectionsKt.listOf((Object)new TextPart(task.getRequest(), MapsKt.mapOf((Pair)TuplesKt.to((Object)METADATA_TASK_NAME, (Object)JacksonMapperKt.getJacksonMapper().readValue(JacksonMapperKt.getJacksonMapper().writeValueAsString((Object)task), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){})))))).build()).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)sendStreamingMessageRequest, (String)"build(...)");
        return sendStreamingMessageRequest;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final A2uxTaskRequest receiveTaskRequest(@NotNull MessageSendParams message) {
        ObjectMapper $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List<Part<?>> list = message.message().getParts();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParts(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextPart)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        TextPart textPart = (TextPart)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (textPart != null) {
            String string = message.message().getTaskId();
            if (string == null) {
                String string2 = UUID.randomUUID().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            TaskRequestId taskIdRequestId = new TaskRequestId(string);
            Object eventJson = textPart.getMetadata().get(METADATA_TASK_NAME);
            if (eventJson != null) {
                try {
                    void content$iv;
                    void $this$readValue$iv;
                    $this$filterIsInstanceTo$iv$iv = JacksonMapperKt.getJacksonMapper();
                    String string3 = JacksonMapperKt.getJacksonMapper().writeValueAsString(eventJson);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"writeValueAsString(...)");
                    destination$iv$iv = string3;
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    return new A2uxTaskRequest(taskIdRequestId, (TaskRequest)$this$readValue$iv.readValue((String)content$iv, (TypeReference)new TypeReference<TaskRequest>(){}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string4 = textPart.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            return new A2uxTaskRequest(taskIdRequestId, new TaskRequest(string4, null));
        }
        return null;
    }

    @NotNull
    public final SendMessageRequest sendInputResponse(@NotNull TaskRequestId requestId, @NotNull InputResponse userResponse) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)userResponse, (String)"userResponse");
        SendMessageRequest sendMessageRequest = new SendMessageRequest.Builder().jsonrpc("2.0").method("message/send").id(requestId.getId()).params(new MessageSendParams.Builder().message(new Message.Builder().role(Message.Role.USER).taskId(requestId.getId()).parts(CollectionsKt.listOf((Object)new TextPart(AgentEventToMarkdownKt.toMarkdown(userResponse), MapsKt.mapOf((Pair)TuplesKt.to((Object)METADATA_RESPONSE_NAME, (Object)JacksonMapperKt.getJacksonMapper().readValue(JacksonMapperKt.getJacksonMapper().writeValueAsString((Object)userResponse), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){})))))).build()).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)sendMessageRequest, (String)"build(...)");
        return sendMessageRequest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<InputResponse> receiveInputResponseEvent(@NotNull MessageSendParams message) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List<Part<?>> list = message.message().getParts();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParts(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            block5: {
                block3: {
                    Part it;
                    block4: {
                        String content$iv;
                        void $this$readValue$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        it = (Part)element$iv$iv;
                        boolean bl2 = false;
                        if (!(it instanceof TextPart)) break block3;
                        object = ((TextPart)it).getMetadata().get(METADATA_RESPONSE_NAME);
                        if (object == null) break block4;
                        Object event = object;
                        boolean bl3 = false;
                        ObjectMapper objectMapper = JacksonMapperKt.getJacksonMapper();
                        Intrinsics.checkNotNullExpressionValue((Object)JacksonMapperKt.getJacksonMapper().writeValueAsString(event), (String)"writeValueAsString(...)");
                        boolean $i$f$readValue = false;
                        boolean $i$f$jacksonTypeRef = false;
                        InputResponse inputResponse = (InputResponse)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<InputResponse>(){});
                        object = inputResponse;
                        if (inputResponse != null) break block5;
                    }
                    String string = UUID.randomUUID().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    object = new AskInputResponse(string, false, ((TextPart)it).getText());
                    break block5;
                }
                object = null;
            }
            if (object == null) continue;
            Object it$iv$iv = object;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final TaskStatusUpdateEvent sendA2uxEvent(@NotNull TaskRequestId taskId, @NotNull A2uxTaskState state, @NotNull AgentEvent event, @Nullable OffsetDateTime timestamp, @Nullable String messageId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TaskStatusUpdateEvent.Builder builder = new TaskStatusUpdateEvent.Builder().taskId(taskId.getId()).contextId("project");
        TaskState taskState = A2uxBridgeKt.access$mapTaskState(state);
        Message.Builder builder2 = new Message.Builder().role(Message.Role.AGENT).taskId(taskId.getId()).messageId(messageId);
        String string = AgentEventToMarkdownKt.toMarkdown(event);
        if (string == null) {
            string = "";
        }
        TaskStatusUpdateEvent taskStatusUpdateEvent = builder.status(new TaskStatus(taskState, builder2.parts(CollectionsKt.listOf((Object)new TextPart(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)METADATA_EVENT_NAME, (Object)JacksonMapperKt.getJacksonMapper().readValue(JacksonMapperKt.getJacksonMapper().writeValueAsString((Object)event), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){})))))).build(), timestamp)).build();
        Intrinsics.checkNotNullExpressionValue((Object)taskStatusUpdateEvent, (String)"build(...)");
        return taskStatusUpdateEvent;
    }

    public static /* synthetic */ TaskStatusUpdateEvent sendA2uxEvent$default(A2uxBridge a2uxBridge, TaskRequestId taskRequestId, A2uxTaskState a2uxTaskState, AgentEvent agentEvent, OffsetDateTime offsetDateTime, String string, int n, Object object) {
        if ((n & 8) != 0) {
            offsetDateTime = null;
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        return a2uxBridge.sendA2uxEvent(taskRequestId, a2uxTaskState, agentEvent, offsetDateTime, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<A2uxEvent> receiveA2uxEvents(@NotNull TaskStatusUpdateEvent event) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List<Part<?>> list = event.getStatus().message().getParts();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParts(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextPart)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AgentEvent agentEvent;
            void part;
            TextPart textPart = (TextPart)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object eventJson = part.getMetadata().get(METADATA_EVENT_NAME);
            if (eventJson != null) {
                AgentEvent $this$readValue$iv;
                try {
                    String content$iv;
                    ObjectMapper objectMapper = JacksonMapperKt.getJacksonMapper();
                    Intrinsics.checkNotNullExpressionValue((Object)JacksonMapperKt.getJacksonMapper().writeValueAsString(eventJson), (String)"writeValueAsString(...)");
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    $this$readValue$iv = (AgentEvent)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<AgentEvent>(){});
                }
                catch (Exception exception) {
                    String string = part.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    $this$readValue$iv = INSTANCE.toProgressEvent(string);
                }
                agentEvent = $this$readValue$iv;
            } else {
                String string = part.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                agentEvent = INSTANCE.toProgressEvent(string);
            }
            AgentEvent agentEvent2 = agentEvent;
            TaskState taskState = event.getStatus().state();
            Intrinsics.checkNotNull((Object)((Object)taskState));
            A2uxTaskState state = A2uxBridgeKt.access$mapTaskState(taskState);
            collection.add(new A2uxEvent(state, agentEvent2));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final CancelTaskRequest cancelTaskRequest(@NotNull TaskRequestId taskRequestId) {
        Intrinsics.checkNotNullParameter((Object)taskRequestId, (String)"taskRequestId");
        CancelTaskRequest cancelTaskRequest = new CancelTaskRequest.Builder().params(new TaskIdParams(taskRequestId.getId())).build();
        Intrinsics.checkNotNullExpressionValue((Object)cancelTaskRequest, (String)"build(...)");
        return cancelTaskRequest;
    }

    private final MarkdownBlockUpdatedEvent toProgressEvent(String $this$toProgressEvent) {
        return new MarkdownBlockUpdatedEvent(null, null, $this$toProgressEvent, 3, null);
    }
}

