/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.notification;

import com.intellij.ml.llm.core.AIAContainerPanelFacade;
import com.intellij.ml.llm.core.AIAContentFacade;
import com.intellij.ml.llm.core.chat.session.AIInput;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionHost;
import com.intellij.ml.llm.core.chat.session.ChatSessionVm;
import com.intellij.ml.llm.core.chat.ui.AIAssistantContainerPanel;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatPanel;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInput;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.ChatModePromoGotItTooltipProvider;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.NewChatMode;
import com.intellij.ml.llm.core.chat.ui.chat.notification.AIAssistantNotification;
import com.intellij.ml.llm.core.chat.ui.chat.notification.ChatNotificationManager;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.GotItTooltip;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u0012\u001a\u00020\nH\u0017J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\n\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u0015\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/notification/ChatNotificationManagerImpl;", "Lcom/intellij/ml/llm/core/chat/ui/chat/notification/ChatNotificationManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "showNotification", "", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionVm;", "notification", "Lcom/intellij/ml/llm/core/chat/ui/chat/notification/AIAssistantNotification;", "showChatModeGotIt", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/ChatModePromoGotItTooltipProvider;", "showNotificationInCurrentChatSession", "hideNotificationInCurrentChatSession", "hideNotification", "getLatestChatSession", "dispose", "intellij.ml.llm.content"})
@SourceDebugExtension(value={"SMAP\nChatNotificationManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatNotificationManagerImpl.kt\ncom/intellij/ml/llm/core/chat/notification/ChatNotificationManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1068#2:99\n*S KotlinDebug\n*F\n+ 1 ChatNotificationManagerImpl.kt\ncom/intellij/ml/llm/core/chat/notification/ChatNotificationManagerImpl\n*L\n94#1:99\n*E\n"})
public final class ChatNotificationManagerImpl
implements ChatNotificationManager,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;

    public ChatNotificationManagerImpl(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
    }

    @RequiresEdt
    public void showNotification(@NotNull ChatSessionVm chatSession, @NotNull AIAssistantNotification notification) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        AIAContainerPanelFacade aIAContainerPanelFacade = AIAContentFacade.Companion.getInstance(this.project).getPanel();
        Intrinsics.checkNotNull((Object)aIAContainerPanelFacade, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.ui.AIAssistantContainerPanel");
        AIAssistantChatPanel aIAssistantChatPanel = ((AIAssistantContainerPanel)aIAContainerPanelFacade).getChatPanel(chatSession);
        if (aIAssistantChatPanel == null) {
            return;
        }
        AIAssistantChatPanel chatPanel = aIAssistantChatPanel;
        if (notification.isCloseable()) {
            Function0 originalCloseAction = notification.getOnCloseAction();
            Field field = AIAssistantNotification.class.getDeclaredField("onCloseAction");
            field.setAccessible(true);
            field.set(notification, () -> ChatNotificationManagerImpl.showNotification$lambda$0(originalCloseAction, this, chatSession));
        }
        chatPanel.showNotification(notification);
    }

    public void showChatModeGotIt(@NotNull ChatSessionVm chatSession, @NotNull ChatModePromoGotItTooltipProvider notification) {
        GotItTooltip gotItTooltip;
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        NewChatMode chatMode = chatSession.getChatMode().getModeById(notification.getChatModeId());
        if (chatMode == null) {
            return;
        }
        GotItTooltip it = gotItTooltip = new GotItTooltip(notification.getToolTipId(), notification.getMessage(), (Disposable)this).withImage(notification.getImage(), false).withPosition(Balloon.Position.atLeft).withHeader(notification.getHeader()).withButtonLabel(notification.getTryItButtonLabel()).withGotItButtonAction(() -> ChatNotificationManagerImpl.showChatModeGotIt$lambda$0(notification, chatSession, chatMode));
        boolean bl = false;
        String skipLabel = notification.getSkipButtonLabel();
        if (skipLabel != null) {
            it.withSecondaryButton(skipLabel, () -> ChatNotificationManagerImpl.showChatModeGotIt$lambda$1$0(chatSession, chatMode));
        }
        GotItTooltip tooltip = gotItTooltip.withFocus();
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(chatSession, tooltip, null){
            int label;
            final /* synthetic */ ChatSessionVm $chatSession;
            final /* synthetic */ GotItTooltip $tooltip;
            {
                this.$chatSession = $chatSession;
                this.$tooltip = $tooltip;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TimeoutKt.withTimeout((long)2000L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$chatSession, this.$tooltip, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ ChatSessionVm $chatSession;
                            final /* synthetic */ GotItTooltip $tooltip;
                            {
                                this.$chatSession = $chatSession;
                                this.$tooltip = $tooltip;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = FlowKt.firstOrNull((Flow)((Flow)this.$chatSession.getAssociatedInput()), (Function2)((Function2)new Function2<AIInput, Continuation<? super Boolean>, Object>(null){
                                            int label;
                                            /* synthetic */ Object L$0;

                                            /*
                                             * WARNING - void declaration
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                AIInput aIInput = (AIInput)this.L$0;
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        void it;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        return Boxing.boxBoolean((it != null ? 1 : 0) != 0);
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                var3_3.L$0 = value;
                                                return (Continuation)var3_3;
                                            }

                                            public final Object invoke(AIInput p1, Continuation<? super Boolean> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v0 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        v1 = (var3_3 = v0) instanceof AIAssistantInput != false ? (AIAssistantInput)var3_3 : null;
                                        if (v1 == null) {
                                            return Unit.INSTANCE;
                                        }
                                        input = v1;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)input);
                                        this.label = 2;
                                        v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(input, this.$tooltip, null){
                                            int label;
                                            final /* synthetic */ AIAssistantInput $input;
                                            final /* synthetic */ GotItTooltip $tooltip;
                                            {
                                                this.$input = $input;
                                                this.$tooltip = $tooltip;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.$input.showChatModeGotItPromo(this.$tooltip);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v2 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl27
                                    }
                                    case 2: {
                                        input = (AIAssistantInput)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl27:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @RequiresEdt
    public void showNotificationInCurrentChatSession(@NotNull AIAssistantNotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        ChatSessionVm chatSessionVm = this.getLatestChatSession();
        if (chatSessionVm == null) {
            return;
        }
        ChatSessionVm chatSession = chatSessionVm;
        this.showNotification(chatSession, notification);
    }

    @RequiresEdt
    public void hideNotificationInCurrentChatSession() {
        ChatSessionVm chatSessionVm = this.getLatestChatSession();
        if (chatSessionVm == null) {
            return;
        }
        ChatSessionVm chatSession = chatSessionVm;
        this.hideNotification(chatSession);
    }

    @RequiresEdt
    public void hideNotification(@NotNull ChatSessionVm chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        AIAContainerPanelFacade aIAContainerPanelFacade = AIAContentFacade.Companion.getInstance(this.project).getPanel();
        Intrinsics.checkNotNull((Object)aIAContainerPanelFacade, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.ui.AIAssistantContainerPanel");
        AIAssistantChatPanel aIAssistantChatPanel = ((AIAssistantContainerPanel)aIAContainerPanelFacade).getChatPanel(chatSession);
        if (aIAssistantChatPanel == null) {
            return;
        }
        AIAssistantChatPanel chatPanel = aIAssistantChatPanel;
        chatPanel.hideNotification();
    }

    private final ChatSessionVm getLatestChatSession() {
        Iterable $this$sortedByDescending$iv = ChatSessionHost.Companion.getInstance(this.project).getAllChats();
        boolean $i$f$sortedByDescending = false;
        return (ChatSessionVm)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ChatSession it = (ChatSession)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTimestamp());
                it = (ChatSession)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
            }
        }));
    }

    public void dispose() {
    }

    private static final Unit showNotification$lambda$0(Function0 $originalCloseAction, ChatNotificationManagerImpl this$0, ChatSessionVm $chatSession) {
        Function0 function0 = $originalCloseAction;
        if (function0 != null) {
            function0.invoke();
        }
        this$0.hideNotification($chatSession);
        return Unit.INSTANCE;
    }

    private static final Unit showChatModeGotIt$lambda$0(ChatModePromoGotItTooltipProvider $notification, ChatSessionVm $chatSession, NewChatMode $chatMode) {
        if ($notification.isTryItActionEnabled()) {
            $chatSession.getChatMode().setChatMode($chatMode, true);
            AIAssistantChatEventLogger.logChatAgentPromoTryIt((ChatSession)$chatSession.getSession(), (NewChatMode)$chatMode);
        }
        return Unit.INSTANCE;
    }

    private static final Unit showChatModeGotIt$lambda$1$0(ChatSessionVm $chatSession, NewChatMode $chatMode) {
        AIAssistantChatEventLogger.logChatJuniePromoSkip((ChatSession)$chatSession.getSession(), (NewChatMode)$chatMode);
        return Unit.INSTANCE;
    }
}

