/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.retrievers;

import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.VisibleChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.embeddings.retrievers.IndexableEntityPrivacyWrapper;
import com.intellij.ml.llm.embeddings.retrievers.TextChunkAttachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/embeddings/retrievers/TextChunkChatAttachment;", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "Lcom/intellij/ml/llm/core/chat/attachments/VisibleChatAttachment;", "project", "Lcom/intellij/openapi/project/Project;", "entityPrivacyWrapper", "Lcom/intellij/ml/llm/embeddings/retrievers/IndexableEntityPrivacyWrapper;", "filePointer", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "textOffset", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/embeddings/retrievers/IndexableEntityPrivacyWrapper;Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;I)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEntityPrivacyWrapper", "()Lcom/intellij/ml/llm/embeddings/retrievers/IndexableEntityPrivacyWrapper;", "getTextOffset", "()I", "toContextAttachment", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "intellij.ml.llm.embeddings"})
public final class TextChunkChatAttachment
extends ChatAttachment
implements VisibleChatAttachment {
    @NotNull
    private final Project project;
    @NotNull
    private final IndexableEntityPrivacyWrapper entityPrivacyWrapper;
    private final int textOffset;

    public TextChunkChatAttachment(@NotNull Project project, @NotNull IndexableEntityPrivacyWrapper entityPrivacyWrapper, @NotNull VirtualFilePointer filePointer, int textOffset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)entityPrivacyWrapper), (String)"entityPrivacyWrapper");
        Intrinsics.checkNotNullParameter((Object)filePointer, (String)"filePointer");
        super(entityPrivacyWrapper.getName(), entityPrivacyWrapper.getContextRepresentation(), ChatAttachment.Kind.Visible, filePointer, (ContextEntitySource)ContextAttachmentSource.TextChunksRetriever.INSTANCE, null, null, 96, null);
        this.project = project;
        this.entityPrivacyWrapper = entityPrivacyWrapper;
        this.textOffset = textOffset;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final IndexableEntityPrivacyWrapper getEntityPrivacyWrapper() {
        return this.entityPrivacyWrapper;
    }

    public final int getTextOffset() {
        return this.textOffset;
    }

    @NotNull
    public ContextAttachment toContextAttachment() {
        VirtualFilePointer virtualFilePointer = this.getVirtualFilePointer();
        Intrinsics.checkNotNull((Object)virtualFilePointer);
        return (ContextAttachment)new TextChunkAttachment(this.project, this.entityPrivacyWrapper, virtualFilePointer, this.textOffset);
    }
}

