/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.memory;

import io.kinference.ndarray.arrays.memory.MemoryManager;
import io.kinference.ndarray.arrays.memory.contexts.AutoAllocatorContext;
import io.kinference.ndarray.arrays.memory.contexts.ManualAllocatorContext;
import io.kinference.ndarray.arrays.memory.storage.AutoArrayHandlingStorage;
import io.kinference.ndarray.arrays.memory.storage.ManualArrayHandlingStorage;
import io.kinference.utils.AllocationMode;
import io.kinference.utils.AllocatorContext;
import io.kinference.utils.Closeable;
import io.kinference.utils.NoAllocatorContext;
import io.kinference.utils.PredictionConfig;
import io.kinference.utils.PredictionContext;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\nJ\b\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lio/kinference/ndarray/arrays/memory/PredictionContextDispatcher;", "Lio/kinference/utils/Closeable;", "predictionConfig", "Lio/kinference/utils/PredictionConfig;", "<init>", "(Lio/kinference/utils/PredictionConfig;)V", "limiter", "Lio/kinference/ndarray/arrays/memory/MemoryManager;", "contextQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lio/kinference/utils/PredictionContext;", "allocationMode", "Lio/kinference/utils/AllocationMode;", "getAllocationMode", "()Lio/kinference/utils/AllocationMode;", "getPredictionContext", "getNoAllocatorContext", "getAutoAllocatorContext", "getManualAllocatorContext", "getDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "clearCache", "", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "returnStorage", "context", "ndarray-core"})
public final class PredictionContextDispatcher
implements Closeable {
    @NotNull
    private final PredictionConfig predictionConfig;
    @NotNull
    private final MemoryManager limiter;
    @NotNull
    private final ConcurrentLinkedQueue<PredictionContext> contextQueue;

    public PredictionContextDispatcher(@NotNull PredictionConfig predictionConfig) {
        Intrinsics.checkNotNullParameter((Object)predictionConfig, (String)"predictionConfig");
        this.predictionConfig = predictionConfig;
        this.limiter = new MemoryManager(this.predictionConfig.getMemoryThreshold(), this.predictionConfig.getMemoryClearingInterval(), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((PredictionContextDispatcher)this.receiver).clearCache();
            }
        }));
        this.contextQueue = new ConcurrentLinkedQueue();
    }

    @NotNull
    public final AllocationMode getAllocationMode() {
        return this.predictionConfig.getAllocationMode();
    }

    @NotNull
    public final PredictionContext getPredictionContext() {
        PredictionContext allocatorContext = switch (WhenMappings.$EnumSwitchMapping$0[this.predictionConfig.getAllocationMode().ordinal()]) {
            case 1 -> this.getNoAllocatorContext();
            case 2 -> this.getManualAllocatorContext();
            case 3 -> this.getAutoAllocatorContext();
            default -> throw new NoWhenBranchMatchedException();
        };
        return allocatorContext;
    }

    private final PredictionContext getNoAllocatorContext() {
        PredictionContext predictionContext = this.contextQueue.poll();
        if (predictionContext == null) {
            predictionContext = new NoAllocatorContext(this.getDispatcher());
        }
        return predictionContext;
    }

    private final PredictionContext getAutoAllocatorContext() {
        this.limiter.updateLastAccessTime();
        PredictionContext predictionContext = this.contextQueue.poll();
        if (predictionContext == null) {
            predictionContext = new AutoAllocatorContext(this.getDispatcher(), new AutoArrayHandlingStorage(this.limiter));
        }
        return predictionContext;
    }

    private final PredictionContext getManualAllocatorContext() {
        this.limiter.updateLastAccessTime();
        PredictionContext predictionContext = this.contextQueue.poll();
        if (predictionContext == null) {
            predictionContext = new ManualAllocatorContext(this.getDispatcher(), new ManualArrayHandlingStorage(this.limiter));
        }
        return predictionContext;
    }

    private final CoroutineDispatcher getDispatcher() {
        return Dispatchers.getDefault().limitedParallelism(this.predictionConfig.getParallelismLimit());
    }

    public final void clearCache() {
        this.limiter.stopMonitoring();
        this.contextQueue.clear();
        this.limiter.resetLimit();
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        this.clearCache();
        return Unit.INSTANCE;
    }

    public final void returnStorage(@NotNull PredictionContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        if (context instanceof AllocatorContext) {
            ((AllocatorContext)context).finalizeContext();
        }
        this.contextQueue.offer(context);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AllocationMode.values().length];
            try {
                nArray[AllocationMode.NoAllocation.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AllocationMode.Manual.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AllocationMode.Auto.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

