/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.memory.storage;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.BooleanNDArray;
import io.kinference.ndarray.arrays.MutableBooleanNDArray;
import io.kinference.ndarray.arrays.MutableNDArrayCore;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.memory.MemoryManager;
import io.kinference.ndarray.arrays.memory.storage.BooleanGetBlockFunctionsExtensionKt;
import io.kinference.ndarray.arrays.memory.storage.TypedManualHandlingStorage;
import io.kinference.ndarray.arrays.tiled.BooleanTiledArray;
import io.kinference.primitives.types.DataType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/kinference/ndarray/arrays/memory/storage/BooleanManualHandlingArrayStorage;", "Lio/kinference/ndarray/arrays/memory/storage/TypedManualHandlingStorage;", "<init>", "()V", "storage", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lkotlin/collections/ArrayDeque;", "", "getNDArray", "Lio/kinference/ndarray/arrays/MutableNDArrayCore;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "fillZeros", "", "limiter", "Lio/kinference/ndarray/arrays/memory/MemoryManager;", "returnNDArray", "", "ndarray", "Lio/kinference/ndarray/arrays/NDArrayCore;", "clear", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nBooleanManualHandlingArrayStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanManualHandlingArrayStorage.kt\nio/kinference/ndarray/arrays/memory/storage/BooleanManualHandlingArrayStorage\n+ 2 Utils.kt\nio/kinference/ndarray/extensions/utils/UtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,56:1\n57#2,7:57\n57#2,7:64\n216#3,2:71\n*S KotlinDebug\n*F\n+ 1 BooleanManualHandlingArrayStorage.kt\nio/kinference/ndarray/arrays/memory/storage/BooleanManualHandlingArrayStorage\n*L\n26#1:57,7\n46#1:64,7\n52#1:71,2\n*E\n"})
public final class BooleanManualHandlingArrayStorage
implements TypedManualHandlingStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Int2ObjectOpenHashMap<ArrayDeque<boolean[]>> storage = new Int2ObjectOpenHashMap(64);
    @NotNull
    private static final DataType type = DataType.BOOLEAN;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNDArrayCore getNDArray(@NotNull Strides strides, boolean fillZeros, @NotNull MemoryManager limiter2) {
        boolean[][] blArrayArray;
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)limiter2, (String)"limiter");
        int blockSize = UtilsKt.blockSizeByStrides(strides);
        int blocksNum = strides.getLinearSize() / blockSize;
        if (limiter2.checkMemoryLimitAndAdd(BooleanGetBlockFunctionsExtensionKt.getBooleanArraySizeInBytes(blockSize * blocksNum))) {
            ArrayDeque arrayDeque;
            Int2ObjectOpenHashMap<ArrayDeque<boolean[]>> $this$getOrPut$iv = this.storage;
            boolean $i$f$getOrPut = false;
            ArrayDeque existingValue$iv = $this$getOrPut$iv.get(blockSize);
            if (existingValue$iv != null) {
                arrayDeque = existingValue$iv;
            } else {
                boolean bl = false;
                ArrayDeque value$iv = new ArrayDeque(blocksNum);
                $this$getOrPut$iv.put(blockSize, (ArrayDeque<boolean[]>)value$iv);
                arrayDeque = value$iv;
            }
            ArrayDeque queue = arrayDeque;
            boolean[][] blArrayArray2 = new boolean[blocksNum][];
            for (int i = 0; i < blocksNum; ++i) {
                boolean[] blArray;
                int n = i;
                boolean[][] blArrayArray3 = blArrayArray2;
                int n2 = n;
                if ((boolean[])queue.removeFirstOrNull() != null) {
                    void $this$getNDArray_u24lambda_u241;
                    boolean[] blArray2;
                    boolean[] blArray3 = blArray2;
                    int n3 = n2;
                    boolean[][] blArrayArray4 = blArrayArray3;
                    boolean bl = false;
                    ArraysKt.fill$default((boolean[])$this$getNDArray_u24lambda_u241, (boolean)false, (int)0, (int)0, (int)6, null);
                    Unit unit = Unit.INSTANCE;
                    blArrayArray3 = blArrayArray4;
                    n2 = n3;
                    blArray = blArray2;
                } else {
                    blArray = new boolean[blockSize];
                }
                blArrayArray3[n2] = blArray;
            }
            blArrayArray = blArrayArray2;
        } else {
            int queue = 0;
            boolean[][] blArrayArray5 = new boolean[blocksNum][];
            while (queue < blocksNum) {
                int n = queue++;
                blArrayArray5[n] = new boolean[blockSize];
            }
            blArrayArray = blArrayArray5;
        }
        boolean[][] blocks = blArrayArray;
        BooleanTiledArray tiled = new BooleanTiledArray(blocks);
        return new MutableBooleanNDArray(tiled, strides);
    }

    @Override
    public void returnNDArray(@NotNull NDArrayCore ndarray) {
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter((Object)ndarray, (String)"ndarray");
        if (!(ndarray instanceof BooleanNDArray)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int blockSize = ((BooleanNDArray)ndarray).getArray().getBlockSize();
        int blocksNum = ((BooleanNDArray)ndarray).getArray().getBlocksNum();
        Int2ObjectOpenHashMap<ArrayDeque<boolean[]>> $this$getOrPut$iv = this.storage;
        boolean $i$f$getOrPut = false;
        ArrayDeque existingValue$iv = $this$getOrPut$iv.get(blockSize);
        if (existingValue$iv != null) {
            arrayDeque = existingValue$iv;
        } else {
            boolean bl = false;
            ArrayDeque value$iv = new ArrayDeque(blocksNum);
            $this$getOrPut$iv.put(blockSize, (ArrayDeque<boolean[]>)value$iv);
            arrayDeque = value$iv;
        }
        ArrayDeque queue = arrayDeque;
        CollectionsKt.addAll((Collection)((Collection)queue), (Object[])((Object[])((BooleanNDArray)ndarray).getArray().getBlocks()));
    }

    @Override
    public void clear() {
        Map $this$forEach$iv = this.storage;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            ArrayDeque queue = (ArrayDeque)entry.getValue();
            queue.clear();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/kinference/ndarray/arrays/memory/storage/BooleanManualHandlingArrayStorage$Companion;", "", "<init>", "()V", "type", "Lio/kinference/primitives/types/DataType;", "ndarray-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

