/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.pointers;

import io.kinference.ndarray.arrays.tiled.BooleanTiledArray;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0018\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\tJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u001fJ\u0006\u0010$\u001a\u00020\u001fJ\u0006\u0010%\u001a\u00020\u001fJ\u0006\u0010&\u001a\u00020 J\u0006\u0010'\u001a\u00020 J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020 J\u0006\u0010)\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u000e\"\u0004\b\u001d\u0010\u0010\u00a8\u0006*"}, d2={"Lio/kinference/ndarray/arrays/pointers/BooleanPointer;", "", "array", "Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;", "startIndex", "", "<init>", "(Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;I)V", "other", "(Lio/kinference/ndarray/arrays/pointers/BooleanPointer;)V", "getArray", "()Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;", "blockNum", "getBlockNum", "()I", "setBlockNum", "(I)V", "indexInBlock", "getIndexInBlock", "setIndexInBlock", "currentBlock", "", "getCurrentBlock", "()[Z", "setCurrentBlock", "([Z)V", "value", "linearIndex", "getLinearIndex", "setLinearIndex", "set", "", "", "get", "blockIncrement", "increment", "blockDecrement", "decrement", "incrementAndGet", "getAndIncrement", "setAndIncrement", "isValid", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nBooleanPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanPointer.kt\nio/kinference/ndarray/arrays/pointers/BooleanPointer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,3128:1\n1#2:3129\n*E\n"})
public final class BooleanPointer {
    @NotNull
    private final BooleanTiledArray array;
    private int blockNum;
    private int indexInBlock;
    @NotNull
    private boolean[] currentBlock;

    @NotNull
    public final BooleanTiledArray getArray() {
        return this.array;
    }

    public final int getBlockNum() {
        return this.blockNum;
    }

    public final void setBlockNum(int n) {
        this.blockNum = n;
    }

    public final int getIndexInBlock() {
        return this.indexInBlock;
    }

    public final void setIndexInBlock(int n) {
        this.indexInBlock = n;
    }

    @NotNull
    public final boolean[] getCurrentBlock() {
        return this.currentBlock;
    }

    public final void setCurrentBlock(@NotNull boolean[] blArray) {
        Intrinsics.checkNotNullParameter((Object)blArray, (String)"<set-?>");
        this.currentBlock = blArray;
    }

    public BooleanPointer(@NotNull BooleanTiledArray array, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (!(startIndex >= 0 && startIndex < array.getSize())) {
            boolean bl = false;
            String string = "Start index of Iterator must be >= 0 and < array size";
            throw new IllegalArgumentException(string.toString());
        }
        this.array = array;
        this.blockNum = startIndex / array.getBlockSize();
        this.indexInBlock = startIndex % array.getBlockSize();
        this.currentBlock = array.getBlocks()[this.blockNum];
    }

    public /* synthetic */ BooleanPointer(BooleanTiledArray booleanTiledArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(booleanTiledArray, n);
    }

    public BooleanPointer(@NotNull BooleanPointer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.array = other.array;
        this.blockNum = other.blockNum;
        this.indexInBlock = other.indexInBlock;
        this.currentBlock = other.currentBlock;
    }

    public final int getLinearIndex() {
        return this.blockNum * this.array.getBlockSize() + this.indexInBlock;
    }

    public final void setLinearIndex(int value) {
        if (!(value >= 0 && value < this.array.getSize())) {
            boolean bl = false;
            String string = "Linear index of Iterator must be >= 0 and < array size";
            throw new IllegalArgumentException(string.toString());
        }
        this.blockNum = value / this.array.getBlockSize();
        this.indexInBlock = value % this.array.getBlockSize();
        this.currentBlock = this.array.getBlocks()[this.blockNum];
    }

    public final void set(boolean value) {
        this.currentBlock[this.indexInBlock] = value;
    }

    public final boolean get() {
        return this.currentBlock[this.indexInBlock];
    }

    public final void blockIncrement() {
        if (this.blockNum < this.array.getBlocksNum() - 1) {
            int n = this.blockNum;
            this.blockNum = n + 1;
            this.indexInBlock = 0;
            this.currentBlock = this.array.getBlocks()[this.blockNum];
        } else {
            this.indexInBlock = this.array.getBlockSize();
        }
    }

    public final void increment() {
        if (this.indexInBlock < this.array.getBlockSize() - 1) {
            int n = this.indexInBlock;
            this.indexInBlock = n + 1;
        } else {
            this.blockIncrement();
        }
    }

    public final void blockDecrement() {
        if (this.blockNum > 0) {
            int n = this.blockNum;
            this.blockNum = n + -1;
            this.indexInBlock = this.array.getBlockSize() - 1;
            this.currentBlock = this.array.getBlocks()[this.blockNum];
        } else {
            this.indexInBlock = -1;
        }
    }

    public final void decrement() {
        if (this.indexInBlock > 0) {
            int n = this.indexInBlock;
            this.indexInBlock = n + -1;
        } else {
            this.blockDecrement();
        }
    }

    public final boolean incrementAndGet() {
        this.increment();
        return this.currentBlock[this.indexInBlock];
    }

    public final boolean getAndIncrement() {
        boolean value = this.currentBlock[this.indexInBlock];
        this.increment();
        return value;
    }

    public final void setAndIncrement(boolean value) {
        this.currentBlock[this.indexInBlock] = value;
        this.increment();
    }

    public final boolean isValid() {
        return this.indexInBlock < this.array.getBlockSize() && this.indexInBlock > -1;
    }
}

