/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.utils;

import io.kinference.ndarray.arrays.PrimitiveNDArray;
import io.kinference.ndarray.arrays.pointers.PrimitivePointer;
import io.kinference.ndarray.arrays.pointers.PrimitivePointerKt;
import io.kinference.ndarray.arrays.tiled.PrimitiveTiledArray;
import io.kinference.ndarray.extensions.utils.InputInfo;
import io.kinference.ndarray.extensions.utils.UtilsKt;
import io.kinference.primitives.annotations.GeneratePrimitives;
import io.kinference.primitives.annotations.MakePublic;
import io.kinference.primitives.types.DataType;
import io.kinference.primitives.types.ExtensionsKt;
import io.kinference.primitives.types.PrimitiveArray;
import io.kinference.primitives.types.PrimitiveType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@GeneratePrimitives(types={DataType.FLOAT, DataType.DOUBLE, DataType.UBYTE, DataType.BYTE, DataType.LONG})
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u001a2\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u00a8\u0006\r"}, d2={"primitiveIm2Col", "", "im", "Lio/kinference/ndarray/arrays/PrimitiveNDArray;", "inputInfo", "Lio/kinference/ndarray/extensions/utils/InputInfo;", "channelsTotal", "", "col", "padValue", "Lio/kinference/primitives/types/PrimitiveType;", "primitiveIm2ColRank2", "channelsCol", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nPrimitiveIm2Col.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveIm2Col.kt\nio/kinference/ndarray/extensions/utils/PrimitiveIm2ColKt\n+ 2 PrimitivePointer.kt\nio/kinference/ndarray/arrays/pointers/PrimitivePointerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n123#2,18:122\n223#2:140\n225#2,30:142\n1#3:141\n*S KotlinDebug\n*F\n+ 1 PrimitiveIm2Col.kt\nio/kinference/ndarray/extensions/utils/PrimitiveIm2ColKt\n*L\n88#1:122,18\n102#1:140\n102#1:142,30\n102#1:141\n*E\n"})
public final class PrimitiveIm2ColKt {
    @MakePublic
    public static final void primitiveIm2Col(@NotNull PrimitiveNDArray im, @NotNull InputInfo inputInfo, int channelsTotal, @NotNull PrimitiveNDArray col, @NotNull PrimitiveType padValue) {
        Intrinsics.checkNotNullParameter((Object)im, (String)"im");
        Intrinsics.checkNotNullParameter((Object)inputInfo, (String)"inputInfo");
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        Intrinsics.checkNotNullParameter((Object)padValue, (String)"padValue");
        int[] dOffset = new int[inputInfo.getRank()];
        int[] dIter = new int[inputInfo.getRank()];
        for (int i = 0; i < channelsTotal; ++i) {
            int colChannel = i;
            boolean bl = false;
            int offset = colChannel;
            for (int dI = inputInfo.getRank() - 1; -1 < dI; --dI) {
                if (dI < inputInfo.getRank() - 1) {
                    offset /= inputInfo.getKernelShape()[dI + 1];
                }
                dOffset[dI] = offset % inputInfo.getKernelShape()[dI];
            }
            boolean hasNextOutput = false;
            block2: do {
                int indexCol = colChannel;
                int indexIm = colChannel / inputInfo.getKernelSize();
                boolean isPadding = false;
                int n = inputInfo.getRank();
                for (int dI = 0; dI < n; ++dI) {
                    int d = dIter[dI];
                    int dIm = d * inputInfo.getStrides()[dI] - inputInfo.padBegin(dI) + dOffset[dI] * inputInfo.getDilations()[dI];
                    if (dIm < 0 || dIm >= inputInfo.getInputShape()[dI]) {
                        isPadding = true;
                    }
                    indexCol *= inputInfo.getOutputShape()[dI];
                    indexCol += d;
                    indexIm *= inputInfo.getInputShape()[dI];
                    indexIm += dIm;
                }
                if (isPadding) {
                    col.getArray().set(indexCol, padValue);
                } else {
                    col.getArray().set(indexCol, im.getArray().get(indexIm));
                }
                hasNextOutput = false;
                for (int j = inputInfo.getRank() - 1; -1 < j; --j) {
                    int dMax = inputInfo.getOutputShape()[j] - 1;
                    if (dIter[j] < dMax) {
                        int n2 = j;
                        dIter[n2] = dIter[n2] + 1;
                        int cfr_ignored_0 = dIter[n2];
                        hasNextOutput = true;
                        continue block2;
                    }
                    dIter[j] = 0;
                }
            } while (hasNextOutput);
        }
    }

    public static /* synthetic */ void primitiveIm2Col$default(PrimitiveNDArray primitiveNDArray, InputInfo inputInfo, int n, PrimitiveNDArray primitiveNDArray2, PrimitiveType primitiveType, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            primitiveType = ExtensionsKt.toPrimitive(0);
        }
        PrimitiveIm2ColKt.primitiveIm2Col(primitiveNDArray, inputInfo, n, primitiveNDArray2, primitiveType);
    }

    /*
     * WARNING - void declaration
     */
    @MakePublic
    public static final void primitiveIm2ColRank2(@NotNull PrimitiveNDArray im, @NotNull InputInfo inputInfo, int channelsCol, @NotNull PrimitiveNDArray col, @NotNull PrimitiveType padValue) {
        Intrinsics.checkNotNullParameter((Object)im, (String)"im");
        Intrinsics.checkNotNullParameter((Object)inputInfo, (String)"inputInfo");
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        Intrinsics.checkNotNullParameter((Object)padValue, (String)"padValue");
        PrimitivePointer colPointer = PrimitiveTiledArray.pointer$default(col.getArray(), 0, 1, null);
        int linearIndex = 0;
        int channelSize = inputInfo.getInputSize();
        for (int i = 0; i < channelsCol; ++i) {
            int it = i;
            boolean bl = false;
            int n = inputInfo.getKernelShape()[0];
            for (int kernelRow = 0; kernelRow < n; ++kernelRow) {
                int n2 = inputInfo.getKernelShape()[1];
                for (int kernelCol = 0; kernelCol < n2; ++kernelCol) {
                    int inputRow = 0;
                    inputRow = -inputInfo.padBegin(0) + kernelRow * inputInfo.getDilations()[0];
                    int n3 = inputInfo.getOutputShape()[0];
                    for (int j = 0; j < n3; ++j) {
                        int it2 = j;
                        boolean bl2 = false;
                        if (UtilsKt.isInPadding(inputRow, inputInfo.getInputShape()[0])) {
                            int offset$iv;
                            PrimitiveArray block$iv;
                            PrimitivePointer primitivePointer = colPointer;
                            int count$iv = inputInfo.getOutputShape()[1];
                            boolean $i$f$map = false;
                            for (int end$iv = count$iv; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv) {
                                void $this$map$iv;
                                block$iv = $this$map$iv.getCurrentBlock();
                                offset$iv = $this$map$iv.getIndexInBlock();
                                if (block$iv.getSize() <= offset$iv + end$iv) {
                                    $this$map$iv.blockIncrement();
                                } else {
                                    $this$map$iv.setIndexInBlock($this$map$iv.getIndexInBlock() + end$iv);
                                }
                                int index$iv = offset$iv;
                                int n4 = Math.min(block$iv.getSize(), offset$iv + end$iv);
                                while (index$iv < n4) {
                                    PrimitiveType primitiveType = block$iv.get(index$iv);
                                    var29_35 = index$iv++;
                                    var30_36 = block$iv;
                                    boolean bl3 = false;
                                    var32_38 = padValue;
                                    ((PrimitiveArray)var30_36).set(var29_35, var32_38);
                                }
                            }
                        } else {
                            int inputCol = -inputInfo.padBegin(1) + kernelCol * inputInfo.getDilations()[1];
                            int imOffset = inputRow * inputInfo.getInputShape()[1] + inputCol;
                            int i2 = 0;
                            while (i2 < inputInfo.getOutputShape()[1]) {
                                if (UtilsKt.isInPadding(inputCol, inputInfo.getInputShape()[1])) {
                                    colPointer.setAndIncrement(padValue);
                                    ++i2;
                                    inputCol += inputInfo.getStrides()[1];
                                    continue;
                                }
                                if (inputInfo.getStrides()[1] == 1) {
                                    PrimitivePointer imPointer;
                                    int cnt = Math.min(inputInfo.getInputShape()[1] - inputCol, inputInfo.getOutputShape()[1] - i2);
                                    PrimitivePointer $this$mapTo$iv = imPointer = im.getArray().pointer(linearIndex + imOffset + i2);
                                    boolean $i$f$mapTo = false;
                                    if (!PrimitivePointerKt.isCompatibleBySize($this$mapTo$iv, colPointer, cnt)) {
                                        boolean $i$a$-require-PrimitivePointerKt$mapTo$1$iv22 = false;
                                        String $i$a$-require-PrimitivePointerKt$mapTo$1$iv22 = "Pointers not compatible by available elements";
                                        throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$mapTo$1$iv22.toString());
                                    }
                                    if (PrimitivePointerKt.isCompatibleWith($this$mapTo$iv, colPointer)) {
                                        int offset$iv;
                                        PrimitiveArray srcBlock$iv;
                                        for (end$iv = cnt; end$iv > 0; end$iv -= srcBlock$iv.getSize() - offset$iv) {
                                            srcBlock$iv = $this$mapTo$iv.getCurrentBlock();
                                            offset$iv = $this$mapTo$iv.getIndexInBlock();
                                            PrimitiveArray dstBlock$iv = colPointer.getCurrentBlock();
                                            if (srcBlock$iv.getSize() <= offset$iv + end$iv) {
                                                $this$mapTo$iv.blockIncrement();
                                                colPointer.blockIncrement();
                                            } else {
                                                $this$mapTo$iv.setIndexInBlock($this$mapTo$iv.getIndexInBlock() + end$iv);
                                                colPointer.setIndexInBlock(colPointer.getIndexInBlock() + end$iv);
                                            }
                                            int index$iv = offset$iv;
                                            int n5 = Math.min(srcBlock$iv.getSize(), offset$iv + end$iv);
                                            while (index$iv < n5) {
                                                PrimitiveType primitiveType = srcBlock$iv.get(index$iv);
                                                var29_35 = index$iv++;
                                                var30_36 = dstBlock$iv;
                                                $i$a$-mapTo-PrimitiveIm2ColKt$primitiveIm2ColRank2$1$1$2 = false;
                                                var32_38 = it;
                                                ((PrimitiveArray)var30_36).set(var29_35, var32_38);
                                            }
                                        }
                                    } else {
                                        while (end$iv > 0) {
                                            it = $this$mapTo$iv.getAndIncrement();
                                            var30_36 = colPointer;
                                            $i$a$-mapTo-PrimitiveIm2ColKt$primitiveIm2ColRank2$1$1$2 = false;
                                            ((PrimitivePointer)var30_36).set(it);
                                            colPointer.increment();
                                            --end$iv;
                                        }
                                    }
                                    i2 += cnt;
                                    inputCol += cnt;
                                    continue;
                                }
                                colPointer.setAndIncrement(im.getArray().get(linearIndex + imOffset + i2 * inputInfo.getStrides()[1]));
                                ++i2;
                                inputCol += inputInfo.getStrides()[1];
                            }
                        }
                        inputRow += inputInfo.getStrides()[0];
                    }
                }
            }
            linearIndex += channelSize;
        }
    }

    public static /* synthetic */ void primitiveIm2ColRank2$default(PrimitiveNDArray primitiveNDArray, InputInfo inputInfo, int n, PrimitiveNDArray primitiveNDArray2, PrimitiveType primitiveType, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            primitiveType = ExtensionsKt.toPrimitive(0);
        }
        PrimitiveIm2ColKt.primitiveIm2ColRank2(primitiveNDArray, inputInfo, n, primitiveNDArray2, primitiveType);
    }
}

