/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.utils.time;

import io.kinference.utils.time.Duration;
import io.kinference.utils.time.Time;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0000H\u0087\u0002J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0000J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\u00a8\u0006%"}, d2={"Lio/kinference/utils/time/Timestamp;", "", "millis", "", "<init>", "(J)V", "getMillis", "()J", "toString", "", "seconds", "", "getSeconds", "()I", "minutes", "getMinutes", "hours", "getHours", "days", "getDays", "plus", "duration", "Lio/kinference/utils/time/Duration;", "minus", "compareTo", "other", "between", "before", "", "beforeOrEqual", "after", "afterOrEqual", "component1", "copy", "equals", "hashCode", "Companion", "utils-common"})
public final class Timestamp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long millis;

    public Timestamp(long millis) {
        this.millis = millis;
    }

    public final long getMillis() {
        return this.millis;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.millis);
    }

    public final int getSeconds() {
        return MathKt.roundToInt((double)((double)this.millis / (double)1000));
    }

    public final int getMinutes() {
        return MathKt.roundToInt((double)((double)this.getSeconds() / (double)60));
    }

    public final int getHours() {
        return MathKt.roundToInt((double)((double)this.getMinutes() / (double)60));
    }

    public final int getDays() {
        return MathKt.roundToInt((double)((double)this.getHours() / (double)24));
    }

    @NotNull
    public final Timestamp plus(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Timestamp(this.millis + duration.getMillis());
    }

    @NotNull
    public final Timestamp minus(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Timestamp(Math.max(0L, this.millis - duration.getMillis()));
    }

    public final int compareTo(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.millis, (long)other.millis);
    }

    @NotNull
    public final Duration between(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Duration(Math.abs(this.millis - other.millis));
    }

    public final boolean before(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) < 0;
    }

    public final boolean beforeOrEqual(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) <= 0;
    }

    public final boolean after(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) >= 0;
    }

    public final boolean afterOrEqual(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.millis >= other.millis;
    }

    public final long component1() {
        return this.millis;
    }

    @NotNull
    public final Timestamp copy(long millis) {
        return new Timestamp(millis);
    }

    public static /* synthetic */ Timestamp copy$default(Timestamp timestamp, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = timestamp.millis;
        }
        return timestamp.copy(l);
    }

    public int hashCode() {
        return Long.hashCode(this.millis);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Timestamp)) {
            return false;
        }
        Timestamp timestamp = (Timestamp)other;
        return this.millis == timestamp.millis;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lio/kinference/utils/time/Timestamp$Companion;", "", "<init>", "()V", "now", "Lio/kinference/utils/time/Timestamp;", "epoch", "utils-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Timestamp now() {
            return new Timestamp(Time.INSTANCE.epochMillis$utils_common());
        }

        @NotNull
        public final Timestamp epoch() {
            return new Timestamp(0L);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

