/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.RepositoryService;
import org.jetbrains.settingsRepository.git.GitExKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/settingsRepository/git/GitRepositoryService;", "Lorg/jetbrains/settingsRepository/RepositoryService;", "<init>", "()V", "isValidRepository", "", "file", "Ljava/nio/file/Path;", "intellij.settingsRepository"})
public final class GitRepositoryService
implements RepositoryService {
    @Override
    public boolean isValidRepository(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.resolve(".git");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return true;
        }
        try {
            GitExKt.buildRepository$default(null, false, file, true, 3, null);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

