/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import java.io.File;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.ast.listing_utils.PyFileListing;
import org.python.pydev.ast.runners.UniversalRunner;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.codecoverage.CoverageCache;
import org.python.pydev.debug.codecoverage.CoverageException;
import org.python.pydev.debug.codecoverage.CoverageXmlInfo;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.io.ThreadStreamReader;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;

public class PyCoverage {
    public CoverageCache cache = new CoverageCache();
    private static PyCoverage pyCoverage;

    public void refreshCoverageInfo(IContainer container, IProgressMonitor monitor) throws CoverageException {
        int exitValue = 0;
        String stdOut = "";
        String stdErr = "";
        this.cache.clear();
        if (container == null) {
            return;
        }
        try {
            if (!container.exists()) {
                throw new RuntimeException("The directory passed: " + container + " no longer exists.");
            }
            File file = container.getLocation().toFile();
            PyFileListing pyFilesBelow = new PyFileListing();
            if (file.exists()) {
                pyFilesBelow = PyFileListing.getPyFilesBelow((File)file, (IProgressMonitor)monitor, (boolean)true);
            }
            if (pyFilesBelow.getFoundPyFileInfos().size() == 0) {
                return;
            }
            boolean added = false;
            for (File f : pyFilesBelow.getFoundFolders()) {
                if (!added) {
                    this.cache.addFolder(f);
                    added = true;
                    continue;
                }
                this.cache.addFolder(f, f.getParentFile());
            }
            PythonNature nature = PythonNature.getPythonNature((IResource)container);
            if (nature == null) {
                throw new RuntimeException("The directory passed: " + container + " does not have an associated nature.");
            }
            UniversalRunner.AbstractRunner runner = UniversalRunner.getRunner((IPythonNature)nature);
            Tuple output = runner.runScriptAndGetOutput(PythonRunnerConfig.getCoverageScript(), new String[]{"combine", "--append"}, PyCoverage.getCoverageDirLocation(), monitor);
            if (output.o1 != null && ((String)output.o1).length() > 0) {
                Log.logInfo((String)((String)output.o1));
            }
            if (output.o2 != null && ((String)output.o2).length() > 0) {
                if (((String)output.o2).startsWith("Coverage.py warning:")) {
                    Log.logInfo((String)((String)output.o2));
                } else {
                    Log.log((String)((String)output.o2));
                }
            }
            monitor.setTaskName("Starting shell to get info...");
            File coverageDirLocation = PyCoverage.getCoverageDirLocation();
            File coverageXmlLocation = new File(coverageDirLocation, "coverage.xml");
            if (coverageXmlLocation.exists()) {
                coverageXmlLocation.delete();
            }
            monitor.worked(1);
            Process p = null;
            try {
                Tuple tup = runner.createProcess(PythonRunnerConfig.getCoverageScript(), new String[]{"--pydev-analyze"}, coverageDirLocation, monitor);
                p = (Process)tup.o1;
                String files = "";
                Iterator iter = pyFilesBelow.getFoundPyFileInfos().iterator();
                while (iter.hasNext()) {
                    String fStr = ((PyFileListing.PyFileInfo)iter.next()).getFile().toString();
                    files = String.valueOf(files) + fStr + "|";
                }
                files = String.valueOf(files) + "\r";
                monitor.setTaskName("Writing to shell...");
                ThreadStreamReader inputStream = new ThreadStreamReader(p.getInputStream(), false);
                inputStream.start();
                ThreadStreamReader errorStream = new ThreadStreamReader(p.getErrorStream(), false);
                errorStream.start();
                monitor.worked(1);
                OutputStream outputStream = p.getOutputStream();
                outputStream.write(files.getBytes());
                outputStream.close();
                monitor.setTaskName("Waiting for process to finish...");
                monitor.worked(1);
                while (true) {
                    try {
                        exitValue = p.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        try {
                            p.destroy();
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                    break;
                }
                stdOut = inputStream.getAndClearContents().trim();
                stdErr = errorStream.getAndClearContents().trim();
                if (stdOut.length() > 0) {
                    Log.log((String)stdOut);
                }
                if (stdErr.length() > 0) {
                    Log.log((String)stdErr);
                }
                monitor.setTaskName("Getting coverage info...(please wait, this could take a while)");
                monitor.worked(1);
                if (!coverageXmlLocation.exists()) {
                    Log.log((String)("Expected file: " + coverageXmlLocation + " to be written to analyze coverage info."));
                } else {
                    CoverageXmlInfo.analyze(this.cache, coverageXmlLocation);
                }
                monitor.setTaskName("Finished");
            }
            catch (Exception e) {
                if (p != null) {
                    p.destroy();
                }
                Log.log((Throwable)e);
            }
        }
        catch (Exception e1) {
            Log.log((Throwable)e1);
            throw new RuntimeException(e1);
        }
        if (exitValue != 0) {
            FastStringBuffer buf = new FastStringBuffer("Error with coverage action (exit value: ", stdErr.length() + stdOut.length() + 40);
            buf.append(exitValue).append(").");
            if (stdOut.length() > 0) {
                buf.append("\nStandard outputt:\n");
                buf.append(stdOut);
            }
            if (stdErr.length() > 0) {
                buf.append("\nError output:\n");
                buf.append(stdErr);
            }
            throw new CoverageException(buf.toString());
        }
    }

    public void clearInfo() {
        this.cache.clear();
        File dir = PyCoverage.getCoverageDirLocation();
        try {
            FileUtils.clearTempFilesAt((File)dir, (String)".coverage.");
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            new File(dir, ".coverage").delete();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static PyCoverage getPyCoverage() {
        if (pyCoverage == null) {
            pyCoverage = new PyCoverage();
        }
        return pyCoverage;
    }

    public static File getCoverageDirLocation() {
        IPath stateLocation = PydevDebugPlugin.getDefault().getStateLocation();
        stateLocation = stateLocation.append("coverage");
        String loc = FileUtils.getFileAbsolutePath((File)stateLocation.toFile());
        File dir = new File(loc);
        try {
            dir.mkdirs();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        if (!dir.exists()) {
            throw new RuntimeException("The directory: " + loc + " could not be created.");
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("Expected the path: " + loc + " to be a directory.");
        }
        return dir;
    }

    public static File getCoverageFileLocation() {
        return FileUtils.getTempFileAt((File)PyCoverage.getCoverageDirLocation(), (String)".coverage.");
    }
}

