/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.console;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.console.PromptOverlay;
import org.python.pydev.debug.core.PydevDebugPlugin;

public class SetFullLayoutAction
extends Action {
    private WeakReference<PromptOverlay> promptOverlay;
    private IPreferenceStore preferences;
    private int previousConsoleHeight = 30;

    public SetFullLayoutAction(WeakReference<PromptOverlay> promptOverlay) {
        this.promptOverlay = promptOverlay;
        this.preferences = PydevDebugPlugin.getDefault().getPreferenceStore();
        this.updateText();
    }

    private void updateText() {
        PromptOverlay overlay = (PromptOverlay)this.promptOverlay.get();
        if (overlay == null) {
            return;
        }
        int relativeConsoleHeight = overlay.getRelativeConsoleHeight();
        if (relativeConsoleHeight < 100) {
            this.setText("Hide original console");
        } else {
            this.setText("Show original console");
        }
    }

    public void run() {
        int newSize;
        PromptOverlay overlay = (PromptOverlay)this.promptOverlay.get();
        if (overlay == null || this.preferences == null) {
            return;
        }
        int relativeConsoleHeight = overlay.getRelativeConsoleHeight();
        if (relativeConsoleHeight < 100) {
            this.previousConsoleHeight = relativeConsoleHeight;
            newSize = 100;
            this.preferences.setValue("CONSOLE_PROMPT_OUTPUT_MODE", 2);
        } else {
            newSize = this.previousConsoleHeight;
            this.preferences.setValue("CONSOLE_PROMPT_OUTPUT_MODE", 1);
        }
        this.preferences.setValue("RELATIVE_CONSOLE_HEIGHT", newSize);
        if (this.preferences instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.preferences).save();
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
        this.updateText();
    }

    public void dispose() {
        this.preferences = null;
        this.setEnabled(false);
    }
}

