/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.console;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.console.PromptOverlay;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.shared_ui.dialogs.DialogHelpers;

public class SetLayoutAction
extends Action
implements IPropertyChangeListener {
    private WeakReference<PromptOverlay> promptOverlay;
    private IPreferenceStore preferences;

    public SetLayoutAction(WeakReference<PromptOverlay> promptOverlay) {
        this.promptOverlay = promptOverlay;
        this.setText("Set Console Height");
        this.preferences = PydevDebugPlugin.getDefault().getPreferenceStore();
        this.preferences.addPropertyChangeListener((IPropertyChangeListener)this);
        this.update();
    }

    private void update() {
        PromptOverlay overlay = (PromptOverlay)this.promptOverlay.get();
        if (overlay == null) {
            return;
        }
        overlay.setRelativeConsoleHeight(this.preferences.getInt("RELATIVE_CONSOLE_HEIGHT"));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("RELATIVE_CONSOLE_HEIGHT".equals(event.getProperty())) {
            this.update();
        }
    }

    public void run() {
        PromptOverlay overlay = (PromptOverlay)this.promptOverlay.get();
        if (overlay == null || this.preferences == null) {
            return;
        }
        Integer newSize = DialogHelpers.openAskInt((String)"Percentual size for console prompt.", (String)"Please enter the relative size for the console prompt (0-100)", (int)this.preferences.getInt("RELATIVE_CONSOLE_HEIGHT"));
        if (newSize != null) {
            if (newSize < 0) {
                newSize = 0;
            }
            if (newSize > 100) {
                newSize = 100;
            }
        }
        this.preferences.setValue("RELATIVE_CONSOLE_HEIGHT", newSize.intValue());
        if (this.preferences instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.preferences).save();
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public void dispose() {
        if (this.preferences != null) {
            this.preferences.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.preferences = null;
        this.setEnabled(false);
    }
}

