/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.console_actions;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;
import org.python.pydev.debug.console_actions.RestartLaunchAction;
import org.python.pydev.debug.console_actions.TerminateAllLaunchesAction;
import org.python.pydev.shared_core.log.Log;

public class ConsoleRestartLaunchPageParticipant
implements IConsolePageParticipant,
IDebugEventSetListener {
    private RestartLaunchAction restartLaunchAction;
    private TerminateAllLaunchesAction terminateAllLaunchesAction;
    private ProcessConsole fConsole;

    public void init(IPageBookViewPage page, IConsole console) {
        try {
            if (!(console instanceof ProcessConsole)) {
                return;
            }
            ProcessConsole processConsole = (ProcessConsole)console;
            IProcess process = processConsole.getProcess();
            if (process == null) {
                return;
            }
            String attribute = process.getAttribute("PYDEV_ADD_RELAUNCH_IPROCESS_ATTR");
            if (!"true".equals(attribute)) {
                return;
            }
            this.fConsole = processConsole;
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            IActionBars bars = page.getSite().getActionBars();
            IToolBarManager toolbarManager = bars.getToolBarManager();
            this.restartLaunchAction = new RestartLaunchAction(page, processConsole);
            this.terminateAllLaunchesAction = new TerminateAllLaunchesAction();
            toolbarManager.appendToGroup("launchGroup", (IAction)this.restartLaunchAction);
            toolbarManager.appendToGroup("launchGroup", (IAction)this.terminateAllLaunchesAction);
            bars.updateActionBars();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource().equals(this.getProcess())) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (ConsoleRestartLaunchPageParticipant.this.restartLaunchAction != null) {
                            ConsoleRestartLaunchPageParticipant.this.restartLaunchAction.update();
                        }
                        if (ConsoleRestartLaunchPageParticipant.this.terminateAllLaunchesAction != null) {
                            ConsoleRestartLaunchPageParticipant.this.terminateAllLaunchesAction.update();
                        }
                    }
                };
                DebugUIPlugin.getStandardDisplay().asyncExec(r);
            }
            ++i;
        }
    }

    protected IProcess getProcess() {
        return this.fConsole != null ? this.fConsole.getProcess() : null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (this.restartLaunchAction != null) {
            this.restartLaunchAction.dispose();
            this.restartLaunchAction = null;
        }
        if (this.terminateAllLaunchesAction != null) {
            this.terminateAllLaunchesAction.dispose();
            this.terminateAllLaunchesAction = null;
        }
    }

    public void activated() {
    }

    public void deactivated() {
    }
}

