/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.console_actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.texteditor.IUpdate;
import org.python.pydev.shared_core.image.IImageDescriptor;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.actions.BaseAction;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;

public class RestartLaunchAction
extends BaseAction
implements IUpdate,
IEditorActionDelegate {
    protected IPageBookViewPage page;
    protected ProcessConsole console;
    private final ILaunch launch;
    private final ILaunchConfiguration launchConfiguration;
    private static ILaunch lastLaunch;
    private static ILaunchConfiguration lastConfig;

    public RestartLaunchAction(IPageBookViewPage page, ProcessConsole console) {
        this.page = page;
        this.console = console;
        this.launch = this.console.getProcess().getLaunch();
        this.launchConfiguration = this.launch.getLaunchConfiguration();
        lastLaunch = this.launch;
        lastConfig = this.launch.getLaunchConfiguration();
        this.update();
    }

    public void update() {
        String str;
        IProcess process = this.console.getProcess();
        this.setEnabled(true);
        KeySequence binding = KeyBindingHelper.getCommandKeyBinding((String)"org.python.pydev.debug.ui.actions.relaunchLastAction");
        String string = str = binding != null ? "(" + binding.format() + " with focus on editor)" : "(unbinded)";
        if (process.canTerminate()) {
            this.setImageDescriptor(ImageCache.asImageDescriptor((IImageDescriptor)SharedUiPlugin.getImageCache().getDescriptor("icons/relaunch.png")));
            this.setToolTipText("Restart the current launch. " + str);
        } else {
            this.setImageDescriptor(ImageCache.asImageDescriptor((IImageDescriptor)SharedUiPlugin.getImageCache().getDescriptor("icons/relaunch1.png")));
            this.setToolTipText("Relaunch with the same configuration." + str);
        }
    }

    public static void relaunch(ILaunch launch, ILaunchConfiguration launchConfiguration) {
        if (launch != null && launchConfiguration != null) {
            try {
                launch.terminate();
            }
            catch (DebugException e) {
                Log.log((Throwable)e);
            }
            try {
                launchConfiguration.launch(launch.getLaunchMode(), null);
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public void run(IAction action) {
        RestartLaunchAction.relaunch(this.launch, this.launchConfiguration);
    }

    public void run() {
        this.run((IAction)this);
    }

    public void dispose() {
        this.page = null;
        this.console = null;
    }

    public static void relaunchLast() {
        RestartLaunchAction.relaunch(lastLaunch, lastConfig);
    }
}

