/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.SmartStepIntoVariant;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.parser.visitors.PythonLanguageUtils;
import org.python.pydev.shared_core.string.ICoreTextSelection;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;

public class StepIntoSelectionHyperlinkDetector
extends AbstractHyperlinkDetector {
    /*
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor editor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (editor instanceof PyEdit) {
            PyEdit pyEdit = (PyEdit)editor;
            IAdaptable debugContext = DebugUITools.getDebugContext();
            if (debugContext == null) {
                return null;
            }
            if (!(debugContext instanceof PyStackFrame)) {
                return null;
            }
            PyStackFrame pyStackFrame = (PyStackFrame)debugContext;
            Object[] stepIntoTargets = pyStackFrame.getStepIntoTargets();
            if (stepIntoTargets == null) {
                Log.log((String)"Unable to get Smart Step Into Targets.");
                return null;
            }
            int offset = region.getOffset();
            try {
                SmartStepIntoVariant target;
                String selectedWord;
                IDocument document = pyEdit.getDocument();
                IRegion wordRegion = TextSelectionUtils.findWord((IDocument)document, (int)offset);
                if (wordRegion == null || wordRegion.getLength() == 0) {
                    return null;
                }
                try {
                    selectedWord = document.get(wordRegion.getOffset(), wordRegion.getLength());
                    if (PythonLanguageUtils.isKeyword((String)selectedWord)) {
                        return null;
                    }
                }
                catch (BadLocationException e) {
                    Log.log((Throwable)e);
                    return null;
                }
                ICoreTextSelection textSelection = pyEdit.getTextSelection();
                int line = textSelection.getStartLine();
                ArrayList<SmartStepIntoVariant> found = new ArrayList<SmartStepIntoVariant>();
                Object[] objectArray = stepIntoTargets;
                int n = stepIntoTargets.length;
                int n2 = 0;
                while (n2 < n) {
                    SmartStepIntoVariant smartStepIntoVariant = objectArray[n2];
                    if (line == smartStepIntoVariant.line && selectedWord.equals(smartStepIntoVariant.name)) {
                        found.add(smartStepIntoVariant);
                    }
                    ++n2;
                }
                if (found.size() == 0) {
                    Log.log((String)("Unable to find step into target with name: " + selectedWord + " at line: " + line + "\nAvailable: " + StringUtils.join((String)"; ", (Object[])stepIntoTargets)));
                    return null;
                }
                if (found.size() > 1) {
                    Collections.reverse(found);
                    Iterator iterator = found.iterator();
                    target = (SmartStepIntoVariant)iterator.next();
                    TextSelectionUtils ts = new TextSelectionUtils(document, textSelection);
                    String lineContents = ts.getLine(line);
                    List wordOffsets = StringUtils.findWordOffsets((String)lineContents, (String)selectedWord);
                    if (wordOffsets.size() > 0) {
                        int offsetInLine = wordRegion.getOffset() - ts.getStartLineOffset();
                        for (Integer i : wordOffsets) {
                            if (i < offsetInLine) {
                                target = (SmartStepIntoVariant)iterator.next();
                                if (iterator.hasNext()) {
                                    continue;
                                }
                            }
                            break;
                        }
                    }
                } else {
                    target = (SmartStepIntoVariant)found.get(0);
                }
                return new IHyperlink[]{new StepIntoSelectionHyperlink((PyStackFrame)debugContext, pyEdit, wordRegion, line, selectedWord, target)};
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return null;
            }
        }
        return null;
    }

    class StepIntoSelectionHyperlink
    implements IHyperlink {
        private final IRegion fSelection;
        private final PyEdit pyEdit;
        private final String selectedWord;
        private final PyStackFrame debugContext;
        private final int line;
        private final SmartStepIntoVariant target;

        public StepIntoSelectionHyperlink(PyStackFrame debugContext, PyEdit pyEdit, IRegion selection, int line, String selectedWord, SmartStepIntoVariant target) {
            this.debugContext = debugContext;
            this.pyEdit = pyEdit;
            this.line = line;
            this.selectedWord = selectedWord;
            this.fSelection = selection;
            this.target = target;
        }

        public IRegion getHyperlinkRegion() {
            return new Region(this.fSelection.getOffset(), this.fSelection.getLength());
        }

        public String getHyperlinkText() {
            return "Step Into Selection";
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            try {
                this.debugContext.stepIntoTarget(this.pyEdit, this.line, this.selectedWord, this.target);
            }
            catch (DebugException e) {
                Log.log((Throwable)e);
            }
        }
    }
}

