/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.internal.console.IOConsolePartition;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;
import org.python.pydev.ast.location.FindWorkspaceFiles;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.debug.core.IConsoleInputListener;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.curr_exception.CurrentExceptionView;
import org.python.pydev.debug.model.AbstractDebugTargetWithTransmission;
import org.python.pydev.debug.model.AdapterDebug;
import org.python.pydev.debug.model.CaughtException;
import org.python.pydev.debug.model.IExceptionsBreakpointListener;
import org.python.pydev.debug.model.IPropertyTraceListener;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.model.PyConditionalBreakPointManager;
import org.python.pydev.debug.model.PyDebugModelPresentation;
import org.python.pydev.debug.model.PyRunToLineTarget;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.debug.model.remote.AddIgnoreThrownExceptionIn;
import org.python.pydev.debug.model.remote.RemoveBreakpointCommand;
import org.python.pydev.debug.model.remote.RunCommand;
import org.python.pydev.debug.model.remote.SendPathMappingsCommand;
import org.python.pydev.debug.model.remote.SendPyExceptionCommand;
import org.python.pydev.debug.model.remote.SetBreakpointCommand;
import org.python.pydev.debug.model.remote.SetDjangoExceptionBreakpointCommand;
import org.python.pydev.debug.model.remote.SetDontTraceEnabledCommand;
import org.python.pydev.debug.model.remote.SetJinja2ExceptionBreakpointCommand;
import org.python.pydev.debug.model.remote.SetPropertyTraceCommand;
import org.python.pydev.debug.model.remote.SetShowReturnValuesEnabledCommand;
import org.python.pydev.debug.model.remote.ThreadListCommand;
import org.python.pydev.debug.model.remote.VersionCommand;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public abstract class AbstractDebugTarget
extends AbstractDebugTargetWithTransmission
implements IDebugTarget,
ILaunchListener,
IExceptionsBreakpointListener,
IPropertyTraceListener {
    private static final boolean DEBUG = false;
    protected final IPath[] file;
    protected PyThread[] threads;
    protected boolean disconnected = false;
    protected AbstractRemoteDebugger debugger;
    protected ILaunch launch;
    private PyRunToLineTarget runToLineTarget;
    private Set<Integer> currentBreakpointsAdded = new HashSet<Integer>();
    private Object currExceptionsLock = new Object();
    private List<CaughtException> currExceptions = new ArrayList<CaughtException>();
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("DONT_TRACE_ENABLED")) {
                AbstractDebugTarget.this.sendDontTraceEnabledCommand();
            } else if (property.equals("SHOW_RETURN_VALUES")) {
                AbstractDebugTarget.this.sendShowReturnValuesEnabledCommand();
            } else if (property.equals("TRACE_DJANGO_TEMPLATE_RENDER_EXCEPTIONS")) {
                AbstractDebugTarget.this.sendSetDjangoExceptionBreakpointCommand();
            } else if (property.equals("TRACE_JINJA2_TEMPLATE_RENDER_EXCEPTIONS")) {
                AbstractDebugTarget.this.sendSetJinja2ExceptionBreakpointCommand();
            } else if (property.equals("PATH_MAPPINGS") || property.equals("DEBUG_PATH_MAPPINGS")) {
                AbstractDebugTarget.this.sendPathMappingsCommand(true);
            }
        }
    };
    private IFile resourceAdapter;
    private final Set<IPath> filesLoadedFromDebugger = new HashSet<IPath>();

    public AbstractDebugTarget(IPath[] file) {
        this.file = file;
    }

    public abstract boolean canTerminate();

    public abstract boolean isTerminated();

    public void terminate() {
        IPreferenceStore preferenceStore;
        PydevPlugin plugin = PydevPlugin.getDefault();
        if (plugin != null && (preferenceStore = plugin.getPreferenceStore()) != null) {
            preferenceStore.removePropertyChangeListener(this.listener);
        }
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
        this.disconnected = true;
        if (this.writer != null) {
            this.writer.done();
            this.writer = null;
        }
        if (this.reader != null) {
            this.reader.done();
            this.reader = null;
        }
        this.threads = new PyThread[0];
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public AbstractRemoteDebugger getDebugger() {
        return this.debugger;
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public String getModelIdentifier() {
        return PyDebugModelPresentation.PY_DEBUG_MODEL_ID;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public String getName() throws DebugException {
        if (this.file != null) {
            return PythonRunnerConfig.getRunningName(this.file);
        }
        return "unknown";
    }

    public boolean canResume() {
        int i = 0;
        while (i < this.threads.length) {
            if (this.threads[i].canResume()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canSuspend() {
        int i = 0;
        while (i < this.threads.length) {
            if (this.threads[i].canSuspend()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
        int i = 0;
        while (i < this.threads.length) {
            this.threads[i].resume();
            ++i;
        }
    }

    public void suspend() throws DebugException {
        int i = 0;
        while (i < this.threads.length) {
            this.threads[i].suspend();
            ++i;
        }
    }

    public IThread[] getThreads() throws DebugException {
        if (this.debugger == null) {
            return new IThread[0];
        }
        if (this.threads == null) {
            ThreadListCommand cmd = new ThreadListCommand(this);
            this.postCommand(cmd);
            try {
                cmd.waitUntilDone(1000);
                this.threads = cmd.getThreads();
            }
            catch (InterruptedException e) {
                this.threads = new PyThread[0];
            }
        }
        if (this.threads == null) {
            return new IThread[0];
        }
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    @Override
    public void onSetConfiguredExceptions() {
        SendPyExceptionCommand sendCmd = new SendPyExceptionCommand(this);
        this.postCommand(sendCmd);
    }

    @Override
    public void onUpdateIgnoreThrownExceptions() {
        AddIgnoreThrownExceptionIn cmd = new AddIgnoreThrownExceptionIn(this);
        this.postCommand(cmd);
    }

    @Override
    public void onAddIgnoreThrownExceptionIn(File file, int lineNumber) {
        AddIgnoreThrownExceptionIn cmd = new AddIgnoreThrownExceptionIn(this, file, lineNumber);
        this.postCommand(cmd);
    }

    @Override
    public void onSetPropertyTraceConfiguration() {
        SetPropertyTraceCommand sendCmd = new SetPropertyTraceCommand(this);
        this.postCommand(sendCmd);
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof PyBreakpoint;
    }

    private boolean shouldSkipBreakpoints() {
        DebugPlugin manager = DebugPlugin.getDefault();
        return manager != null && !manager.getBreakpointManager().isEnabled();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        try {
            PyBreakpoint b;
            if (breakpoint instanceof PyBreakpoint && (b = (PyBreakpoint)breakpoint).isEnabled() && !this.shouldSkipBreakpoints()) {
                String condition = null;
                if (b.isConditionEnabled() && (condition = b.getCondition()) != null) {
                    condition = StringUtils.replaceAll((String)condition, (String)"\n", (String)"@_@NEW_LINE_CHAR@_@");
                    condition = StringUtils.replaceAll((String)condition, (String)"\t", (String)"@_@TAB_CHAR@_@");
                }
                String file2 = b.getFile();
                Object line = b.getLine();
                if (file2 == null || line == null) {
                    Log.log((String)("Trying to add breakpoint with invalid file: " + file2 + " or line: " + line));
                } else {
                    this.currentBreakpointsAdded.add(b.breakpointId);
                    SetBreakpointCommand cmd = new SetBreakpointCommand(this, b.breakpointId, file2, line, condition, b.getFunctionName(), b.getType());
                    this.postCommand(cmd);
                }
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof PyBreakpoint) {
            PyBreakpoint b = (PyBreakpoint)breakpoint;
            if (this.currentBreakpointsAdded.contains(b.breakpointId)) {
                this.currentBreakpointsAdded.remove(b.breakpointId);
                RemoveBreakpointCommand cmd = new RemoveBreakpointCommand(this, b.breakpointId, b.getFile(), b.getType());
                this.postCommand(cmd);
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof PyBreakpoint) {
            this.breakpointRemoved(breakpoint, null);
            this.breakpointAdded(breakpoint);
        }
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void processCommand(String sCmdCode, String sSeqCode, String payload) {
        try {
            int cmdCode = Integer.parseInt(sCmdCode);
            if (cmdCode == 103) {
                this.processThreadCreated(payload);
            } else if (cmdCode == 104) {
                this.processThreadKilled(payload);
            } else if (cmdCode == 105) {
                this.processThreadSuspended(payload);
            } else if (cmdCode == 106) {
                this.processThreadRun(payload);
            } else if (cmdCode == 136) {
                this.processBreakpointException(payload);
            } else if (cmdCode == 138) {
                this.processCaughtExceptionTraceSent(payload);
            } else if (cmdCode == 139) {
                this.processCaughtExceptionTraceProceededSent(payload);
            } else if (cmdCode == 147) {
                if ("true".equalsIgnoreCase(payload.trim())) {
                    this.setWaitingForInput(true);
                } else if ("false".equalsIgnoreCase(payload.trim())) {
                    this.setWaitingForInput(false);
                } else {
                    PydevDebugPlugin.log(2, "Unexpected payload for CMD_INPUT_REQUESTED\npayload:" + payload, null);
                }
            } else if (cmdCode != 503 && cmdCode != 119 && cmdCode != 149 && cmdCode != 127 && cmdCode != 502 && cmdCode != 129) {
                PydevDebugPlugin.log(2, "Unexpected debugger command:" + sCmdCode + "\nseq:" + sSeqCode + "\npayload:" + payload, null);
            }
        }
        catch (Exception e) {
            PydevDebugPlugin.log(4, "Error processing: " + sCmdCode + "\npayload: " + payload, e);
        }
    }

    public void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected PyThread findThreadByID(String thread_id) {
        PyThread[] pyThreadArray = this.threads;
        int n = this.threads.length;
        int n2 = 0;
        while (n2 < n) {
            PyThread thread = pyThreadArray[n2];
            if (thread_id.equals(thread.getId())) {
                return thread;
            }
            ++n2;
        }
        return null;
    }

    private void processThreadCreated(String payload) {
        PyThread[] newThreads;
        try {
            newThreads = XMLUtils.ThreadsFromXML(this, payload);
        }
        catch (CoreException e) {
            PydevDebugPlugin.errorDialog("Error in processThreadCreated", e);
            return;
        }
        if (PydevDebugPlugin.getDefault().getPreferenceStore().getBoolean("HIDE_PYDEVD_THREADS")) {
            int removeThisMany = 0;
            int i = 0;
            while (i < newThreads.length) {
                if (newThreads[i].isPydevThread()) {
                    ++removeThisMany;
                }
                ++i;
            }
            if (removeThisMany > 0) {
                int newSize = newThreads.length - removeThisMany;
                if (newSize == 0) {
                    return;
                }
                PyThread[] newnewThreads = new PyThread[newSize];
                int i2 = 0;
                PyThread[] pyThreadArray = newThreads;
                int n = newThreads.length;
                int n2 = 0;
                while (n2 < n) {
                    PyThread newThread = pyThreadArray[n2];
                    if (!newThread.isPydevThread()) {
                        newnewThreads[i2] = newThread;
                        ++i2;
                    }
                    ++n2;
                }
                newThreads = newnewThreads;
            }
        }
        this.threads = this.threads == null ? newThreads : (PyThread[])ArrayUtils.concatArrays((Object[][])new PyThread[][]{this.threads, newThreads});
        int i = 0;
        while (i < newThreads.length) {
            this.fireEvent(new DebugEvent((Object)newThreads[i], 4));
            ++i;
        }
    }

    private void processThreadKilled(String thread_id) {
        PyThread threadToDelete = this.findThreadByID(thread_id);
        if (threadToDelete != null) {
            int j = 0;
            PyThread[] newThreads = new PyThread[this.threads.length - 1];
            int i = 0;
            while (i < this.threads.length) {
                if (this.threads[i] != threadToDelete) {
                    newThreads[j++] = this.threads[i];
                }
                ++i;
            }
            this.threads = newThreads;
            this.fireEvent(new DebugEvent((Object)threadToDelete, 8));
        }
    }

    private void processThreadSuspended(String payload) {
        XMLUtils.StoppedStack threadNstack;
        try {
            threadNstack = XMLUtils.XMLToStack(this, payload);
        }
        catch (CoreException e) {
            PydevDebugPlugin.errorDialog("Error reading ThreadSuspended", e);
            return;
        }
        PyThread t = threadNstack.thread;
        int reason = 0;
        String stopReason = threadNstack.stopReason;
        if (stopReason != null) {
            int stopReason_i = Integer.parseInt(stopReason);
            if (stopReason_i == 108 || stopReason_i == 107 || stopReason_i == 137 || stopReason_i == 109 || stopReason_i == 118 || stopReason_i == 127 || stopReason_i == 128) {
                reason = 8;
            } else if (stopReason_i == 105) {
                reason = 32;
            } else if (stopReason_i == 111) {
                reason = 16;
            } else if (stopReason_i == 122) {
                reason = 16;
            } else {
                PydevDebugPlugin.log(4, "Unexpected reason for suspension: " + stopReason_i, null);
                reason = 0;
            }
        }
        if (t != null) {
            IStackFrame[] stackFrame = threadNstack.stack;
            t.setSuspended(true, stackFrame);
            this.fireEvent(new DebugEvent((Object)t, 2, reason));
        }
    }

    public static Tuple<String, String> getThreadIdAndReason(String payload) throws CoreException {
        List split = StringUtils.split((String)payload.trim(), (char)'\t');
        if (split.size() != 2) {
            String msg = "Unexpected threadRun payload " + payload + "(unable to match)";
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, msg, new RuntimeException(msg)));
        }
        return new Tuple((Object)((String)split.get(0)), (Object)((String)split.get(1)));
    }

    private void processThreadRun(String payload) {
        try {
            Tuple<String, String> threadIdAndReason = AbstractDebugTarget.getThreadIdAndReason(payload);
            int resumeReason = 0;
            try {
                int raw_reason = Integer.parseInt((String)threadIdAndReason.o2);
                if (raw_reason == 108) {
                    resumeReason = 2;
                } else if (raw_reason == 109) {
                    resumeReason = 4;
                } else if (raw_reason == 107 || raw_reason == 128 || raw_reason == 137) {
                    resumeReason = 1;
                } else if (raw_reason == 118) {
                    resumeReason = 0;
                } else if (raw_reason == 127) {
                    resumeReason = 0;
                } else if (raw_reason == 106 || raw_reason == -1) {
                    resumeReason = 32;
                } else {
                    PydevDebugPlugin.log(4, "Unexpected resume reason code: " + raw_reason + " payload: " + payload, null);
                    resumeReason = 0;
                }
            }
            catch (NumberFormatException e) {
                resumeReason = 0;
            }
            String threadID = (String)threadIdAndReason.o1;
            PyThread t = this.findThreadByID(threadID);
            if (t != null) {
                t.setSuspended(false, null);
                this.fireEvent(new DebugEvent((Object)t, 1, resumeReason));
            } else {
                FastStringBuffer buf = new FastStringBuffer();
                PyThread[] pyThreadArray = this.threads;
                int n = this.threads.length;
                int n2 = 0;
                while (n2 < n) {
                    PyThread thread = pyThreadArray[n2];
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append("id: " + thread.getId());
                    ++n2;
                }
                String msg = "Unable to find thread: " + threadID + " available: " + buf;
                PydevDebugPlugin.log(4, msg, new RuntimeException(msg));
            }
        }
        catch (CoreException e1) {
            Log.log((Throwable)e1);
        }
    }

    private void processBreakpointException(String payload) {
        PyConditionalBreakPointManager.getInstance().handleBreakpointException(this, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CaughtException> getCurrExceptions() {
        Object object = this.currExceptionsLock;
        synchronized (object) {
            return new ArrayList<CaughtException>(this.currExceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCurrExceptions() {
        Object object = this.currExceptionsLock;
        synchronized (object) {
            return this.currExceptions.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCaughtExceptionTraceProceededSent(String payload) {
        Object object = this.currExceptionsLock;
        synchronized (object) {
            Iterator<CaughtException> it = this.currExceptions.iterator();
            while (it.hasNext()) {
                CaughtException s = it.next();
                if (!payload.equals(s.threadNstack.thread.getId())) continue;
                it.remove();
                break;
            }
        }
        this.updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCaughtExceptionTraceSent(String payload) {
        XMLUtils.StoppedStack threadNstack;
        List split = StringUtils.split((String)payload, (char)'\t', (int)4);
        try {
            threadNstack = XMLUtils.XMLToStack(this, (String)split.get(3));
        }
        catch (CoreException e) {
            PydevDebugPlugin.errorDialog("Error on processCaughtExceptionTraceSent", e);
            return;
        }
        Object object = this.currExceptionsLock;
        synchronized (object) {
            this.currExceptions.add(new CaughtException((String)split.get(0), (String)split.get(1), (String)split.get(2), threadNstack));
        }
        this.updateView();
    }

    private void updateView() {
        RunInUiThread.async((Runnable)new Runnable(){

            @Override
            public void run() {
                CurrentExceptionView view = CurrentExceptionView.getView(true);
                view.update();
            }
        });
    }

    public void initialize() {
        this.postCommand(new VersionCommand(this));
        this.sendPathMappingsCommand(false);
        this.addBreakpointsFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        this.onSetConfiguredExceptions();
        this.onSetPropertyTraceConfiguration();
        this.onUpdateIgnoreThrownExceptions();
        this.sendSetDjangoExceptionBreakpointCommand();
        this.sendSetJinja2ExceptionBreakpointCommand();
        this.sendDontTraceEnabledCommand();
        this.sendShowReturnValuesEnabledCommand();
        IPreferenceStore pyPrefsStore = PydevPlugin.getDefault().getPreferenceStore();
        pyPrefsStore.addPropertyChangeListener(this.listener);
        RunCommand run = new RunCommand(this);
        this.postCommand(run);
    }

    private void sendDontTraceEnabledCommand() {
        IPreferenceStore pyPrefsStore = PydevPlugin.getDefault().getPreferenceStore();
        SetDontTraceEnabledCommand cmd = new SetDontTraceEnabledCommand(this, pyPrefsStore.getBoolean("DONT_TRACE_ENABLED"));
        this.postCommand(cmd);
    }

    private void sendPathMappingsCommand(boolean force) {
        IEclipsePreferences eclipsePreferences = PydevPrefs.getEclipsePreferences();
        String pathMappingsRaw = eclipsePreferences.get("PATH_MAPPINGS", "");
        boolean debugPathMappings = eclipsePreferences.getBoolean("DEBUG_PATH_MAPPINGS", false);
        SendPathMappingsCommand cmd = new SendPathMappingsCommand(this, pathMappingsRaw, debugPathMappings, force);
        this.postCommand(cmd);
    }

    private void sendShowReturnValuesEnabledCommand() {
        IPreferenceStore pyPrefsStore = PydevPlugin.getDefault().getPreferenceStore();
        SetShowReturnValuesEnabledCommand cmd = new SetShowReturnValuesEnabledCommand(this, pyPrefsStore.getBoolean("SHOW_RETURN_VALUES"));
        this.postCommand(cmd);
    }

    private void sendSetDjangoExceptionBreakpointCommand() {
        IPreferenceStore pyPrefsStore = PydevPlugin.getDefault().getPreferenceStore();
        SetDjangoExceptionBreakpointCommand cmd = new SetDjangoExceptionBreakpointCommand(this, pyPrefsStore.getBoolean("TRACE_DJANGO_TEMPLATE_RENDER_EXCEPTIONS"));
        this.postCommand(cmd);
    }

    private void sendSetJinja2ExceptionBreakpointCommand() {
        IPreferenceStore pyPrefsStore = PydevPlugin.getDefault().getPreferenceStore();
        SetJinja2ExceptionBreakpointCommand cmd = new SetJinja2ExceptionBreakpointCommand(this, pyPrefsStore.getBoolean("TRACE_JINJA2_TEMPLATE_RENDER_EXCEPTIONS"));
        this.postCommand(cmd);
    }

    private void addBreakpointsFor(IContainer container) {
        try {
            PyBreakpoint brk;
            IMarker marker;
            IMarker[] markers = container.findMarkers("org.python.pydev.debug.pyStopBreakpointMarker", true, 2);
            IMarker[] condMarkers = container.findMarkers("org.python.pydev.debug.pyConditionalStopBreakpointMarker", true, 2);
            IMarker[] djangoMarkers = container.findMarkers("org.python.pydev.debug.djangoStopBreakpointMarker", true, 2);
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                brk = (PyBreakpoint)breakpointManager.getBreakpoint(marker);
                this.breakpointAdded((IBreakpoint)brk);
                ++n2;
            }
            iMarkerArray = condMarkers;
            n = condMarkers.length;
            n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                brk = (PyBreakpoint)breakpointManager.getBreakpoint(marker);
                this.breakpointAdded((IBreakpoint)brk);
                ++n2;
            }
            iMarkerArray = djangoMarkers;
            n = djangoMarkers.length;
            n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                brk = (PyBreakpoint)breakpointManager.getBreakpoint(marker);
                this.breakpointAdded((IBreakpoint)brk);
                ++n2;
            }
        }
        catch (Throwable t) {
            PydevDebugPlugin.errorDialog("Error setting breakpoints", t);
        }
    }

    public void addConsoleInputListener() {
        IConsole console = DebugUITools.getConsole((IProcess)this.getProcess());
        if (console instanceof ProcessConsole) {
            ProcessConsole c = (ProcessConsole)console;
            final List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.debug.pydev_debug_console_input_listener");
            final AbstractDebugTarget target = this;
            target.addProcessConsole((IOConsole)c);
            c.getDocument().addDocumentListener(new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                    if (target.isWaitingForInput()) {
                        return;
                    }
                    if (event.fText.indexOf(13) != -1 || event.fText.indexOf(10) != -1) {
                        try {
                            IOConsolePartition p;
                            ITypedRegion partition = event.fDocument.getPartition(event.fOffset);
                            if (partition instanceof IOConsolePartition && (p = (IOConsolePartition)partition).getType().equals(IOConsolePartition.INPUT_PARTITION_TYPE) && event.fText.length() <= 2) {
                                String inputFound = event.getDocument().get(p.getOffset(), p.getLength());
                                for (IConsoleInputListener listener : participants) {
                                    listener.newLineReceived(inputFound, target);
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                }

                public void documentChanged(DocumentEvent event) {
                    if (target.isWaitingForInput()) {
                        return;
                    }
                    if (event.fText.indexOf(13) != -1 || event.fText.indexOf(10) != -1) {
                        try {
                            IOConsolePartition p;
                            ITypedRegion partition = event.fDocument.getPartition(event.fOffset);
                            if (partition instanceof IOConsolePartition && (p = (IOConsolePartition)partition).getType().equals(IOConsolePartition.INPUT_PARTITION_TYPE) && event.fText.length() > 2) {
                                for (IConsoleInputListener listener : participants) {
                                    listener.pasteReceived(event.fText, target);
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public boolean canDisconnect() {
        return !this.disconnected;
    }

    public void disconnect() throws DebugException {
        this.terminate();
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public <T> T getAdapter(Class<T> adapter) {
        AdapterDebug.print(this, adapter);
        if (adapter.equals(ILaunch.class)) {
            return (T)this.launch;
        }
        if (adapter.equals(IResource.class)) {
            if (this.resourceAdapter != null) {
                return (T)this.resourceAdapter;
            }
            if (this.file != null && this.file.length > 0) {
                this.resourceAdapter = FindWorkspaceFiles.getFileForLocation((IPath)this.file[0], null);
                return (T)this.resourceAdapter;
            }
            return null;
        }
        if (adapter.equals(IRunToLineTarget.class)) {
            return (T)this.getRunToLineTarget();
        }
        if (adapter.equals(IPropertySource.class)) {
            return (T)this.launch.getAdapter(adapter);
        }
        if (adapter.equals(ITaskListResourceAdapter.class) || adapter.equals(IToggleBreakpointsTarget.class)) {
            return (T)super.getAdapter(adapter);
        }
        AdapterDebug.printDontKnow(this, adapter);
        return (T)super.getAdapter(adapter);
    }

    public PyRunToLineTarget getRunToLineTarget() {
        if (this.runToLineTarget == null) {
            this.runToLineTarget = new PyRunToLineTarget();
        }
        return this.runToLineTarget;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean isFileLoadedFromDebugger(IPath path) {
        return this.filesLoadedFromDebugger.contains(path);
    }

    public void setFileLoadedFromDebugger(IPath path) {
        this.filesLoadedFromDebugger.add(path);
    }
}

