/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.lang.ref.WeakReference;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.IVariablesContainerParent;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.VariablesLoader;
import org.python.pydev.debug.model.remote.GetVariableCommand;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class ContainerOfVariables {
    private volatile IVariable[] variables;
    private WeakReference<IVariablesContainerParent> parent;
    private volatile boolean onAskGetNewVars = true;
    private static final Object lock = new Object();
    private volatile boolean gettingInitialVariables = false;
    private final VariablesLoader variablesLoader;

    public IVariable[] getInternalVariables() {
        return this.variables;
    }

    public ContainerOfVariables(IVariablesContainerParent parent, boolean addGlobalsVarible) {
        this.parent = new WeakReference<IVariablesContainerParent>(parent);
        this.variablesLoader = new VariablesLoader(this, addGlobalsVarible);
    }

    PyVariable[] setVariables(PyVariable[] newVars) {
        IVariable[] oldVars = this.variables;
        if (newVars == oldVars) {
            return newVars;
        }
        IVariablesContainerParent p = (IVariablesContainerParent)this.parent.get();
        if (p == null) {
            return newVars;
        }
        this.variables = newVars;
        AbstractDebugTarget target = p.getTarget();
        if (!this.gettingInitialVariables && target != null) {
            RunInUiThread.async(() -> target.fireEvent(new DebugEvent((Object)p, 16, 512)));
        }
        return newVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVariable[] getVariables() throws DebugException {
        if (this.onAskGetNewVars) {
            Object object = lock;
            synchronized (object) {
                if (this.onAskGetNewVars) {
                    this.gettingInitialVariables = true;
                    try {
                        PyVariable[] vars = this.variablesLoader.fetchVariables();
                        this.setVariables(vars);
                        this.onAskGetNewVars = false;
                    }
                    finally {
                        this.gettingInitialVariables = false;
                    }
                }
            }
        }
        return this.variables;
    }

    public void forceGetNewVariables() {
        this.onAskGetNewVars = true;
        IVariablesContainerParent p = (IVariablesContainerParent)this.parent.get();
        if (p == null) {
            return;
        }
        AbstractDebugTarget target = p.getTarget();
        if (target != null) {
            RunInUiThread.async(() -> target.fireEvent(new DebugEvent((Object)p, 16, 0)));
        }
    }

    public AbstractDebugTarget getTarget() {
        IVariablesContainerParent p = (IVariablesContainerParent)this.parent.get();
        if (p == null) {
            return null;
        }
        return p.getTarget();
    }

    public IVariableLocator getLocator() {
        IVariablesContainerParent p = (IVariablesContainerParent)this.parent.get();
        if (p == null) {
            return null;
        }
        return p;
    }

    public GetVariableCommand getVariableCommand(AbstractDebugTarget target) {
        IVariablesContainerParent p = (IVariablesContainerParent)this.parent.get();
        if (p == null) {
            return null;
        }
        return p.getVariableCommand(target);
    }

    public IVariableLocator getGlobalLocator() {
        IVariablesContainerParent p = (IVariablesContainerParent)this.parent.get();
        if (p == null) {
            return null;
        }
        return p.getGlobalLocator();
    }
}

