/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.ConfigureExceptionsFileUtils;
import org.python.pydev.debug.model.IExceptionsBreakpointListener;
import org.python.pydev.debug.model.PyExceptionBreakPointManager;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class IgnoreCaughtExceptionsWhenThrownFrom {
    private PyExceptionBreakPointManager manager;
    private static final String IGNORE_EXCEPTIONS_FILE_NAME = "ignore_exceptions.prefs";

    IgnoreCaughtExceptionsWhenThrownFrom(PyExceptionBreakPointManager manager) {
        this.manager = manager;
    }

    public void updateIgnoreThrownExceptions() {
        IExceptionsBreakpointListener[] iExceptionsBreakpointListenerArray = (IExceptionsBreakpointListener[])this.manager.listeners.getListeners();
        int n = iExceptionsBreakpointListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExceptionsBreakpointListener listener = iExceptionsBreakpointListenerArray[n2];
            listener.onUpdateIgnoreThrownExceptions();
            ++n2;
        }
    }

    public IPath getIgnoreThrownExceptionsPath() {
        return ConfigureExceptionsFileUtils.getFilePathFromMetadata(IGNORE_EXCEPTIONS_FILE_NAME);
    }

    public Collection<IgnoredExceptionInfo> getIgnoreThrownExceptionsForEdition() {
        String metadataFile = ConfigureExceptionsFileUtils.readFromMetadataFile(IGNORE_EXCEPTIONS_FILE_NAME);
        List lines = StringUtils.splitInLines((String)metadataFile, (boolean)false);
        TreeSet linesAsSet = new TreeSet(lines);
        ArrayList<IgnoredExceptionInfo> ret = new ArrayList<IgnoredExceptionInfo>(linesAsSet.size());
        for (String s : linesAsSet) {
            try {
                ret.add(new IgnoredExceptionInfo(s));
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return ret;
    }

    public Collection<String> getIgnoreThrownExceptions() {
        TreeSet<String> set = new TreeSet<String>();
        String metadataFile = ConfigureExceptionsFileUtils.readFromMetadataFile(IGNORE_EXCEPTIONS_FILE_NAME);
        List lines = StringUtils.splitInLines((String)metadataFile, (boolean)false);
        TreeSet linesAsSet = new TreeSet(lines);
        FastStringBuffer temp = new FastStringBuffer();
        Iterator it = linesAsSet.iterator();
        while (it.hasNext()) {
            int line;
            String s = ((String)it.next()).trim();
            if (s.length() == 0) {
                it.remove();
                continue;
            }
            if (StringUtils.count((String)s, (char)'|') < 2) {
                Log.log((String)("Unexpected line in thrown exceptions file: " + s));
                continue;
            }
            List split = StringUtils.split((String)s, (char)'|');
            String file = (String)split.get(0);
            try {
                line = Integer.parseInt((String)split.get(1));
            }
            catch (NumberFormatException e) {
                Log.log((String)("Unexpected line number in thrown exceptions file: " + s));
                continue;
            }
            temp.clear().append(file).append('|').append(line);
            String string = temp.toString();
            set.add(string);
        }
        if (linesAsSet.size() != lines.size()) {
            ConfigureExceptionsFileUtils.writeToFile(IGNORE_EXCEPTIONS_FILE_NAME, String.valueOf(StringUtils.join((String)"\n", linesAsSet)) + "\n", false);
        }
        return set;
    }

    public void addIgnoreThrownExceptionIn(File file, int lineNumber) {
        String line;
        boolean isAppend = false;
        IPath path = ConfigureExceptionsFileUtils.getFilePathFromMetadata(IGNORE_EXCEPTIONS_FILE_NAME);
        if (path.toFile().exists()) {
            isAppend = true;
        }
        String fileAbsolutePath = FileUtils.getFileAbsolutePath((File)file);
        try {
            line = FileUtils.getLineFromFile((File)file, (int)lineNumber);
        }
        catch (Exception e) {
            Log.log((String)StringUtils.format((String)"Unable to ignore thrown exception in file: %s, line: %s", (Object[])new Object[]{file, lineNumber}), (Throwable)e);
            return;
        }
        FastStringBuffer buf = new FastStringBuffer(fileAbsolutePath, 20 + line.length());
        buf.append('|').append(lineNumber).append('|').append(line).append('\n');
        ConfigureExceptionsFileUtils.writeToFile(IGNORE_EXCEPTIONS_FILE_NAME, buf.toString(), isAppend);
        IExceptionsBreakpointListener[] iExceptionsBreakpointListenerArray = (IExceptionsBreakpointListener[])this.manager.listeners.getListeners();
        int n = iExceptionsBreakpointListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExceptionsBreakpointListener listener = iExceptionsBreakpointListenerArray[n2];
            listener.onAddIgnoreThrownExceptionIn(file, lineNumber);
            ++n2;
        }
    }

    public static class IgnoredExceptionInfo {
        public final String filename;
        public final int line;
        public final String contents;

        public IgnoredExceptionInfo(String s) {
            List split = StringUtils.split((String)s, (char)'|', (int)3);
            this.filename = (String)split.get(0);
            this.line = Integer.parseInt((String)split.get(1));
            this.contents = split.size() > 2 ? (String)split.get(2) : "";
        }
    }
}

