/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.python.pydev.ast.interpreter_managers.ChooseInterpreterManager;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.TokensList;
import org.python.pydev.debug.core.ConfigureExceptionsFileUtils;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.IExceptionsBreakpointListener;
import org.python.pydev.debug.model.IgnoreCaughtExceptionsWhenThrownFrom;
import org.python.pydev.shared_core.callbacks.ListenerList;
import org.python.pydev.shared_core.string.StringUtils;

public class PyExceptionBreakPointManager {
    private static final String EXCEPTION_FILE_NAME = "python_exceptions.prefs";
    private static final String CUSTOM_EXCEPTION_FILE_NAME = "custom_exceptions.prefs";
    private static final String BREAK_ON_CAUGHT_EXCEPTION = "caught_exception_state.prefs";
    private static final String BREAK_ON_UNCAUGHT_EXCEPTION = "uncaught_exception_state.prefs";
    private static final String BREAK_ON_USER_UNCAUGHT_EXCEPTION = "user_uncaught_exception_state.prefs";
    private static PyExceptionBreakPointManager pyExceptionBreakPointManager;
    private static final Object lock;
    ListenerList<IExceptionsBreakpointListener> listeners = new ListenerList(IExceptionsBreakpointListener.class);
    public final IgnoreCaughtExceptionsWhenThrownFrom ignoreCaughtExceptionsWhenThrownFrom = new IgnoreCaughtExceptionsWhenThrownFrom(this);

    static {
        lock = new Object();
    }

    private PyExceptionBreakPointManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyExceptionBreakPointManager getInstance() {
        if (pyExceptionBreakPointManager == null) {
            Object object = lock;
            synchronized (object) {
                if (pyExceptionBreakPointManager == null) {
                    pyExceptionBreakPointManager = new PyExceptionBreakPointManager();
                }
            }
        }
        return pyExceptionBreakPointManager;
    }

    public void addListener(IExceptionsBreakpointListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IExceptionsBreakpointListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setBreakOn(boolean breakOnCaught, boolean breakOnUncaught, boolean breakOnUserUncaught, String[] exceptionArray) {
        ConfigureExceptionsFileUtils.writeToFile(BREAK_ON_CAUGHT_EXCEPTION, Boolean.toString(breakOnCaught), false);
        ConfigureExceptionsFileUtils.writeToFile(BREAK_ON_UNCAUGHT_EXCEPTION, Boolean.toString(breakOnUncaught), false);
        ConfigureExceptionsFileUtils.writeToFile(BREAK_ON_USER_UNCAUGHT_EXCEPTION, Boolean.toString(breakOnUserUncaught), false);
        String pyExceptionsStr = StringUtils.join((String)ConfigureExceptionsFileUtils.DELIMITER, (String[])exceptionArray);
        ConfigureExceptionsFileUtils.writeToFile(EXCEPTION_FILE_NAME, pyExceptionsStr, false);
        IExceptionsBreakpointListener[] iExceptionsBreakpointListenerArray = (IExceptionsBreakpointListener[])this.listeners.getListeners();
        int n = iExceptionsBreakpointListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExceptionsBreakpointListener listener = iExceptionsBreakpointListenerArray[n2];
            listener.onSetConfiguredExceptions();
            ++n2;
        }
    }

    public void addUserConfiguredException(String userConfiguredException) {
        boolean isAppend = false;
        IPath path = ConfigureExceptionsFileUtils.getFilePathFromMetadata(CUSTOM_EXCEPTION_FILE_NAME);
        if (path.toFile().exists()) {
            isAppend = true;
            userConfiguredException = String.valueOf(ConfigureExceptionsFileUtils.DELIMITER) + userConfiguredException;
        }
        ConfigureExceptionsFileUtils.writeToFile(CUSTOM_EXCEPTION_FILE_NAME, userConfiguredException, isAppend);
    }

    public boolean getBreakOnUserUncaughtExceptions() {
        String breakOnUncaught = ConfigureExceptionsFileUtils.readFromMetadataFile(BREAK_ON_USER_UNCAUGHT_EXCEPTION);
        if (breakOnUncaught.length() > 0) {
            return Boolean.parseBoolean(breakOnUncaught);
        }
        return false;
    }

    public boolean getBreakOnUncaughtExceptions() {
        String breakOnUncaught = ConfigureExceptionsFileUtils.readFromMetadataFile(BREAK_ON_UNCAUGHT_EXCEPTION);
        if (breakOnUncaught.length() > 0) {
            return Boolean.parseBoolean(breakOnUncaught);
        }
        return false;
    }

    public boolean getBreakOnCaughtExceptions() {
        String breakOnCaught = ConfigureExceptionsFileUtils.readFromMetadataFile(BREAK_ON_CAUGHT_EXCEPTION);
        if (breakOnCaught.length() > 0) {
            return Boolean.parseBoolean(breakOnCaught);
        }
        return false;
    }

    public String getExceptionsString() {
        return ConfigureExceptionsFileUtils.readFromMetadataFile(EXCEPTION_FILE_NAME);
    }

    public List<String> getExceptionsList() {
        return ConfigureExceptionsFileUtils.getConfiguredExceptions(EXCEPTION_FILE_NAME);
    }

    public List<String> getUserConfiguredExceptions() {
        List<String> configuredExceptions = ConfigureExceptionsFileUtils.getConfiguredExceptions(CUSTOM_EXCEPTION_FILE_NAME);
        Collections.sort(configuredExceptions);
        return configuredExceptions;
    }

    public List<String> getBuiltinExceptions(IModuleRequestState moduleRequest) {
        ArrayList<String> list = new ArrayList<String>();
        IInterpreterManager useManager = ChooseInterpreterManager.chooseInterpreterManager();
        if (useManager != null) {
            TokensList pythonTokens = useManager.getBuiltinMod("Default", moduleRequest).getGlobalTokens();
            for (IterTokenEntry entry : pythonTokens) {
                IToken token = entry.getToken();
                String pyToken = token.getRepresentation();
                String lower = pyToken.toLowerCase();
                if (!lower.contains("error") && !lower.contains("exception") && !lower.contains("warning")) continue;
                list.add(pyToken.trim());
            }
            Collections.sort(list);
        }
        return list;
    }

    public boolean getSkipCaughtExceptionsInLibraries() {
        return PydevDebugPlugin.getDefault().getPreferenceStore().getBoolean("SKIP_CAUGHT_EXCEPTIONS_IN_LIBRARIES");
    }

    public void setSkipCaughtExceptionsInLibraries(boolean b) {
        PydevDebugPlugin.getDefault().getPreferenceStore().setValue("SKIP_CAUGHT_EXCEPTIONS_IN_LIBRARIES", b);
    }

    public boolean getSkipCaughtExceptionsInSameFunction() {
        return PydevDebugPlugin.getDefault().getPreferenceStore().getBoolean("SKIP_CAUGHT_EXCEPTIONS_IN_SAME_FUNCTION");
    }

    public void setSkipCaughtExceptionsInSameFunction(boolean b) {
        PydevDebugPlugin.getDefault().getPreferenceStore().setValue("SKIP_CAUGHT_EXCEPTIONS_IN_SAME_FUNCTION", b);
    }

    public boolean getIgnoreExceptionsThrownInLinesWithIgnoreException() {
        return PydevDebugPlugin.getDefault().getPreferenceStore().getBoolean("IGNORE_EXCEPTIONS_THROWN_IN_LINES_WITH_IGNORE_EXCEPTION");
    }

    public void setIgnoreExceptionsThrownInLinesWithIgnoreException(boolean b) {
        PydevDebugPlugin.getDefault().getPreferenceStore().setValue("IGNORE_EXCEPTIONS_THROWN_IN_LINES_WITH_IGNORE_EXCEPTION", b);
    }
}

