/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.io.File;
import java.util.List;
import java.util.ListResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.remote.ReloadCodeCommand;
import org.python.pydev.debug.ui.DebugPrefsPage;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.editor.IPyEditListener;

public class PyReloadCode
implements IPyEditListener {
    public void onCreateActions(ListResourceBundle resources, BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onDispose(BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onSave(BaseEditor baseEditor, IProgressMonitor monitor) {
        ICallback<Boolean, IDebugTarget> callbackThatFilters;
        List filter;
        Object[] debugTargets;
        if (!DebugPrefsPage.getReloadModuleOnChange()) {
            return;
        }
        PyEdit edit = (PyEdit)baseEditor;
        File file = edit.getEditorFile();
        if (file != null && (debugTargets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets()).length > 0 && (filter = ArrayUtils.filter((Object[])debugTargets, (ICallback)(callbackThatFilters = new ICallback<Boolean, IDebugTarget>(){

            public Boolean call(IDebugTarget arg) {
                return arg instanceof AbstractDebugTarget;
            }
        }))).size() > 0) {
            try {
                String moduleName;
                IPythonNature pythonNature = edit.getPythonNature();
                if (pythonNature != null && (moduleName = pythonNature.resolveModule(file)) != null) {
                    for (IDebugTarget iDebugTarget : filter) {
                        AbstractDebugTarget target = (AbstractDebugTarget)iDebugTarget;
                        target.postCommand(new ReloadCodeCommand(target, moduleName));
                    }
                }
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public void onSetDocument(IDocument document, BaseEditor baseEditor, IProgressMonitor monitor) {
    }
}

