/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.IPyStackFrame;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.AdapterDebug;
import org.python.pydev.debug.model.ContainerOfVariables;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.IVariablesContainerParent;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.SmartStepIntoVariant;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.debug.model.remote.GetFileContentsCommand;
import org.python.pydev.debug.model.remote.GetFrameCommand;
import org.python.pydev.debug.model.remote.GetSmartStepIntoVariants;
import org.python.pydev.debug.model.remote.GetVariableCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editorinput.EditorInputFactory;
import org.python.pydev.editorinput.PySourceLocatorPrefs;
import org.python.pydev.shared_core.cache.LRUMap;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class PyStackFrame
extends PlatformObject
implements IStackFrame,
IVariableLocator,
IPyStackFrame,
IVariablesContainerParent {
    private String name;
    private PyThread thread;
    private String id;
    private IPath path;
    private int line;
    private final ContainerOfVariables variableContainer = new ContainerOfVariables(this, true);
    private IVariableLocator localsLocator;
    private IVariableLocator globalsLocator;
    private IVariableLocator frameLocator;
    private IVariableLocator expressionLocator;
    private AbstractDebugTarget target;
    private boolean currentStackFrame = false;
    private String fileContents = null;
    private IEditorInput editorInput = null;
    private static final LRUMap<File, File> createdInCurrentSession = new LRUMap(200);
    private static final Object lock = new Object();

    public PyStackFrame(PyThread in_thread, String in_id, String name, IPath file, int line, AbstractDebugTarget target) {
        this.id = in_id;
        this.name = name;
        this.path = file;
        this.line = line;
        this.thread = in_thread;
        this.localsLocator = new IVariableLocator(){

            @Override
            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tLOCAL";
            }

            @Override
            public String getThreadId() {
                return PyStackFrame.this.thread.getId();
            }
        };
        this.frameLocator = new IVariableLocator(){

            @Override
            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tFRAME";
            }

            @Override
            public String getThreadId() {
                return PyStackFrame.this.thread.getId();
            }
        };
        this.globalsLocator = new IVariableLocator(){

            @Override
            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tGLOBAL";
            }

            @Override
            public String getThreadId() {
                return PyStackFrame.this.thread.getId();
            }
        };
        this.expressionLocator = new IVariableLocator(){

            @Override
            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tEXPRESSION";
            }

            @Override
            public String getThreadId() {
                return PyStackFrame.this.thread.getId();
            }
        };
        this.target = target;
    }

    @Override
    public AbstractDebugTarget getTarget() {
        return this.target;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getThreadId() {
        return this.thread.getId();
    }

    public IVariableLocator getLocalsLocator() {
        return this.localsLocator;
    }

    public IVariableLocator getFrameLocator() {
        return this.frameLocator;
    }

    @Override
    public IVariableLocator getGlobalLocator() {
        return this.globalsLocator;
    }

    public IVariableLocator getExpressionLocator() {
        return this.expressionLocator;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public IPath getPath() {
        return this.path;
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variableContainer.getVariables();
    }

    public void forceGetNewVariables() {
        this.variableContainer.forceGetNewVariables();
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public int getLineNumber() throws DebugException {
        return this.line;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public void setCurrentStackFrame() {
        this.currentStackFrame = true;
    }

    public String getName() throws DebugException {
        String ret = StringUtils.join((String)"", (Object[])new Object[]{this.name, " [", this.path.lastSegment(), ":", Integer.toString(this.line), "]"});
        if (this.currentStackFrame) {
            ret = String.valueOf(ret) + "   <-- Current frame";
        }
        return ret;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public String getModelIdentifier() {
        return this.thread.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.thread.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.thread.getLaunch();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepIntoTarget(PyEdit pyEdit, int line, String selectedWord, SmartStepIntoVariant target) throws DebugException {
        this.thread.stepIntoTarget(pyEdit, line, selectedWord, target);
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public <T> T getAdapter(Class<T> adapter) {
        AdapterDebug.print(this, adapter);
        if (adapter.equals(ILaunch.class) || adapter.equals(IResource.class)) {
            return this.thread.getAdapter(adapter);
        }
        if (adapter.equals(ITaskListResourceAdapter.class)) {
            return null;
        }
        if (adapter.equals(IDebugTarget.class)) {
            return (T)this.thread.getDebugTarget();
        }
        if (adapter.equals(IRunToLineTarget.class)) {
            return (T)this.target.getRunToLineTarget();
        }
        if (adapter.equals(IPropertySource.class) || adapter.equals(ITaskListResourceAdapter.class) || adapter.equals(IToggleBreakpointsTarget.class)) {
            return (T)super.getAdapter(adapter);
        }
        AdapterDebug.printDontKnow(this, adapter);
        return (T)super.getAdapter(adapter);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PyStackFrame) {
            PyStackFrame sf = (PyStackFrame)obj;
            return this.id.equals(sf.id) && this.path.toString().equals(sf.path.toString()) && this.line == sf.line && this.getThreadId().equals(sf.getThreadId());
        }
        return false;
    }

    public GetVariableCommand getFrameCommand(AbstractDebugTarget dbg) {
        return new GetFrameCommand(dbg, this.frameLocator.getPyDBLocation());
    }

    @Override
    public GetVariableCommand getVariableCommand(AbstractDebugTarget target) {
        return this.getFrameCommand(target);
    }

    @Override
    public String getPyDBLocation() {
        return this.frameLocator.getPyDBLocation();
    }

    public AbstractRemoteDebugger getDebugger() {
        return this.target.getDebugger();
    }

    public String toString() {
        return "PyStackFrame: " + this.id;
    }

    public boolean isFileLoadedFromDebugger(IPath path) {
        if (path.lastSegment().startsWith("<") || path.lastSegment().startsWith("&lt;")) {
            return true;
        }
        if (this.target == null) {
            return false;
        }
        return this.target.isFileLoadedFromDebugger(path);
    }

    public void setFileLoadedFromDebugger(IPath path) {
        if (this.target != null) {
            this.target.setFileLoadedFromDebugger(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContents() {
        if (this.fileContents == null) {
            GetFileContentsCommand cmd = new GetFileContentsCommand(this.target, this.id);
            final Object lock = new Object();
            final String[] response = new String[1];
            cmd.setCompletionListener(new ICommandResponseListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void commandComplete(AbstractDebuggerCommand cmd) {
                    try {
                        response[0] = ((GetFileContentsCommand)cmd).getResponse();
                    }
                    catch (CoreException e) {
                        response[0] = "";
                    }
                    try {
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.target.postCommand(cmd);
            int timeout = PySourceLocatorPrefs.getFileContentsTimeout();
            long initialTimeMillis = System.currentTimeMillis();
            while (response[0] == null) {
                Object object = lock;
                synchronized (object) {
                    try {
                        lock.wait(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (System.currentTimeMillis() - initialTimeMillis > (long)timeout) break;
            }
            this.fileContents = response[0];
        }
        return this.fileContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEditorInput getEditorInputFromLoadedSource(IPath initialPath) {
        block17: {
            if (this.editorInput != null) {
                return this.editorInput;
            }
            try {
                String fileContents = this.getFileContents();
                if (fileContents == null || fileContents.length() <= 0) break block17;
                Object object = lock;
                synchronized (object) {
                    this.setFileLoadedFromDebugger(initialPath);
                    String lastSegment = this.path.lastSegment();
                    if (lastSegment.length() > 255) {
                        lastSegment = lastSegment.substring(0, 255);
                    }
                    lastSegment = lastSegment.replaceAll("[\\\\/:*?\"<>|]", "_");
                    File workspaceMetadataFile = CorePlugin.getWorkspaceMetadataFile((String)"temporary_files");
                    if (!workspaceMetadataFile.exists()) {
                        workspaceMetadataFile.mkdirs();
                    }
                    File file = new File(workspaceMetadataFile, lastSegment);
                    int i = 0;
                    while (i < 1000) {
                        if (file.exists()) {
                            if (Arrays.equals(FileUtils.getFileContentsBytes((File)file), fileContents.getBytes())) {
                                createdInCurrentSession.put((Object)file, (Object)file);
                                this.editorInput = EditorInputFactory.create((File)file, (boolean)true);
                                return this.editorInput;
                            }
                            if (!createdInCurrentSession.containsKey((Object)file)) {
                                createdInCurrentSession.put((Object)file, (Object)file);
                                file.delete();
                                FileUtils.writeStrToFile((String)fileContents, (File)file);
                                try {
                                    file.setReadOnly();
                                }
                                catch (Exception e) {
                                    Log.log((Throwable)e);
                                }
                                this.editorInput = EditorInputFactory.create((File)file, (boolean)true);
                                return this.editorInput;
                            }
                            Tuple splitted = StringUtils.splitExt((String)lastSegment);
                            file = ((String)splitted.o2).isEmpty() ? new File(workspaceMetadataFile, StringUtils.format((String)"%s-%s", (Object[])new Object[]{splitted.o1, i})) : new File(workspaceMetadataFile, StringUtils.format((String)"%s-%s.%s", (Object[])new Object[]{splitted.o1, i, splitted.o2}));
                        } else {
                            createdInCurrentSession.put((Object)file, (Object)file);
                            FileUtils.writeStrToFile((String)fileContents, (File)file);
                            try {
                                file.setReadOnly();
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                            this.editorInput = EditorInputFactory.create((File)file, (boolean)true);
                            return this.editorInput;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return null;
    }

    public SmartStepIntoVariant[] getStepIntoTargets() {
        GetSmartStepIntoVariants cmd = new GetSmartStepIntoVariants(this.target, this.thread.getId(), this.id, 0, 99999999);
        this.target.postCommand(cmd);
        try {
            cmd.waitUntilDone(PySourceLocatorPrefs.getFileContentsTimeout());
        }
        catch (InterruptedException e) {
            Log.log((Throwable)e);
        }
        return cmd.getResponse();
    }
}

