/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.AdapterDebug;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyConsoleCodeGeneratorVariable;
import org.python.pydev.debug.model.PyVariableContentProviderHack;
import org.python.pydev.debug.model.remote.ChangeVariableCommand;
import org.python.pydev.shared_interactive_console.console.codegen.IScriptConsoleCodeGenerator;

public class PyVariable
extends PlatformObject
implements IVariable,
IValue,
IVariableLocator {
    protected String name;
    protected String type;
    protected String qualifier;
    protected String value;
    protected String scope;
    protected AbstractDebugTarget target;
    protected boolean isModified;
    protected IVariableLocator locator;
    static final IVariable[] EMPTY_IVARIABLE_ARRAY = new IVariable[0];
    protected String id;
    private boolean isReturnValue;
    private boolean isIPythonHidden;
    private boolean isErrorOnEval;

    public PyVariable(AbstractDebugTarget target, String name, String type, String value, IVariableLocator locator, String scope) {
        this.value = value;
        this.name = name;
        this.type = type;
        this.target = target;
        this.locator = locator;
        this.scope = scope;
        this.isModified = false;
    }

    public void setRefererrerFoundInfo(String id, String foundAs) {
        if (foundAs != null && foundAs.length() > 0) {
            this.name = String.valueOf(this.name) + " Found as: " + foundAs;
        }
        if (id != null && id.length() > 0) {
            this.id = id;
        }
    }

    @Override
    public String getThreadId() {
        return this.locator.getThreadId();
    }

    @Override
    public String getPyDBLocation() {
        if (this.id == null) {
            return String.valueOf(this.locator.getPyDBLocation()) + "\t" + this.name;
        }
        return String.valueOf(this.locator.getThreadId()) + "\t" + this.id + "\tBY_ID";
    }

    @Override
    public String getUniqueId() {
        return String.valueOf(this.getPyDBLocation()) + this.isReturnValue;
    }

    public String getDetailText() throws DebugException {
        return this.getValueString();
    }

    public IValue getValue() throws DebugException {
        return this;
    }

    public String getValueString() throws DebugException {
        if (this.value == null) {
            return "";
        }
        if ("StringType".equals(this.type) || "UnicodeType".equals(this.type)) {
            return "\"" + this.value + "\"";
        }
        return this.value;
    }

    public void copyValueString(PyVariable newVariable) {
        this.type = newVariable.type;
        this.value = newVariable.value;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getModelIdentifier() {
        return this.target.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.target.getLaunch();
    }

    public boolean supportsValueModification() {
        return this.locator != null;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.isModified;
    }

    public void setModified(boolean mod) {
        this.isModified = mod;
    }

    public void setValue(String expression) throws DebugException {
        ChangeVariableCommand changeVariableCommand = this.getChangeVariableCommand(this.target, expression);
        if (changeVariableCommand != null) {
            this.target.postCommand(changeVariableCommand);
            this.value = expression;
            this.target.fireEvent(new DebugEvent((Object)this, 528));
        }
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        AdapterDebug.print(this, adapter);
        if (adapter.equals(ILaunch.class)) {
            return this.target.getAdapter(adapter);
        }
        if (adapter.equals(IRunToLineTarget.class)) {
            return (T)this.target.getRunToLineTarget();
        }
        if (adapter.equals(IScriptConsoleCodeGenerator.class)) {
            return (T)new PyConsoleCodeGeneratorVariable(this);
        }
        if (adapter.equals(IPropertySource.class) || adapter.equals(ITaskListResourceAdapter.class) || adapter.equals(IContributorResourceAdapter.class) || adapter.equals(IActionFilter.class) || adapter.equals(IWorkbenchAdapter.class) || adapter.equals(IToggleBreakpointsTarget.class) || adapter.equals(IResource.class) || adapter.equals(IFile.class)) {
            return (T)super.getAdapter(adapter);
        }
        if (adapter.toString().endsWith("org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider")) {
            return (T)((Object)new PyVariableContentProviderHack());
        }
        AdapterDebug.printDontKnow(this, adapter);
        return (T)super.getAdapter(adapter);
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return EMPTY_IVARIABLE_ARRAY;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.type;
    }

    public ChangeVariableCommand getChangeVariableCommand(AbstractDebugTarget dbg, String expression) {
        return new ChangeVariableCommand(dbg, this.getPyDBLocation(), expression);
    }

    public void forceGetNewVariables() {
    }

    public void setIsReturnValue(boolean isReturnValue) {
        this.isReturnValue = isReturnValue;
    }

    public boolean isReturnValue() {
        return this.isReturnValue;
    }

    public void setIsIPythonHidden(boolean isIPythonHidden) {
        this.isIPythonHidden = isIPythonHidden;
    }

    public boolean isIPythonHidden() {
        return this.isIPythonHidden;
    }

    public void setIsErrorOnEval(boolean isErrorOnEval) {
        this.isErrorOnEval = isErrorOnEval;
    }

    public boolean isErrorOnEval() {
        return this.isErrorOnEval;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }
}

