/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.shared_core.SharedCorePlugin;

public class PyVariablesPreferences {
    public static final String DEBUG_UI_VARIABLES_SHOW_SPECIAL_REFERENCES = "DEBUG_UI_VARIABLES_SHOW_SPECIAL_REFERENCES";
    public static final boolean DEBUG_UI_VARIABLES_DEFAULT_SHOW_SPECIAL_REFERENCES = false;
    public static final String DEBUG_UI_VARIABLES_SHOW_FUNCTION_REFERENCES = "DEBUG_UI_VARIABLES_SHOW_FUNCTION_REFERENCES";
    public static final boolean DEBUG_UI_VARIABLES_DEFAULT_SHOW_FUNCTION_REFERENCES = false;
    public static final String DEBUG_UI_VARIABLES_SHOW_CLASS_REFERENCES = "DEBUG_UI_VARIABLES_SHOW_CLASS_REFERENCES";
    public static final boolean DEBUG_UI_VARIABLES_DEFAULT_SHOW_CLASS_REFERENCES = true;
    public static final String DEBUG_UI_VARIABLES_SHOW_PROTECTED_REFERENCES = "DEBUG_UI_VARIABLES_SHOW_PROTECTED_REFERENCES";
    public static final boolean DEBUG_UI_VARIABLES_DEFAULT_SHOW_PROTECTED_REFERENCES = true;
    public static final String DEBUG_UI_VARIABLES_SHOW_CAPITALIZED_REFERENCES = "DEBUG_UI_VARIABLES_SHOW_CAPITALIZED_REFERENCES";
    public static final boolean DEBUG_UI_VARIABLES_DEFAULT_SHOW_CAPITALIZED_REFERENCES = true;
    public static final String DEBUG_UI_VARIABLES_SHOW_ALLUPPERCASE_REFERENCES = "DEBUG_UI_VARIABLES_SHOW_ALLUPPERCASE_REFERENCES";
    public static final boolean DEBUG_UI_VARIABLES_DEFAULT_SHOW_ALLUPPERCASE_REFERENCES = true;

    private static boolean getHelper(String key, boolean defaultValue) {
        if (SharedCorePlugin.inTestMode()) {
            return defaultValue;
        }
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        return preferenceStore.getBoolean(key);
    }

    private static void setHelper(String key, boolean value) {
        if (!SharedCorePlugin.inTestMode()) {
            PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
            IPreferenceStore preferenceStore = plugin.getPreferenceStore();
            preferenceStore.setValue(key, value);
        }
    }

    private static void setDefaultHelper(String key, boolean value) {
        if (!SharedCorePlugin.inTestMode()) {
            PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
            IPreferenceStore preferenceStore = plugin.getPreferenceStore();
            preferenceStore.setDefault(key, value);
        }
    }

    public static boolean isShowPrivateReferences() {
        return PyVariablesPreferences.getHelper(DEBUG_UI_VARIABLES_SHOW_SPECIAL_REFERENCES, false);
    }

    public static void setShowPrivateReferences(boolean value) {
        PyVariablesPreferences.setHelper(DEBUG_UI_VARIABLES_SHOW_SPECIAL_REFERENCES, value);
    }

    public static boolean isShowCapitalizedReferences() {
        return PyVariablesPreferences.getHelper(DEBUG_UI_VARIABLES_SHOW_CAPITALIZED_REFERENCES, true);
    }

    public static void setShowCapitalizedReferences(boolean value) {
        PyVariablesPreferences.setHelper(DEBUG_UI_VARIABLES_SHOW_CAPITALIZED_REFERENCES, value);
    }

    public static boolean isShowAllUppercaseReferences() {
        return PyVariablesPreferences.getHelper(DEBUG_UI_VARIABLES_SHOW_ALLUPPERCASE_REFERENCES, true);
    }

    public static void setShowAllUppercaseReferences(boolean value) {
        PyVariablesPreferences.setHelper(DEBUG_UI_VARIABLES_SHOW_ALLUPPERCASE_REFERENCES, value);
    }

    public static boolean isShowFunctionAndModuleReferences() {
        return PyVariablesPreferences.getHelper(DEBUG_UI_VARIABLES_SHOW_FUNCTION_REFERENCES, false);
    }

    public static void setShowFunctionAndModuleReferences(boolean value) {
        PyVariablesPreferences.setHelper(DEBUG_UI_VARIABLES_SHOW_FUNCTION_REFERENCES, value);
    }

    public static boolean isShowClassReferences() {
        return PyVariablesPreferences.getHelper(DEBUG_UI_VARIABLES_SHOW_CLASS_REFERENCES, true);
    }

    public static void setShowClassReferences(boolean value) {
        PyVariablesPreferences.setHelper(DEBUG_UI_VARIABLES_SHOW_CLASS_REFERENCES, value);
    }

    public static boolean isShowProtectedReferences() {
        return PyVariablesPreferences.getHelper(DEBUG_UI_VARIABLES_SHOW_PROTECTED_REFERENCES, true);
    }

    public static void setShowProtectedReferences(boolean value) {
        PyVariablesPreferences.setHelper(DEBUG_UI_VARIABLES_SHOW_PROTECTED_REFERENCES, value);
    }

    public static void initializeDefaultPreferences() {
        PyVariablesPreferences.setDefaultHelper(DEBUG_UI_VARIABLES_SHOW_SPECIAL_REFERENCES, false);
        PyVariablesPreferences.setDefaultHelper(DEBUG_UI_VARIABLES_SHOW_CAPITALIZED_REFERENCES, true);
        PyVariablesPreferences.setDefaultHelper(DEBUG_UI_VARIABLES_SHOW_ALLUPPERCASE_REFERENCES, true);
        PyVariablesPreferences.setDefaultHelper(DEBUG_UI_VARIABLES_SHOW_FUNCTION_REFERENCES, false);
        PyVariablesPreferences.setDefaultHelper(DEBUG_UI_VARIABLES_SHOW_CLASS_REFERENCES, true);
        PyVariablesPreferences.setDefaultHelper(DEBUG_UI_VARIABLES_SHOW_PROTECTED_REFERENCES, true);
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (!SharedCorePlugin.inTestMode()) {
            PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
            plugin.getPreferenceStore().removePropertyChangeListener(listener);
        }
    }

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!SharedCorePlugin.inTestMode()) {
            PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
            plugin.getPreferenceStore().addPropertyChangeListener(listener);
        }
    }
}

