/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.ContainerOfVariables;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.PyVariableCollection;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.GetVariableCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;
import org.python.pydev.shared_core.log.Log;

public class VariablesLoader
implements ICommandResponseListener {
    private volatile PyVariable[] currentVariables;
    private volatile PyVariable[] oldVariables;
    private final ContainerOfVariables parent;
    private IProgressMonitor monitor;
    private boolean addGlobalsVariable;

    public VariablesLoader(ContainerOfVariables parent, boolean addGlobalsVariable) {
        this.parent = parent;
        this.addGlobalsVariable = addGlobalsVariable;
    }

    private AbstractDebugTarget getTarget() {
        return this.parent.getTarget();
    }

    private IVariableLocator getLocator() {
        return this.parent.getLocator();
    }

    public PyVariable[] fetchVariables() {
        this.oldVariables = this.currentVariables;
        this.currentVariables = null;
        AbstractDebugTarget target = this.getTarget();
        if (target == null) {
            return new PyVariable[0];
        }
        GetVariableCommand variableCommand = this.parent.getVariableCommand(target);
        variableCommand.setCompletionListener(this);
        target.postCommand(variableCommand);
        return this.waitForCommand();
    }

    private PyVariable[] waitForCommand() {
        try {
            int i = 150;
            while (--i > 0 && this.currentVariables == null) {
                if (this.monitor != null && this.monitor.isCanceled()) {
                    return new PyVariable[0];
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            Log.log((Throwable)e);
        }
        if (this.currentVariables != null) {
            return this.currentVariables;
        }
        return new PyVariable[0];
    }

    @Override
    public void commandComplete(AbstractDebuggerCommand cmd) {
        AbstractDebugTarget target = this.getTarget();
        IVariableLocator locator = this.getLocator();
        if (target == null || locator == null) {
            return;
        }
        PyVariable[] temp = PyVariableCollection.getCommandVariables(cmd, target, locator);
        if (this.addGlobalsVariable) {
            PyVariable[] temp1 = new PyVariable[temp.length + 1];
            System.arraycopy(temp, 0, temp1, 1, temp.length);
            temp1[0] = new PyVariableCollection(target, "Globals", "frame.f_globals", "Global variables", this.parent.getGlobalLocator(), "");
            temp = temp1;
        }
        PyVariable[] newVars = this.verifyVariablesModified(temp, this.oldVariables);
        this.currentVariables = this.parent.setVariables(newVars);
    }

    private PyVariable[] verifyVariablesModified(PyVariable[] newFrameVariables, PyVariable[] oldVariables) {
        if (oldVariables == null || newFrameVariables == oldVariables) {
            return newFrameVariables;
        }
        ArrayList<PyVariable> newVarsList = new ArrayList<PyVariable>(newFrameVariables.length);
        PyVariable newVariable = null;
        try {
            HashMap<String, PyVariable> map = new HashMap<String, PyVariable>();
            PyVariable[] pyVariableArray = oldVariables;
            int n = oldVariables.length;
            int n2 = 0;
            while (n2 < n) {
                PyVariable var = pyVariableArray[n2];
                String uniqueId = var.getUniqueId();
                if (uniqueId != null) {
                    map.put(uniqueId, var);
                }
                ++n2;
            }
            HashMap<String, PyVariable> variablesAsMap = map;
            int i = 0;
            while (i < newFrameVariables.length) {
                newVariable = newFrameVariables[i];
                String uniqueId = newVariable.getUniqueId();
                if (uniqueId != null) {
                    PyVariable oldVariable = (PyVariable)variablesAsMap.get(uniqueId);
                    if (oldVariable != null) {
                        if (newVariable.getClass() != oldVariable.getClass()) {
                            newVariable.setModified(true);
                            newVarsList.add(newVariable);
                        } else {
                            String newValueString = newVariable.getValueString();
                            boolean equals = newValueString.equals(oldVariable.getValueString());
                            if (!equals) {
                                oldVariable.copyValueString(newVariable);
                            }
                            oldVariable.setModified(!equals);
                            oldVariable.forceGetNewVariables();
                            newVarsList.add(oldVariable);
                        }
                    } else {
                        newVariable.setModified(true);
                        newVarsList.add(newVariable);
                    }
                } else {
                    newVarsList.add(newVariable);
                }
                ++i;
            }
        }
        catch (DebugException e) {
            Log.log((Throwable)e);
        }
        return newVarsList.toArray(new PyVariable[0]);
    }
}

