/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.remote.ICommandResponseListener;
import org.python.pydev.shared_core.string.FastStringBuffer;

public abstract class AbstractDebuggerCommand {
    public static final int CMD_RUN = 101;
    public static final int CMD_LIST_THREADS = 102;
    public static final int CMD_THREAD_CREATED = 103;
    public static final int CMD_THREAD_KILL = 104;
    public static final int CMD_THREAD_SUSPEND = 105;
    public static final int CMD_THREAD_RUN = 106;
    public static final int CMD_STEP_INTO = 107;
    public static final int CMD_STEP_OVER = 108;
    public static final int CMD_STEP_RETURN = 109;
    public static final int CMD_GET_VARIABLE = 110;
    public static final int CMD_SET_BREAK = 111;
    public static final int CMD_REMOVE_BREAK = 112;
    public static final int CMD_EVALUATE_EXPRESSION = 113;
    public static final int CMD_GET_FRAME = 114;
    public static final int CMD_EXEC_EXPRESSION = 115;
    public static final int CMD_WRITE_TO_CONSOLE = 116;
    public static final int CMD_CHANGE_VARIABLE = 117;
    public static final int CMD_RUN_TO_LINE = 118;
    public static final int CMD_RELOAD_CODE = 119;
    public static final int CMD_GET_COMPLETIONS = 120;
    public static final int CMD_STOP_ON_START = 154;
    public static final int CMD_CONSOLE_EXEC = 121;
    public static final int CMD_ADD_EXCEPTION_BREAK = 122;
    public static final int CMD_REMOVE_EXCEPTION_BREAK = 123;
    public static final int CMD_LOAD_SOURCE = 124;
    public static final int CMD_ADD_DJANGO_EXCEPTION_BREAK = 125;
    public static final int CMD_REMOVE_DJANGO_EXCEPTION_BREAK = 126;
    public static final int CMD_SET_NEXT_STATEMENT = 127;
    public static final int CMD_SMART_STEP_INTO = 128;
    public static final int CMD_EXIT = 129;
    public static final int CMD_SIGNATURE_CALL_TRACE = 130;
    public static final int CMD_SET_PY_EXCEPTION = 131;
    public static final int CMD_SET_PY_EXCEPTION_JSON = 161;
    public static final int CMD_SET_PATH_MAPPING_JSON = 162;
    public static final int CMD_GET_FILE_CONTENTS = 132;
    public static final int CMD_SET_PROPERTY_TRACE = 133;
    public static final int CMD_EVALUATE_CONSOLE_EXPRESSION = 134;
    public static final int CMD_RUN_CUSTOM_OPERATION = 135;
    public static final int CMD_GET_BREAKPOINT_EXCEPTION = 136;
    public static final int CMD_STEP_CAUGHT_EXCEPTION = 137;
    public static final int CMD_SEND_CURR_EXCEPTION_TRACE = 138;
    public static final int CMD_SEND_CURR_EXCEPTION_TRACE_PROCEEDED = 139;
    public static final int CMD_IGNORE_THROWN_EXCEPTION_AT = 140;
    public static final int CMD_ENABLE_DONT_TRACE = 141;
    public static final int CMD_SHOW_RETURN_VALUES = 146;
    public static final int CMD_INPUT_REQUESTED = 147;
    public static final int CMD_PROCESS_CREATED = 149;
    public static final int CMD_GET_SMART_STEP_INTO_VARIANTS = 163;
    public static final int CMD_LOAD_SOURCE_FROM_FRAME_ID = 207;
    public static final int CMD_ERROR = 901;
    public static final int CMD_VERSION = 501;
    public static final int CMD_RETURN = 502;
    public static final int CMD_SET_PROTOCOL = 503;
    protected AbstractDebugTarget target;
    protected ICommandResponseListener responseListener;
    int sequence;

    public AbstractDebuggerCommand(AbstractDebugTarget debugger) {
        this.target = debugger;
        this.responseListener = null;
        this.sequence = debugger.getNextSequence();
    }

    public void setCompletionListener(ICommandResponseListener listener) {
        this.responseListener = listener;
    }

    public abstract String getOutgoing();

    public void aboutToSend() {
        if (this.needResponse()) {
            this.target.addToResponseQueue(this);
        }
    }

    public boolean needResponse() {
        return false;
    }

    public final int getSequence() {
        return this.sequence;
    }

    public final void processResponse(int cmdCode, String payload) {
        if (cmdCode / 100 == 9) {
            this.processErrorResponse(cmdCode, payload);
        } else {
            this.processOKResponse(cmdCode, payload);
        }
        if (this.responseListener != null) {
            this.responseListener.commandComplete(this);
        }
    }

    public void processOKResponse(int cmdCode, String payload) {
        PydevDebugPlugin.log(4, "Debugger command ignored response " + this.getClass().toString() + payload, null);
    }

    public void processErrorResponse(int cmdCode, String payload) {
        PydevDebugPlugin.log(4, "Debugger command ignored error response " + this.getClass().toString() + payload, null);
    }

    public static String makeCommand(int code, int sequence, String payload) {
        FastStringBuffer s = new FastStringBuffer(payload.length() + 20);
        s.append(code);
        s.append("\t");
        s.append(sequence);
        s.append("\t");
        s.append(payload);
        return s.toString();
    }
}

