/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.SmartStepIntoVariant;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;

public class GetSmartStepIntoVariants
extends AbstractDebuggerCommand {
    boolean done = false;
    private String frameId;
    private String threadId;
    private int startLine;
    private int endLine;
    private SmartStepIntoVariant[] response;

    public GetSmartStepIntoVariants(AbstractDebugTarget target, String threadId, String frameId, int startLine, int endLine) {
        super(target);
        this.threadId = threadId;
        this.frameId = frameId;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone(int timeout) throws InterruptedException {
        while (!this.done && timeout > 0) {
            timeout -= 50;
            GetSmartStepIntoVariants getSmartStepIntoVariants = this;
            synchronized (getSmartStepIntoVariants) {
                Thread.sleep(50L);
            }
        }
        if (timeout < 0) {
            throw new InterruptedException();
        }
    }

    @Override
    public String getOutgoing() {
        return GetSmartStepIntoVariants.makeCommand(163, this.sequence, String.valueOf(this.threadId) + "\t" + this.frameId + "\t" + this.startLine + "\t" + this.endLine);
    }

    @Override
    public boolean needResponse() {
        return true;
    }

    @Override
    public void processOKResponse(int cmdCode, String payload) {
        if (cmdCode != 163) {
            PydevDebugPlugin.log(4, "Unexpected response to CMD_GET_SMART_STEP_INTO_VARIANTS" + payload, null);
            return;
        }
        try {
            this.response = XMLUtils.SmartStepIntoTargetsFromXML(this.target, payload);
        }
        catch (CoreException e) {
            PydevDebugPlugin.log(4, "LIST THREADS got an unexpected response " + payload, null);
            Log.log((Throwable)e);
        }
        this.done = true;
    }

    @Override
    public void processErrorResponse(int cmdCode, String payload) {
        PydevDebugPlugin.log(4, "LIST THREADS got an error " + payload, null);
    }

    public SmartStepIntoVariant[] getResponse() {
        return this.response;
    }
}

