/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;

public class SetBreakpointCommand
extends AbstractDebuggerCommand {
    public final String file;
    public final Object line;
    public final String condition;
    private final String functionName;
    private final int breakpointId;
    private final String type;

    public SetBreakpointCommand(AbstractDebugTarget debugger, int breakpointId, String file, Object line, String condition, String functionName, String type) {
        super(debugger);
        this.file = file;
        this.line = line;
        this.condition = condition == null ? "None" : condition;
        this.functionName = functionName;
        this.breakpointId = breakpointId;
        this.type = type;
    }

    @Override
    public String getOutgoing() {
        if (this.file == null || this.line == null) {
            return null;
        }
        FastStringBuffer cmd = new FastStringBuffer().append(this.breakpointId).append('\t').append(this.type).append('\t').append(this.file).append('\t').appendObject(this.line);
        if (this.functionName != null) {
            cmd.append("\t").append(FullRepIterable.getLastPart((String)this.functionName).trim());
        } else {
            cmd.append("\tNone");
        }
        cmd.append('\t').append(this.condition);
        String expression = "None";
        cmd.append('\t').append(expression);
        return SetBreakpointCommand.makeCommand(111, this.sequence, cmd.toString());
    }
}

