/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.python.pydev.ast.codecompletion.IPyDevCompletionParticipant2;
import org.python.pydev.ast.codecompletion.ProposalsComparator;
import org.python.pydev.ast.simpleassist.ISimpleAssistParticipant2;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionRequest;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.docutils.ImportsSelection;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.interactive_console.IScriptConsoleViewer;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.debug.model.PyDebugTarget;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.editor.codecompletion.PyTemplateCompletionProcessor;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleCommunication;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleInterpreter;
import org.python.pydev.shared_interactive_console.console.InterpreterResponse;

public class PydevConsoleInterpreter
implements IScriptConsoleInterpreter {
    private IScriptConsoleCommunication consoleCommunication;
    private List<Runnable> closeRunnables = new ArrayList<Runnable>();
    private List<ISimpleAssistParticipant2> simpleParticipants;
    private Set<IPythonNature> initialNatures = new HashSet<IPythonNature>();
    private IInterpreterInfo interpreterInfo;
    private PyStackFrame frame;
    private ILaunch launch;
    private Process process;

    public PydevConsoleInterpreter() {
        List p = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_simpleassist");
        ArrayList<ISimpleAssistParticipant2> list = new ArrayList<ISimpleAssistParticipant2>();
        for (Object o : p) {
            if (!(o instanceof ISimpleAssistParticipant2)) continue;
            list.add((ISimpleAssistParticipant2)o);
        }
        this.simpleParticipants = list;
    }

    public void setOnContentsReceivedCallback(ICallback<Object, Tuple<String, String>> onContentsReceived) {
        this.consoleCommunication.setOnContentsReceivedCallback(onContentsReceived);
    }

    public void exec(String command, ICallback<Object, InterpreterResponse> onResponseReceived) {
        this.consoleCommunication.execInterpreter(command, onResponseReceived);
    }

    public void interrupt() {
        this.consoleCommunication.interrupt();
    }

    public void setFrame(PyStackFrame frame) throws Exception {
        this.frame = frame;
    }

    public ICompletionProposalHandle[] getCompletions(IScriptConsoleViewer viewer, String commandLine, int position, int offset, int whatToShow) throws Exception {
        String text = commandLine.substring(0, position);
        PySelection.ActivationTokenAndQualifier tokenAndQual = PySelection.getActivationTokenAndQualifier((IDocument)new Document(text), (int)text.length(), (boolean)true, (boolean)false);
        String textForCompletionInConsole = PySelection.getTextForCompletionInConsole((IDocument)new Document(text), (int)text.length());
        if (PySelection.isCompletionForLiteralNumber((String)tokenAndQual.activationToken)) {
            return new ICompletionProposalHandle[0];
        }
        ICodeCompletionASTManager.ImportInfo importsTipper = ImportsSelection.getImportsTipperStr((String)text, (boolean)false);
        Set<IPythonNature> natureAndRelatedNatures = this.getNatureAndRelatedNatures();
        if (importsTipper.importsTipperStr.length() != 0) {
            importsTipper.importsTipperStr = importsTipper.importsTipperStr.trim();
            TreeSet<IToken> tokens = new TreeSet<IToken>();
            boolean onlyGetDirectModules = true;
            for (final IPythonNature nature : natureAndRelatedNatures) {
                ICodeCompletionASTManager astManager = nature.getAstManager();
                TokensList importTokens = astManager.getCompletionsForImport(importsTipper, new ICompletionRequest(){

                    public IPythonNature getNature() {
                        return nature;
                    }

                    public File getEditorFile() {
                        return null;
                    }

                    public IModule getModule() throws MisconfigurationException {
                        return null;
                    }
                }, true);
                for (IterTokenEntry entry : importTokens) {
                    IToken iToken = entry.getToken();
                    tokens.add(iToken);
                }
            }
            int qlen = tokenAndQual.qualifier.length();
            ArrayList<ICompletionProposalHandle> ret = new ArrayList<ICompletionProposalHandle>(tokens.size());
            Iterator it = tokens.iterator();
            int i = 0;
            while (i < tokens.size()) {
                IToken t = (IToken)it.next();
                int replacementOffset = offset - qlen;
                String representation = t.getRepresentation();
                if (representation.startsWith(tokenAndQual.qualifier)) {
                    ret.add(CompletionProposalFactory.get().createPyLinkedModeCompletionProposal(representation, replacementOffset, qlen, representation.length(), t, null, null, 10, 1, "", null));
                }
                ++i;
            }
            return ret.toArray(new ICompletionProposalHandle[ret.size()]);
        }
        String actTok = tokenAndQual.activationToken;
        if (tokenAndQual.qualifier != null && tokenAndQual.qualifier.length() > 0) {
            if (actTok.length() > 0 && actTok.charAt(actTok.length() - 1) != '.') {
                actTok = String.valueOf(actTok) + '.';
            }
            actTok = String.valueOf(actTok) + tokenAndQual.qualifier;
        }
        boolean showOnlyTemplates = whatToShow == 2;
        boolean showForTabCompletion = whatToShow == 3;
        ArrayList results = new ArrayList();
        if (!showForTabCompletion) {
            for (ISimpleAssistParticipant2 participant : this.simpleParticipants) {
                results.addAll(participant.computeConsoleProposals(tokenAndQual.activationToken, tokenAndQual.qualifier, offset));
            }
        }
        ProposalsComparator proposalsComparator = new ProposalsComparator(tokenAndQual.qualifier, null);
        ArrayList<ICompletionProposalHandle> results2 = new ArrayList<ICompletionProposalHandle>();
        if (!showOnlyTemplates && this.consoleCommunication != null) {
            ICompletionProposalHandle[] consoleCompletions = this.consoleCommunication.getCompletions(text, textForCompletionInConsole, offset, showForTabCompletion);
            if (showForTabCompletion) {
                return consoleCompletions;
            }
            results2.addAll(Arrays.asList(consoleCompletions));
        }
        if (tokenAndQual.activationToken.length() == 0) {
            PyTemplateCompletionProcessor pyTemplateCompletionProcessor = new PyTemplateCompletionProcessor();
            pyTemplateCompletionProcessor.addTemplateProposals((ITextViewer)viewer, offset, results2);
        }
        Collections.sort(results2, proposalsComparator);
        ArrayList results3 = new ArrayList();
        if (!showOnlyTemplates) {
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_completion");
            for (Object participant : participants) {
                if (!(participant instanceof IPyDevCompletionParticipant2)) continue;
                IPyDevCompletionParticipant2 participant2 = (IPyDevCompletionParticipant2)participant;
                results3.addAll(participant2.computeConsoleCompletions(tokenAndQual, natureAndRelatedNatures, viewer, offset));
            }
            Collections.sort(results3, proposalsComparator);
        }
        results.addAll(results2);
        results.addAll(results3);
        return results.toArray(new ICompletionProposalHandle[results.size()]);
    }

    public String getDescription(IDocument doc, int position) throws Exception {
        String actTok = PySelection.getTextForCompletionInConsole((IDocument)doc, (int)position);
        return this.consoleCommunication.getDescription(actTok);
    }

    public void close() {
        if (this.consoleCommunication != null) {
            try {
                this.consoleCommunication.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.consoleCommunication = null;
        }
        for (Runnable r : this.closeRunnables) {
            r.run();
        }
        this.closeRunnables = null;
    }

    public void setConsoleCommunication(IScriptConsoleCommunication protocol) {
        this.consoleCommunication = protocol;
    }

    public IScriptConsoleCommunication getConsoleCommunication() {
        return this.consoleCommunication;
    }

    public void addCloseOperation(Runnable runnable) {
        this.closeRunnables.add(runnable);
    }

    public void setNaturesUsed(List<IPythonNature> localNaturesUsed) {
        if (localNaturesUsed == null) {
            localNaturesUsed = new ArrayList<IPythonNature>();
        }
        this.initialNatures = new HashSet<IPythonNature>(localNaturesUsed);
    }

    private Set<IPythonNature> getNatureAndRelatedNatures() {
        HashSet<IPythonNature> ret = new HashSet<IPythonNature>();
        for (IPythonNature iPythonNature : this.initialNatures) {
            try {
                IModulesManager[] managersInvolved;
                IModulesManager modulesManager;
                ICodeCompletionASTManager astManager = iPythonNature.getAstManager();
                if (astManager == null || (modulesManager = astManager.getModulesManager()) == null) continue;
                IModulesManager[] iModulesManagerArray = managersInvolved = modulesManager.getManagersInvolved(true);
                int n = managersInvolved.length;
                int n2 = 0;
                while (n2 < n) {
                    IModulesManager iModulesManager = iModulesManagerArray[n2];
                    ret.add(iModulesManager.getNature());
                    ++n2;
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return ret;
    }

    public void setInterpreterInfo(IInterpreterInfo interpreterInfo) {
        this.interpreterInfo = interpreterInfo;
    }

    public IInterpreterInfo getInterpreterInfo() {
        return this.interpreterInfo;
    }

    public void setLaunch(ILaunch launch) {
        this.launch = launch;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    public PyStackFrame getFrame() {
        return this.frame;
    }

    public void linkWithDebugSelection(boolean isLinkedWithDebug) {
        this.consoleCommunication.linkWithDebugSelection(isLinkedWithDebug);
    }

    public void setLaunchAndRelatedInfo(ILaunch launch) {
        this.setLaunch(launch);
        if (launch != null) {
            IDebugTarget debugTarget = launch.getDebugTarget();
            IInterpreterInfo projectInterpreter = null;
            if (debugTarget instanceof PyDebugTarget) {
                PyDebugTarget pyDebugTarget = (PyDebugTarget)debugTarget;
                PythonNature nature = PythonNature.getPythonNature((IProject)pyDebugTarget.project);
                if (nature != null) {
                    ArrayList<IPythonNature> natures = new ArrayList<IPythonNature>(1);
                    natures.add((IPythonNature)nature);
                    this.setNaturesUsed(natures);
                    try {
                        projectInterpreter = nature.getProjectInterpreter();
                        this.setInterpreterInfo(projectInterpreter);
                    }
                    catch (Throwable e1) {
                        Log.log((Throwable)e1);
                    }
                }
            }
        }
    }
}

